/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.driver.AbstractConfigurableDriver;
import org.neo4j.ogm.driver.ParameterConversionMode;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedBasedParameterConversion;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.testutil.SingleDriverTestClass;

public class EmbeddedBasedParameterConversionTest
extends SingleDriverTestClass {
    @Test
    public void shouldUseNativeTypesWhenNonNativeTypesOnlyIsActive() {
        Assume.assumeTrue((boolean)this.databaseSupportJava8TimeTypes());
        HashMap<String, ParameterConversionMode> customConfiguration = new HashMap<String, ParameterConversionMode>();
        customConfiguration.put(ParameterConversionMode.CONFIG_PARAMETER_CONVERSION_MODE, ParameterConversionMode.CONVERT_NON_NATIVE_ONLY);
        GraphDatabaseService graphDatabaseService = this.getGraphDatabaseService();
        EmbeddedDriver embeddedOgmDriver = new EmbeddedDriver(graphDatabaseService, () -> customConfiguration);
        this.doWithSessionFactoryOf((AbstractConfigurableDriver)embeddedOgmDriver, new Class[]{EmbeddedBasedParameterConversionTest.class}, sessionFactory -> {
            Session session = sessionFactory.openSession();
            LocalDateTime originalDateTime = LocalDateTime.of(2018, 10, 11, 15, 24);
            HashMap<String, LocalDateTime> parameters = new HashMap<String, LocalDateTime>();
            parameters.put("createdAt", originalDateTime);
            session.query("CREATE (n:Test {createdAt: $createdAt})", parameters);
            Object createdAt = graphDatabaseService.execute("MATCH (n:Test) RETURN n.createdAt AS createdAt").next().get("createdAt");
            ((AbstractObjectAssert)Assertions.assertThat(createdAt).isInstanceOf(LocalDateTime.class)).isEqualTo((Object)originalDateTime);
        });
    }

    @Test
    public void nestedConversions() {
        Assume.assumeTrue((boolean)this.databaseSupportJava8TimeTypes());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("aDate", ZonedDateTime.now());
        parameters.put("somethingElse", "Foobar");
        parameters.put("aDouble", 47.11);
        parameters.put("aNumber", new BigDecimal("42.23"));
        parameters.put("listOfDates", Arrays.asList(ZonedDateTime.now()));
        parameters.put("mapOfDates", Collections.singletonMap("aDate", ZonedDateTime.now()));
        parameters.put("arrayOfDates", new ZonedDateTime[]{ZonedDateTime.now()});
        Map convertedParameters = EmbeddedBasedParameterConversion.INSTANCE.convertParameters(parameters);
        Assertions.assertThat(convertedParameters.keySet()).containsAll(parameters.keySet());
        Assertions.assertThat(convertedParameters.get("aDate")).isInstanceOf(ZonedDateTime.class);
        Assertions.assertThat(convertedParameters.get("somethingElse")).isEqualTo((Object)"Foobar");
        Assertions.assertThat(convertedParameters.get("aDouble")).isEqualTo((Object)47.11);
        Assertions.assertThat(convertedParameters.get("aNumber")).isEqualTo((Object)new BigDecimal("42.23"));
        Assertions.assertThat(convertedParameters.get("listOfDates")).isInstanceOf(List.class);
        Assertions.assertThat(((List)convertedParameters.get("listOfDates")).get(0)).isInstanceOf(ZonedDateTime.class);
        Assertions.assertThat(convertedParameters.get("mapOfDates")).isInstanceOf(Map.class);
        Assertions.assertThat(((Map)convertedParameters.get("mapOfDates")).get("aDate")).isInstanceOf(ZonedDateTime.class);
        Assertions.assertThat(convertedParameters.get("arrayOfDates")).isInstanceOf(Object[].class);
        Assertions.assertThat((Object)((Object[])convertedParameters.get("arrayOfDates"))[0]).isInstanceOf(ZonedDateTime.class);
    }
}

