/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.drivers.embedded.driver;

import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.config.ClasspathConfigurationSource;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.config.ConfigurationSource;
import org.neo4j.ogm.drivers.embedded.driver.EmbeddedDriver;
import org.neo4j.ogm.support.ClassUtils;

public class EmbeddedDriverTest {
    public static final String NAME_OF_HA_DATABASE_CLASS = "HighlyAvailableGraphDatabase";

    @BeforeClass
    public static void assumeDefaultConfigurationIsDifferentFromCustom() {
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder().build());
            Result r = EmbeddedDriverTest.getValueOfCypherPlanner(driver.getGraphDatabaseService());
            Assume.assumeTrue((boolean)r.hasNext());
            Assume.assumeTrue((boolean)"default".equals(r.next().get("value")));
        }
    }

    @Test
    public void shouldHandleCustomConfFiles() {
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder().neo4jConfLocation("classpath:custom-neo4j.conf").build());
            EmbeddedDriverTest.assertCustomConfiguration(driver);
        }
    }

    @Test
    public void shouldHandleCustomConfFilesFromOgmProperties() {
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("ogm-pointing-to-custom-conf.properties")).build());
            EmbeddedDriverTest.assertCustomConfiguration(driver);
        }
    }

    @Test
    public void shouldLoadHaBasedOnHaPropertiesFile() {
        Assume.assumeTrue((boolean)EmbeddedDriverTest.canRunHATests());
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder((ConfigurationSource)new ClasspathConfigurationSource("embedded.ha.driver.properties")).build());
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            Assertions.assertThat((String)databaseService.getClass().getSimpleName()).isEqualTo((Object)NAME_OF_HA_DATABASE_CLASS);
        }
    }

    @Test
    public void shouldLoadHaBasedOnNeo4ConfFile() {
        Assume.assumeTrue((boolean)EmbeddedDriverTest.canRunHATests());
        try (EmbeddedDriver driver = new EmbeddedDriver();){
            driver.configure(new Configuration.Builder().neo4jConfLocation("classpath:custom-neo4j-ha.conf").build());
            GraphDatabaseService databaseService = driver.getGraphDatabaseService();
            Assertions.assertThat((String)databaseService.getClass().getSimpleName()).isEqualTo((Object)NAME_OF_HA_DATABASE_CLASS);
        }
    }

    private static boolean canRunHATests() {
        try {
            Class.forName("org.neo4j.graphdb.factory.HighlyAvailableGraphDatabaseFactory", false, ClassUtils.getDefaultClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void assertCustomConfiguration(EmbeddedDriver driver) {
        Result r = EmbeddedDriverTest.getValueOfCypherPlanner(driver.getGraphDatabaseService());
        Assertions.assertThat((boolean)r.hasNext()).isTrue();
        Assertions.assertThat(r.next().get("value")).isEqualTo((Object)"COST");
    }

    private static Result getValueOfCypherPlanner(GraphDatabaseService databaseService) {
        return databaseService.execute("CALL dbms.listConfig()\nYIELD name,  value\nWHERE name ='cypher.planner'\nRETURN value");
    }
}

