/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.ogm.domain.cineasts.partial.Knows;
import org.neo4j.ogm.domain.cineasts.partial.Rating;
import org.neo4j.ogm.domain.cineasts.partial.Role;
import org.neo4j.ogm.domain.education.Student;
import org.neo4j.ogm.domain.forum.Member;
import org.neo4j.ogm.domain.forum.activity.Activity;
import org.neo4j.ogm.domain.forum.activity.Post;
import org.neo4j.ogm.domain.pizza.Pizza;
import org.neo4j.ogm.exception.core.InvalidPropertyFieldException;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.InterfaceInfo;
import org.neo4j.ogm.metadata.LabelsAnnotationWithWrongTye;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.utils.EntityUtils;

public class ClassInfoTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    private MetaData metaData;

    @Before
    public void setUp() {
        this.metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.pizza", "org.neo4j.ogm.metadata", "org.neo4j.ogm.domain.canonical", "org.neo4j.ogm.domain.hierarchy.domain", "org.neo4j.ogm.domain.cineasts.partial", "org.neo4j.ogm.domain.annotations.ids"});
    }

    @Test
    public void identityField() {
        ClassInfo classInfo = this.metaData.classInfo("Login");
        Assertions.assertThat((String)classInfo.identityField().getName()).isEqualTo((Object)"id");
        classInfo = this.metaData.classInfo("Bronze");
        Assertions.assertThat((String)classInfo.identityField().getName()).isEqualTo((Object)"id");
        classInfo = this.metaData.classInfo("ValidAnnotations$InternalIdWithAnnotation");
        Assertions.assertThat((String)classInfo.identityField().getName()).isEqualTo((Object)"identifier");
    }

    @Test
    public void testAnnotatedIdentity() {
        ClassInfo classInfo = this.metaData.classInfo("Topic");
        Assertions.assertThat((String)classInfo.identityField().getName()).isEqualTo((Object)"topicId");
    }

    @Test
    public void testPropertyFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Bronze");
        Collection fieldInfos = classInfo.propertyFields();
        int count = 1;
        Assertions.assertThat((int)fieldInfos.size()).isEqualTo(count);
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!fieldInfo.getName().equals("fees")) continue;
            --count;
        }
        Assertions.assertThat((int)count).isEqualTo(0);
    }

    @Test
    public void invalidPropertyFieldsShouldGiveBetterError() {
        this.expectedException.expect(InvalidPropertyFieldException.class);
        this.expectedException.expectMessage("'org.neo4j.ogm.domain.forum.LeadMembership#yearOfRegistration' is not persistable as property but has not been marked as transient.");
        this.metaData.classInfo("Lead").propertyFields();
    }

    @Test
    public void testIndexFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Login");
        Assertions.assertThat((boolean)classInfo.containsIndexes()).isTrue();
        Collection fieldInfos = classInfo.getIndexFields();
        int count = 1;
        Assertions.assertThat((int)fieldInfos.size()).isEqualTo(count);
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!fieldInfo.getName().equals("userName")) continue;
            --count;
        }
        Assertions.assertThat((int)count).isEqualTo(0);
        FieldInfo userNameField = (FieldInfo)fieldInfos.iterator().next();
        Assertions.assertThat((boolean)userNameField.isConstraint()).isTrue();
    }

    @Test
    public void testIndexFieldInfoForIdAnnotation() throws Exception {
        ClassInfo classInfo = this.metaData.classInfo("ValidAnnotations$Basic");
        Assertions.assertThat((boolean)classInfo.containsIndexes()).isTrue();
        Collection fieldInfos = classInfo.getIndexFields();
        Assertions.assertThat((int)fieldInfos.size()).isEqualTo(1);
        FieldInfo fieldInfo = (FieldInfo)fieldInfos.iterator().next();
        Assertions.assertThat((String)fieldInfo.getName()).isEqualTo((Object)"identifier");
        Assertions.assertThat((boolean)fieldInfo.isConstraint()).isTrue();
    }

    @Test
    public void testAnnotatedPropertyFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Bronze");
        Collection fieldInfos = classInfo.propertyFields();
        FieldInfo fieldInfo = (FieldInfo)fieldInfos.iterator().next();
        Assertions.assertThat((String)fieldInfo.property()).isEqualTo((Object)"annualFees");
        Assertions.assertThat((String)fieldInfo.getName()).isEqualTo((Object)"fees");
    }

    @Test
    public void testPropertyFieldIsNotARelationshipField() {
        ClassInfo classInfo = this.metaData.classInfo("Bronze");
        Collection fieldInfos = classInfo.propertyFields();
        FieldInfo fieldInfo = (FieldInfo)fieldInfos.iterator().next();
        Assertions.assertThat((String)fieldInfo.relationship()).isNull();
    }

    @Test
    public void testRelationshipFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Member");
        Collection fieldInfos = classInfo.relationshipFields();
        int count = 4;
        Assertions.assertThat((int)fieldInfos.size()).isEqualTo(count);
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getName().equals("activityList")) {
                --count;
            }
            if (fieldInfo.getName().equals("followees")) {
                --count;
            }
            if (fieldInfo.getName().equals("memberShip")) {
                --count;
            }
            if (!fieldInfo.getName().equals("followers")) continue;
            --count;
        }
        Assertions.assertThat((int)count).isEqualTo(0);
    }

    @Test
    public void testAnnotatedRelationshipFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Topic");
        Collection fieldInfos = classInfo.relationshipFields();
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!fieldInfo.getName().equals("posts")) continue;
            Assertions.assertThat((String)fieldInfo.relationship()).isEqualTo((Object)"HAS_POSTS");
        }
    }

    @Test
    public void testNonAnnotatedRelationshipFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Topic");
        Collection fieldInfos = classInfo.relationshipFields();
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!fieldInfo.getName().equals("posts")) continue;
            Assertions.assertThat((String)fieldInfo.relationship()).isEqualTo((Object)"HAS_POSTS");
        }
    }

    @Test
    public void testRelationshipFieldIsNotAPropertyField() {
        ClassInfo classInfo = this.metaData.classInfo("Member");
        Collection fieldInfos = classInfo.relationshipFields();
        FieldInfo fieldInfo = (FieldInfo)fieldInfos.iterator().next();
        Assertions.assertThat((String)fieldInfo.property()).isNull();
    }

    @Test
    public void testNamedPropertyField() {
        ClassInfo classInfo = this.metaData.classInfo("Gold");
        FieldInfo fieldInfo = classInfo.propertyField("annualFees");
        Assertions.assertThat((String)fieldInfo.getName()).isEqualTo((Object)"fees");
    }

    @Test
    public void testNamedRelationshipField() {
        ClassInfo classInfo = this.metaData.classInfo("Topic");
        FieldInfo fieldInfo = classInfo.relationshipField("HAS_POSTS");
        Assertions.assertThat((String)fieldInfo.getName()).isEqualTo((Object)"posts");
    }

    @Test
    public void testRelationshipGetters() {
        ClassInfo classInfo = this.metaData.classInfo("User");
        Collection relationshipFields = classInfo.relationshipFields();
        int count = 4;
        Assertions.assertThat((int)relationshipFields.size()).isEqualTo(count);
        for (FieldInfo relationshipField : relationshipFields) {
            if (relationshipField.getName().equals("activityList")) {
                --count;
            }
            if (relationshipField.getName().equals("followees")) {
                --count;
            }
            if (relationshipField.getName().equals("memberShip")) {
                --count;
            }
            if (!relationshipField.getName().equals("followers")) continue;
            --count;
        }
        Assertions.assertThat((int)count).isEqualTo(0);
    }

    @Test
    public void testPropertyGetters() {
        ClassInfo classInfo = this.metaData.classInfo("User");
        Collection propertyFields = classInfo.propertyFields();
        int count = 5;
        Assertions.assertThat((int)propertyFields.size()).isEqualTo(count);
        for (FieldInfo propertyField : propertyFields) {
            if (propertyField.getName().equals("renewalDate")) {
                --count;
            }
            if (propertyField.getName().equals("userName")) {
                --count;
            }
            if (propertyField.getName().equals("password")) {
                --count;
            }
            if (propertyField.getName().equals("membershipNumber")) {
                --count;
            }
            if (!propertyField.getName().equals("nicknames")) continue;
            --count;
        }
        Assertions.assertThat((int)count).isEqualTo(0);
    }

    @Test
    public void testClassInfoIsFoundForFQN() {
        String fqn = "org.neo4j.ogm.domain.forum.Topic";
        ClassInfo classInfo = this.metaData.classInfo(fqn);
        Assertions.assertThat((String)classInfo.name()).isEqualTo((Object)fqn);
    }

    @Test
    public void testFindDateField() {
        ClassInfo classInfo = this.metaData.classInfo("Member");
        List fieldInfos = classInfo.findFields(Date.class);
        FieldInfo fieldInfo = (FieldInfo)fieldInfos.iterator().next();
        Assertions.assertThat((String)fieldInfo.getName()).isEqualTo((Object)"renewalDate");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
    }

    @Test
    public void testFindIterableFields() {
        ClassInfo classInfo = this.metaData.classInfo("User");
        List fieldInfos = classInfo.findIterableFields();
        int count = 4;
        Assertions.assertThat((int)fieldInfos.size()).isEqualTo(count);
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getName().equals("followees")) {
                --count;
            }
            if (fieldInfo.getName().equals("followers")) {
                --count;
            }
            if (fieldInfo.getName().equals("activityList")) {
                --count;
            }
            if (!fieldInfo.getName().equals("nicknames")) continue;
            --count;
        }
        Assertions.assertThat((int)count).isEqualTo(0);
    }

    @Test
    public void testStaticLabelsForClassInfo() {
        ClassInfo annotatedClassInfo = this.metaData.classInfo(Member.class.getSimpleName());
        Assertions.assertThat((Iterable)annotatedClassInfo.staticLabels()).containsExactly((Object[])new String[]{"User", "Login"});
        ClassInfo simpleClassInfo = this.metaData.classInfo("Topic");
        Assertions.assertThat((Iterable)simpleClassInfo.staticLabels()).containsOnly((Object[])new String[]{"Topic"});
        ClassInfo nonAnnotatedClassInfo = new MetaData(new String[]{"org.neo4j.ogm.domain.education"}).classInfo(Student.class.getSimpleName());
        Assertions.assertThat((Iterable)nonAnnotatedClassInfo.staticLabels()).containsExactly((Object[])new String[]{"Student", "DomainObject"});
    }

    @Test
    public void labelFieldOrNull() {
        ClassInfo classInfo = this.metaData.classInfo(Pizza.class.getSimpleName());
        FieldInfo fieldInfo = classInfo.labelFieldOrNull();
        Assertions.assertThat((Object)fieldInfo).isNotNull();
        Assertions.assertThat((String)fieldInfo.getName()).isEqualTo((Object)"labels");
    }

    @Test
    public void labelFieldOrNullThrowsMappingExceptionForInvalidType() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            LabelsAnnotationWithWrongTye entity = new LabelsAnnotationWithWrongTye();
            Collection collatedLabels = EntityUtils.labels((Object)entity, (MetaData)this.metaData);
        }).isInstanceOf(MappingException.class)).hasMessage("Field 'labels' in class 'org.neo4j.ogm.metadata.LabelsAnnotationWithWrongTye' includes the @Labels annotation, however this field is not a type of collection.");
    }

    @Test
    public void testClassInfoForAbstractClassImplementingInterface() {
        Assertions.assertThat((int)this.metaData.classInfo("Membership").interfacesInfo().list().size()).isEqualTo(1);
    }

    @Test
    public void testClassInfoForAbstractClassImplementingInterfaceName() {
        Assertions.assertThat((boolean)((InterfaceInfo)this.metaData.classInfo("Membership").interfacesInfo().list().iterator().next()).toString().contains("IMembership")).isTrue();
    }

    @Test
    public void testCollectionFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Member");
        FieldInfo fieldInfo = classInfo.relationshipField("followers");
        Assertions.assertThat((boolean)fieldInfo.isScalar()).isFalse();
    }

    @Test
    public void testArrayFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Member");
        FieldInfo fieldInfo = classInfo.fieldsInfo().get("nicknames");
        Assertions.assertThat((boolean)fieldInfo.isScalar()).isFalse();
    }

    @Test
    public void testScalarFieldInfo() {
        ClassInfo classInfo = this.metaData.classInfo("Member");
        FieldInfo fieldInfo = classInfo.fieldsInfo().get("userName");
        Assertions.assertThat((boolean)fieldInfo.isScalar()).isTrue();
    }

    @Test
    public void testDefaultLabelOfNodeEntities() {
        ClassInfo classInfo = this.metaData.classInfo("Forum");
        Assertions.assertThat((String)classInfo.neo4jName()).isEqualTo((Object)"Forum");
    }

    @Test
    public void testDefaultLabelOfRelationshipEntities() {
        ClassInfo classInfo = this.metaData.classInfo("Nomination");
        Assertions.assertThat((String)classInfo.neo4jName()).isEqualTo((Object)"NOMINATION");
    }

    @Test
    public void testTypeParameterDescriptorForRelationships() {
        ClassInfo classInfo = this.metaData.classInfo("Topic");
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("HAS_POSTS", "OUTGOING")).isEqualTo(Post.class);
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("HAS_POSTS", "INCOMING")).isNull();
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("DOES_NOT_EXIST", "OUTGOING")).isNull();
        classInfo = this.metaData.classInfo("Member");
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("HAS_ACTIVITY", "OUTGOING")).isEqualTo(Activity.class);
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("FOLLOWERS", "OUTGOING")).isEqualTo(Member.class);
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("FOLLOWEES", "OUTGOING")).isEqualTo(Member.class);
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("HAS_ACTIVITY", "INCOMING")).isNull();
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("FOLLOWERS", "INCOMING")).isNull();
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("FOLLOWEES", "INCOMING")).isNull();
        classInfo = this.metaData.classInfo("Actor");
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("ACTS_IN", "OUTGOING")).isEqualTo(Role.class);
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("KNOWS", "OUTGOING")).isEqualTo(Knows.class);
        classInfo = this.metaData.classInfo("Movie");
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("ACTS_IN", "INCOMING")).isEqualTo(Role.class);
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("RATED", "INCOMING")).isEqualTo(Rating.class);
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("ACTS_IN", "OUTGOING")).isNull();
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("ACTS_IN", "OUTGOING")).isNull();
        Assertions.assertThat((Class)classInfo.getTypeParameterDescriptorForRelationship("HAS", "OUTGOING")).isNull();
    }

    @Test
    public void shouldExcludeStaticInitialisersFromPersistenceMethods() {
        ClassInfo classInfo = this.metaData.classInfo("SecurityRole");
        Collection methodInfos = classInfo.methodsInfo().findMethodInfoBy(m -> true);
        for (MethodInfo methodInfo : methodInfos) {
            Assertions.assertThat((boolean)methodInfo.getName().equals("<clinit>")).isFalse();
        }
    }
}

