/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.gh809.package1.TestEntity;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;

public class DomainInfoTest {
    private DomainInfo domainInfo;

    @Before
    public void setUp() {
        this.domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.gh806", "org.neo4j.ogm.domain.gh809"});
    }

    @Test
    public void testInterfaceClassIMembership() {
        ClassInfo classInfo = this.domainInfo.getClassSimpleName("IMembership");
        Assertions.assertThat((Object)classInfo).isNotNull();
        Assertions.assertThat((List)classInfo.directImplementingClasses()).hasSize(5);
    }

    @Test
    public void shouldFindAllSubclasses() {
        ClassInfo classInfo = this.domainInfo.getClassSimpleName("Element");
        Assertions.assertThat((Iterable)classInfo.allSubclasses()).containsExactlyInAnyOrder((Object[])new ClassInfo[]{this.domainInfo.getClassSimpleName("ConcreteElement"), this.domainInfo.getClassSimpleName("VeryConcreteElementA"), this.domainInfo.getClassSimpleName("VeryConcreteElementB"), this.domainInfo.getClassSimpleName("EvenMoreConcreteElement")});
    }

    @Test
    public void shouldFindAllImplementingClasses() {
        ClassInfo classInfo = this.domainInfo.getClassSimpleName("IElement");
        Assertions.assertThat((Iterable)classInfo.allSubclasses()).containsExactlyInAnyOrder((Object[])new ClassInfo[]{this.domainInfo.getClassSimpleName("IElementImpl1"), this.domainInfo.getClassSimpleName("IElementImpl1A")});
    }

    @Test
    public void testAbstractClassMembership() {
        ClassInfo classInfo = this.domainInfo.getClassSimpleName("Membership");
        Assertions.assertThat((Object)classInfo).isNotNull();
        Assertions.assertThat((List)classInfo.directInterfaces()).hasSize(1);
    }

    @Test
    public void testConcreteClassSilverMembership() {
        ClassInfo classInfo = this.domainInfo.getClassSimpleName("SilverMembership");
        Assertions.assertThat((Object)classInfo).isNotNull();
        Assertions.assertThat((Iterable)classInfo.interfacesInfo().list()).hasSize(1);
    }

    @Test
    public void shouldCorrectlyFindMultipleClassesWithSimpleNameIfAnnotated() {
        ClassInfo classInfo = this.domainInfo.getClassSimpleName("TestEntity");
        Assertions.assertThat((Class)classInfo.getUnderlyingClass()).isSameAs(TestEntity.class);
    }
}

