/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.food.entities.scanned.Pizza;
import org.neo4j.ogm.domain.food.entities.scanned.Risk;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class EnumsScannedTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.food.entities.scanned"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
    }

    @After
    public void tearDown() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldHandleEnumWithNoConverterOrPropertyAnnotation() {
        Pizza pizza = new Pizza();
        pizza.strokeRisk = Risk.LOW;
        this.session.save((Object)pizza);
        this.session.clear();
        pizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.id);
        Assertions.assertThat((Object)pizza).isNotNull();
        Assertions.assertThat((Comparable)((Object)pizza.strokeRisk)).isEqualTo((Object)Risk.LOW);
        Assertions.assertThat((Comparable)((Object)pizza.cancerRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.diabetesRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.hypertensionRisk)).isNull();
    }

    @Test
    public void shouldHandleEnumWithConverterButNoPropertyAnnotation() {
        Pizza pizza = new Pizza();
        pizza.diabetesRisk = Risk.HIGH;
        this.session.save((Object)pizza);
        this.session.clear();
        pizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.id);
        Assertions.assertThat((Object)pizza).isNotNull();
        Assertions.assertThat((Comparable)((Object)pizza.diabetesRisk)).isEqualTo((Object)Risk.HIGH);
        Assertions.assertThat((Comparable)((Object)pizza.cancerRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.strokeRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.hypertensionRisk)).isNull();
    }

    @Test
    public void shouldHandleEnumWithPropertyAnnotationButNoConverter() {
        Pizza pizza = new Pizza();
        pizza.cancerRisk = Risk.LOW;
        this.session.save((Object)pizza);
        this.session.clear();
        pizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.id);
        Assertions.assertThat((Object)pizza).isNotNull();
        Assertions.assertThat((Comparable)((Object)pizza.cancerRisk)).isEqualTo((Object)Risk.LOW);
        Assertions.assertThat((Comparable)((Object)pizza.diabetesRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.strokeRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.hypertensionRisk)).isNull();
    }

    @Test
    public void shouldHandleEnumWithConverterAndPropertyAnnotation() {
        Pizza pizza = new Pizza();
        pizza.hypertensionRisk = Risk.HIGH;
        this.session.save((Object)pizza);
        this.session.clear();
        pizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.id);
        Assertions.assertThat((Object)pizza).isNotNull();
        Assertions.assertThat((Comparable)((Object)pizza.hypertensionRisk)).isEqualTo((Object)Risk.HIGH);
        Assertions.assertThat((Comparable)((Object)pizza.diabetesRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.strokeRisk)).isNull();
        Assertions.assertThat((Comparable)((Object)pizza.cancerRisk)).isNull();
    }
}

