/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.Serializable;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.gh492.BaseUser;
import org.neo4j.ogm.domain.gh704.Country;
import org.neo4j.ogm.domain.gh704.CountryRevision;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.POJO;
import org.neo4j.ogm.metadata.TestMetaDataTypeResolution;

public class GenericsFieldsTest
extends TestMetaDataTypeResolution {
    @Test
    public void testUnboundedGeneric() {
        this.checkField("genericObject", "java.lang.Object", Object.class, null);
    }

    @Test
    public void testGenericComparable() {
        this.checkField("genericComparable", "java.lang.Comparable", Comparable.class, null);
    }

    @Test
    public void testGenericSerializable() {
        this.checkField("genericSerializable", "java.io.Serializable", Serializable.class, null);
    }

    @Test
    public void testGenericSelfReference() {
        this.checkField("next", "org.neo4j.ogm.metadata.POJO", POJO.class, null);
    }

    @Test
    public void testCollectionWithUnboundGenericParameter() {
        this.checkField("elements", "java.lang.Object", Object.class, "java.util.List");
    }

    @Test
    public void testCollectionWithConcreteParameterizedType() {
        this.checkField("neighbours", "org.neo4j.ogm.metadata.POJO", POJO.class, "java.util.List");
    }

    @Test
    public void testCollectionWithExtendedConcreteParameterizedType() {
        this.checkField("superIntegers", "java.lang.Object", Object.class, "java.util.List");
    }

    @Test
    public void testCollectionWithReducedConcreteParameterizedType() {
        this.checkField("subIntegers", "java.lang.Object", Object.class, "java.util.List");
    }

    @Test
    public void testCollectionOfWildcardExtendingGenericType() {
        this.checkField("superS", "java.lang.Object", Object.class, "java.util.List");
    }

    @Test
    public void testCollectionOfWildcardReducingGenericType() {
        this.checkField("subS", "java.lang.Object", Object.class, "java.util.List");
    }

    @Test
    public void testListGenericWildcard() {
        this.checkField("listOfAnything", "java.lang.Object", Object.class, "java.util.List");
    }

    @Test
    public void testVectorGenericWildcard() {
        this.checkField("vectorOfAnything", "java.lang.Object", Object.class, "java.util.Vector");
    }

    @Test
    public void testSetGenericWildcard() {
        this.checkField("setOfAnything", "java.lang.Object", Object.class, "java.util.Set");
    }

    @Test
    public void testIterableOfMapOfParameterizedClasses() {
        this.checkField("iterable", "java.util.Map", Map.class, "java.lang.Iterable");
    }

    @Test
    public void shouldDetectPrimitiveArraysInGenericFields() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh492"});
        ClassInfo classInfo = metaData.classInfo(BaseUser.IntUser.class);
        FieldInfo fieldInfo = classInfo.getFieldInfo("genericValue");
        Assertions.assertThat((boolean)fieldInfo.isArray()).isTrue();
        Assertions.assertThat((Class)fieldInfo.type()).isEqualTo(int[].class);
    }

    @Test
    public void shouldDetectWrapperArraysInGenericFields() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh492"});
        ClassInfo classInfo = metaData.classInfo(BaseUser.IntegerUser.class);
        FieldInfo fieldInfo = classInfo.getFieldInfo("genericValue");
        Assertions.assertThat((boolean)fieldInfo.isArray()).isTrue();
        Assertions.assertThat((Class)fieldInfo.type()).isEqualTo(Integer[].class);
    }

    @Test
    public void parameterizedFieldsInParentClassesShouldWork() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh656"});
        ClassInfo classInfo = metaData.classInfo("Group");
        Assertions.assertThat((Object)classInfo).isNotNull();
        Assertions.assertThat((Object)classInfo.getFieldInfo("uuid")).isNotNull();
        FieldInfo hasVersionField = classInfo.relationshipField("HAS_VERSION");
        Assertions.assertThat((Object)hasVersionField).isNotNull();
        Assertions.assertThat((String)hasVersionField.getCollectionClassname()).isEqualTo((Object)"java.util.Set");
        Assertions.assertThat((String)hasVersionField.getTypeDescriptor()).isEqualTo((Object)"org.neo4j.ogm.domain.gh656.GroupVersion");
    }

    @Test
    public void parameterizedScalarFieldsInParentClassesShouldWork() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh704"});
        for (String[] parameters : new String[][]{{"Country", "org.neo4j.ogm.domain.gh704.CountryRevision"}, {"org.neo4j.ogm.domain.gh704.CountryRevision", "org.neo4j.ogm.domain.gh704.CountryRevision"}, {"org.neo4j.ogm.domain.gh704.RevisionEntity", "java.lang.Object"}}) {
            ClassInfo classInfo = metaData.classInfo(parameters[0]);
            Assertions.assertThat((Object)classInfo).isNotNull();
            Assertions.assertThat((Object)classInfo.relationshipFieldByName("previousRevision")).satisfies(field -> {
                Assertions.assertThat((Object)field).isNotNull();
                Assertions.assertThat((String)field.getTypeDescriptor()).isEqualTo((Object)parameters[1]);
                Assertions.assertThat((String)field.relationship()).isEqualTo((Object)"PREVIOUS_REVISION");
            });
        }
    }

    @Test
    public void correctClassesNeedToBeUsedDuringFieldLookup() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh704"});
        Country old = new Country();
        old.setName("old");
        Country newCountry = new Country();
        newCountry.setName("new");
        newCountry.setPreviousRevision(old);
        CountryRevision newCountryRevision = new CountryRevision();
        newCountry.setName("new");
        newCountry.setPreviousRevision(old);
        for (CountryRevision countryRevision : new CountryRevision[]{newCountry, newCountryRevision}) {
            ClassInfo classInfo = metaData.classInfo(countryRevision.getClass());
            CountryRevision oldRevision = (CountryRevision)classInfo.relationshipFieldByName("previousRevision").read((Object)newCountry);
            Assertions.assertThat((Object)oldRevision).isSameAs((Object)old);
        }
    }
}

