/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.annotations.ids.ValidAnnotations;
import org.neo4j.ogm.id.UuidStrategy;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;

public class IdAnnotationTest {
    private MetaData metaData;

    @Before
    public void setUp() throws Exception {
        this.metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.annotations.ids"});
    }

    @Test
    public void shouldSupportClassWithoutId() throws Exception {
        ValidAnnotations.WithoutId entity = new ValidAnnotations.WithoutId();
        ClassInfo classInfo = this.metaData.classInfo((Object)entity);
        Assertions.assertThat((Object)classInfo.identityFieldOrNull()).isNull();
        Assertions.assertThat((String)classInfo.primaryIndexField().getName()).isEqualTo((Object)"identifier");
    }

    @Test
    public void shouldFindInternalIdentifier() throws Exception {
        ValidAnnotations.InternalIdWithAnnotation entity = new ValidAnnotations.InternalIdWithAnnotation();
        ClassInfo classInfo = this.metaData.classInfo((Object)entity);
        Assertions.assertThat((Object)classInfo.primaryIndexField()).isNull();
    }

    @Test
    public void shouldFindBasicId() throws Exception {
        ValidAnnotations.Basic entity = new ValidAnnotations.Basic();
        ClassInfo classInfo = this.metaData.classInfo((Object)entity);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)classInfo.primaryIndexField().getName()).isNotNull()).isEqualTo((Object)"identifier");
    }

    @Test
    public void shouldFindBasicChild() throws Exception {
        ValidAnnotations.BasicChild entity = new ValidAnnotations.BasicChild();
        ClassInfo classInfo = this.metaData.classInfo((Object)entity);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)classInfo.primaryIndexField().getName()).isNotNull()).isEqualTo((Object)"identifier");
    }

    @Test
    public void shouldFindIdAndGenerationType() throws Exception {
        ValidAnnotations.IdAndGenerationType entity = new ValidAnnotations.IdAndGenerationType();
        ClassInfo classInfo = this.metaData.classInfo((Object)entity);
        Assertions.assertThat((Object)classInfo.primaryIndexField()).isNotNull();
        ((AbstractObjectAssert)Assertions.assertThat((Object)classInfo.idStrategy()).isNotNull()).isInstanceOf(UuidStrategy.class);
    }
}

