/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import org.junit.Test;
import org.neo4j.ogm.domain.annotations.ids.ValidAnnotations;
import org.neo4j.ogm.domain.invalid.ids.InvalidAnnotations;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.metadata.MetaData;

public class InvalidIdAnnotationTest {
    private MetaData metaData;

    @Test(expected=MetadataException.class)
    public void shouldRejectTwoIdsOnSameClass() throws Exception {
        this.createMetadataAndCheckIdentityField(InvalidAnnotations.TwoIdsOnSameClass.class.getName());
    }

    @Test(expected=MetadataException.class)
    public void shouldRejectNeitherGraphIdOrId() throws Exception {
        this.createMetadataAndCheckIdentityField(InvalidAnnotations.NeitherGraphIdOrId.class.getName());
    }

    @Test(expected=MetadataException.class)
    public void shouldRejectBothIdAndPrimaryIndexOnDifferentProperty() throws Exception {
        this.createMetadataAndCheckIdentityField(InvalidAnnotations.BothIdAndPrimaryIndexOnDifferentProperty.class.getName());
    }

    @Test(expected=MetadataException.class)
    public void shouldRejectChildHasPrimaryIndexExtendsAndParentHasId() throws Exception {
        this.metaData = new MetaData(new String[]{ValidAnnotations.Basic.class.getName(), InvalidAnnotations.ChildHasPrimaryIndexExtendsAndParentHasId.class.getName()});
    }

    @Test(expected=MetadataException.class)
    public void shouldRejectUuidGenerationStrategyWithIdTypeNotUuid() throws Exception {
        this.createMetadataAndCheckIdentityField(InvalidAnnotations.UuidGenerationStrategyWithIdTypeNotUuid.class.getName());
    }

    @Test(expected=MetadataException.class)
    public void shouldRejectGeneratedValueWithoutID() throws Exception {
        this.createMetadataAndCheckIdentityField(InvalidAnnotations.GeneratedValueWithoutID.class.getName());
    }

    private void createMetadataAndCheckIdentityField(String name) {
        this.metaData = new MetaData(new String[]{name});
        this.metaData.classInfo(name).identityField();
    }
}

