/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.annotations.ids.ValidAnnotations;
import org.neo4j.ogm.domain.autoindex.valid.Invoice;
import org.neo4j.ogm.domain.cineasts.annotated.ExtendedUser;
import org.neo4j.ogm.domain.cineasts.annotated.User;
import org.neo4j.ogm.domain.cineasts.partial.Actor;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class LookupByPrimaryIndexTests
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.annotated", "org.neo4j.ogm.domain.annotations.ids", "org.neo4j.ogm.domain.autoindex.valid"});
    }

    @Before
    public void setUp() {
        this.session = sessionFactory.openSession();
    }

    @Test
    public void loadUsesIdWhenPresent() {
        ValidAnnotations.Basic entity = new ValidAnnotations.Basic();
        entity.identifier = "id1";
        this.session.save((Object)entity);
        Session session2 = sessionFactory.openSession();
        ValidAnnotations.Basic retrievedEntity = (ValidAnnotations.Basic)session2.load(ValidAnnotations.Basic.class, (Serializable)((Object)"id1"));
        Assertions.assertThat((Object)retrievedEntity).isNotNull();
        Assertions.assertThat((String)retrievedEntity.identifier).isEqualTo((Object)entity.identifier);
    }

    @Test
    public void loadUsesIdWhenPresentOnParent() {
        ValidAnnotations.BasicChild entity = new ValidAnnotations.BasicChild();
        entity.identifier = "id1";
        this.session.save((Object)entity);
        Session session2 = sessionFactory.openSession();
        ValidAnnotations.Basic retrievedEntity = (ValidAnnotations.Basic)session2.load(ValidAnnotations.Basic.class, (Serializable)((Object)"id1"));
        Assertions.assertThat((Object)retrievedEntity).isNotNull();
        Assertions.assertThat((String)retrievedEntity.identifier).isEqualTo((Object)entity.identifier);
    }

    @Test
    public void saveWithStringUuidGeneration() {
        ValidAnnotations.IdAndGenerationType entity = new ValidAnnotations.IdAndGenerationType();
        this.session.save((Object)entity);
        Assertions.assertThat((String)entity.identifier).isNotNull();
        Session session2 = sessionFactory.openSession();
        ValidAnnotations.IdAndGenerationType retrievedEntity = (ValidAnnotations.IdAndGenerationType)session2.load(ValidAnnotations.IdAndGenerationType.class, (Serializable)((Object)entity.identifier));
        Assertions.assertThat((Object)retrievedEntity).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)retrievedEntity.identifier).isNotNull()).isEqualTo((Object)entity.identifier);
    }

    @Test
    public void saveWithUuidGeneration() {
        ValidAnnotations.UuidIdAndGenerationType entity = new ValidAnnotations.UuidIdAndGenerationType();
        this.session.save((Object)entity);
        Assertions.assertThat((Comparable)entity.identifier).isNotNull();
        Session session2 = sessionFactory.openSession();
        ValidAnnotations.UuidIdAndGenerationType retrievedEntity = (ValidAnnotations.UuidIdAndGenerationType)session2.load(ValidAnnotations.UuidIdAndGenerationType.class, (Serializable)entity.identifier);
        Assertions.assertThat((Object)retrievedEntity).isNotNull();
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)retrievedEntity.identifier).isNotNull()).isEqualTo((Object)entity.identifier);
    }

    @Test
    public void loadUsesPrimaryIndexWhenPresent() {
        User user1 = new User("login1", "Name 1", "password");
        this.session.save((Object)user1);
        Session session2 = sessionFactory.openSession();
        User retrievedUser1 = (User)session2.load(User.class, (Serializable)((Object)"login1"));
        Assertions.assertThat((Object)retrievedUser1).isNotNull();
        Assertions.assertThat((String)retrievedUser1.getLogin()).isEqualTo((Object)user1.getLogin());
    }

    @Test
    public void loadAllUsesPrimaryIndexWhenPresent() {
        User user1 = new User("login1", "Name 1", "password");
        this.session.save((Object)user1);
        User user2 = new User("login2", "Name 2", "password");
        this.session.save((Object)user2);
        this.session.clear();
        Collection users = this.session.loadAll(User.class, Arrays.asList("login1", "login2"));
        Assertions.assertThat((int)users.size()).isEqualTo(2);
        this.session.clear();
        users = this.session.loadAll(User.class, Arrays.asList("login1", "login2"), 0);
        Assertions.assertThat((int)users.size()).isEqualTo(2);
        this.session.clear();
        users = this.session.loadAll(User.class, Arrays.asList("login1", "login2"), -1);
        Assertions.assertThat((int)users.size()).isEqualTo(2);
    }

    @Test
    public void loadUsesPrimaryIndexWhenPresentOnSuperclass() {
        ExtendedUser user1 = new ExtendedUser("login2", "Name 2", "password");
        this.session.save((Object)user1);
        Session session2 = sessionFactory.openSession();
        User retrievedUser1 = (User)session2.load(ExtendedUser.class, (Serializable)((Object)"login2"));
        Assertions.assertThat((Object)retrievedUser1).isNotNull();
        Assertions.assertThat((String)retrievedUser1.getLogin()).isEqualTo((Object)user1.getLogin());
    }

    @Test
    public void loadUsesGraphIdWhenPrimaryIndexNotPresent() {
        SessionFactory sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.partial"});
        Session session1 = sessionFactory.openSession();
        Actor actor = new Actor("David Hasslehoff");
        session1.save((Object)actor);
        Long id = actor.getId();
        Session session2 = sessionFactory.openSession();
        Actor retrievedActor = (Actor)session2.load(Actor.class, (Serializable)id);
        Assertions.assertThat((Object)retrievedActor).isNotNull();
        Assertions.assertThat((String)retrievedActor.getName()).isEqualTo((Object)actor.getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void exceptionRaisedWhenLookupIsDoneWithGraphIdAndThereIsAPrimaryIndexPresent() {
        Session session = sessionFactory.openSession();
        User user1 = new User("login1", "Name 1", "password");
        session.save((Object)user1);
        Session session2 = sessionFactory.openSession();
        session2.load(User.class, (Serializable)user1.getId());
    }

    @Test
    public void loadUsesPrimaryIndexWhenPresentEvenIfTypeIsLong() {
        Invoice invoice = new Invoice(223L, "Company", 100000L);
        this.session.save((Object)invoice);
        Session session2 = sessionFactory.openSession();
        Invoice retrievedInvoice = (Invoice)session2.load(Invoice.class, (Serializable)Long.valueOf(223L));
        Assertions.assertThat((Object)retrievedInvoice).isNotNull();
        Assertions.assertThat((Long)retrievedInvoice.getId()).isEqualTo((Object)invoice.getId());
    }

    @Test
    public void loadShouldNotMixLongPrimaryIndexAndGraphId() throws Exception {
        Invoice invoice1 = new Invoice(223L, "Company", 100000L);
        this.session.save((Object)invoice1);
        Invoice invoice2 = new Invoice(invoice1.getId(), "Company", 100000L);
        this.session.save((Object)invoice2);
        Invoice loaded = (Invoice)this.session.load(Invoice.class, (Serializable)invoice2.getNumber());
        Assertions.assertThat((Object)loaded).isEqualTo((Object)invoice2);
        Collection invoices = this.session.loadAll(Invoice.class);
        Assertions.assertThat((Iterable)invoices).containsOnly((Object[])new Invoice[]{invoice1, invoice2});
    }

    @Test(expected=IllegalArgumentException.class)
    public void exceptionRaisedWhenLookupDoneByNonLongKeyAndThereIsNoPrimaryIndex() throws Exception {
        SessionFactory sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.partial"});
        Session session1 = sessionFactory.openSession();
        Actor actor = new Actor("David Hasslehoff");
        session1.save((Object)actor);
        session1.load(Actor.class, (Serializable)((Object)"david-id"));
    }

    @Test
    public void loadShouldNotMixPrimaryKeysOfDifferentLabels() throws Exception {
        User user = new User("login", "name", "password");
        this.session.save((Object)user);
        ValidAnnotations.IdAndGenerationType entity = new ValidAnnotations.IdAndGenerationType();
        entity.identifier = "login";
        this.session.save((Object)entity);
        User loadedUser = (User)this.session.load(User.class, (Serializable)((Object)"login"));
        Assertions.assertThat((Object)loadedUser).isEqualTo((Object)user);
        ValidAnnotations.IdAndGenerationType loadedEntity = (ValidAnnotations.IdAndGenerationType)this.session.load(ValidAnnotations.IdAndGenerationType.class, (Serializable)((Object)"login"));
        Assertions.assertThat((Object)loadedEntity).isEqualTo((Object)entity);
    }
}

