/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Transient;
import org.neo4j.ogm.domain.hierarchy.domain.trans.TransientSingleClass;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;

public class TransientObjectsTest {
    private MetaData metaData;

    @Before
    public void setUp() {
        this.metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.pizza", "org.neo4j.ogm.metadata", "org.neo4j.ogm.domain.canonical", "org.neo4j.ogm.domain.hierarchy.domain", "org.neo4j.ogm.domain.cineasts.annotated"});
    }

    @Test
    public void testFieldMarkedWithTransientModifierIsNotInMetaData() {
        ClassInfo classInfo = this.metaData.classInfo("PersistableClass");
        Assertions.assertThat((Object)classInfo).isNotNull();
        FieldInfo fieldInfo = classInfo.propertyField("transientObject");
        Assertions.assertThat((Object)fieldInfo).isNull();
    }

    @Test
    public void testClassAnnotatedTransientIsExcludedFromMetaData() {
        ClassInfo classInfo = this.metaData.classInfo("TransientObjectsTest$TransientClass");
        Assertions.assertThat((Object)classInfo).isNull();
    }

    @Test
    public void testFieldAnnotatedTransientIsExcludedFromMetaData() {
        ClassInfo classInfo = this.metaData.classInfo("PersistableClass");
        FieldInfo fieldInfo = classInfo.propertyField("chickenCounting");
        Assertions.assertThat((Object)fieldInfo).isNull();
    }

    @Test
    public void testMethodWithTransientReturnTypeIsExcludedFromRelationshipFields() {
        ClassInfo classInfo = this.metaData.classInfo("PersistableClass");
        FieldInfo fieldInfo = classInfo.relationshipField("TRANSIENT_SINGLE_CLASS");
        Assertions.assertThat((Object)fieldInfo).isNull();
        for (FieldInfo field : classInfo.relationshipFields()) {
            if (!field.getName().equals("transientSingleClassField")) continue;
            Assertions.fail((String)"transientSingleClassField should not be returned in relationshipFields");
        }
    }

    @Transient
    public class TransientClass {
        private Long id;
    }

    @NodeEntity(label="PersistableClass")
    public class PersistableClass {
        private Long id;
        @Transient
        private transient String transientObject;
        @Transient
        private Integer chickenCounting;
        public TransientSingleClass transientSingleClassField;

        public String getTransientObject() {
            return this.transientObject;
        }

        public void setTransientObject(String value) {
            this.transientObject = value;
        }

        public TransientSingleClass getTransientSingleClass() {
            return null;
        }
    }
}

