/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.annotation.Property;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.domain.forum.ForumTopicLink;
import org.neo4j.ogm.domain.forum.Member;
import org.neo4j.ogm.domain.forum.Topic;
import org.neo4j.ogm.domain.forum.activity.Comment;
import org.neo4j.ogm.domain.forum.activity.Post;
import org.neo4j.ogm.domain.satellites.Program;
import org.neo4j.ogm.domain.satellites.Satellite;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.reflect.EntityAccessManager;

public class EntityAccessManagerTest {
    private DomainInfo domainInfo;

    @Before
    public void setup() {
        this.domainInfo = DomainInfo.create((String[])new String[]{"org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.satellites", "org.neo4j.ogm.metadata.reflect"});
    }

    @Test
    public void shouldPreferAnnotatedFieldToPlainMethodWhenFindingPropertyToSet() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        FieldInfo objectAccess = classInfo.getFieldInfo("testProp");
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        DummyDomainObject domainObject = new DummyDomainObject();
        objectAccess.write((Object)domainObject, (Object)"TEST");
        Assertions.assertThat((String)domainObject.annotatedTestProperty).isEqualTo((Object)"TEST");
    }

    @Test
    public void shouldPreferAnnotatedFieldToMethodNotAnnotatedWithPropertyWhenFindingPropertyToSet() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        FieldInfo objectAccess = classInfo.getFieldInfo("testIgnored");
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((boolean)(objectAccess instanceof FieldInfo)).isTrue();
        Assertions.assertThat((Class)objectAccess.type()).isEqualTo(String.class);
        objectAccess.write((Object)domainObject, (Object)"TEST");
        Assertions.assertThat((String)domainObject.propertyMethodsIgnored).isEqualTo((Object)"TEST");
    }

    @Test
    public void shouldAccessViaFieldCorrespondingToPropertyIfNoAnnotationsOrAccessorMethodsArePresent() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.propertyWithoutAccessorMethods = 9;
        FieldInfo writer = classInfo.getFieldInfo("propertyWithoutAccessorMethods");
        Assertions.assertThat((Object)writer).as("The resultant writer shouldn't be null", new Object[0]).isNotNull();
        writer.write((Object)domainObject, (Object)27);
        Assertions.assertThat((int)domainObject.propertyWithoutAccessorMethods).isEqualTo(27);
        FieldInfo reader = classInfo.getFieldInfo("propertyWithoutAccessorMethods");
        Assertions.assertThat((Object)reader).as("The resultant reader shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)reader.readProperty((Object)domainObject)).isEqualTo((Object)domainObject.propertyWithoutAccessorMethods);
    }

    @Test
    public void shouldRetrieveObjectAccessForWritingIterableObject() {
        ClassInfo classInfo = this.domainInfo.getClass(Program.class.getName());
        FieldInfo iterableAccess = EntityAccessManager.getIterableField((ClassInfo)classInfo, Satellite.class, (String)"satellites", (String)"OUTGOING");
        Assertions.assertThat((Object)iterableAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        Program spaceProgramme = new Program();
        iterableAccess.write((Object)spaceProgramme, Arrays.asList(new Satellite()));
        ((ListAssert)Assertions.assertThat(spaceProgramme.getSatellites()).as("The satellites list wasn't set correctly", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)spaceProgramme.getSatellites().isEmpty()).as("The satellites list wasn't set correctly", new Object[0])).isFalse();
    }

    @Test
    public void shouldPreferAnnotatedFieldToPlainSetterMatchingRelationshipTypeWhenSettingRelationshipObject() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        Member parameter = new Member();
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"CONTAINS", (String)"OUTGOING", (Object)parameter);
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        DummyDomainObject domainObject = new DummyDomainObject();
        objectAccess.write((Object)domainObject, (Object)parameter);
        Assertions.assertThat((Object)parameter).isEqualTo((Object)domainObject.member);
        Member otherMember = new Member();
        objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"REGISTERED", (String)"OUTGOING", (Object)otherMember);
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        domainObject = new DummyDomainObject();
        objectAccess.write((Object)domainObject, (Object)otherMember);
        Assertions.assertThat((Object)otherMember).isEqualTo((Object)domainObject.registeredMember);
    }

    @Test
    public void shouldPreferFieldBasedOnRelationshipTypeToPlainSetterWithMatchingParameterType() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        Topic favouriteTopic = new Topic();
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"FAVOURITE_TOPIC", (String)"OUTGOING", (Object)favouriteTopic);
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        DummyDomainObject domainObject = new DummyDomainObject();
        objectAccess.write((Object)domainObject, (Object)favouriteTopic);
        Assertions.assertThat((Object)favouriteTopic).isEqualTo((Object)domainObject.favouriteTopic);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)domainObject.topicAccessorWasCalled).as("The access should be via the field", new Object[0])).isFalse();
    }

    @Test
    public void shouldDefaultToFieldThatMatchesTheParameterTypeIfRelationshipTypeCannotBeMatchedAndNoSetterExists() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        Post forumPost = new Post();
        FieldInfo objectAccess = EntityAccessManager.getRelationalWriter((ClassInfo)classInfo, (String)"UTTER_RUBBISH", (String)"OUTGOING", (Object)forumPost);
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        DummyDomainObject domainObject = new DummyDomainObject();
        objectAccess.write((Object)domainObject, (Object)forumPost);
        Assertions.assertThat((Object)forumPost).isEqualTo((Object)domainObject.postWithoutAccessorMethods);
    }

    @Test
    public void shouldPreferAnnotatedFieldToPlainGetterWhenReadingFromAnObject() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.annotatedTestProperty = "more arbitrary text";
        FieldInfo objectAccess = classInfo.getFieldInfo("testProp");
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)objectAccess.readProperty((Object)domainObject)).isEqualTo((Object)domainObject.annotatedTestProperty);
    }

    @Test
    public void shouldPreferAnnotatedFieldToGetterWhenReadingFromAnObject() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.propertyWithDifferentAnnotatedGetter = "more arbitrary text";
        Collection readers = classInfo.propertyFields();
        FieldInfo objectAccess = classInfo.getFieldInfo("differentAnnotationOnGetter");
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)objectAccess.readProperty((Object)domainObject)).isEqualTo((Object)domainObject.propertyWithDifferentAnnotatedGetter);
        for (FieldInfo reader : readers) {
            if (!reader.propertyName().equals("differentAnnotationOnGetter")) continue;
            Assertions.assertThat((boolean)(reader instanceof FieldInfo)).isTrue();
        }
    }

    @Test
    public void shouldPreferMethodBasedAccessToFieldAccessWhenReadingFromObjectsWithoutAnnotations() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.nonAnnotatedTestProperty = new Double(30.16);
        FieldInfo objectAccess = classInfo.getFieldInfo("nonAnnotatedTestProperty");
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)objectAccess.readProperty((Object)domainObject)).isEqualTo((Object)domainObject.nonAnnotatedTestProperty);
    }

    @Test
    public void shouldPreferAnnotatedFieldToPlainGetterMethodMatchingRelationshipType() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.member = new Member();
        domainObject.registeredMember = new Member();
        FieldInfo reader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"CONTAINS", (String)"OUTGOING");
        Assertions.assertThat((Object)reader).as("The resultant object reader shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)reader.read((Object)domainObject)).isSameAs((Object)domainObject.member);
        Assertions.assertThat((String)reader.relationshipType()).isEqualTo((Object)"CONTAINS");
        reader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"REGISTERED", (String)"OUTGOING");
        Assertions.assertThat((Object)reader).as("The resultant object reader shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)reader.read((Object)domainObject)).isSameAs((Object)domainObject.registeredMember);
        Assertions.assertThat((String)reader.relationshipType()).isEqualTo((Object)"REGISTERED");
    }

    @Test
    public void shouldReadFromFieldMatchingRelationshipTypeInObjectWithoutAnnotationsOrAccessorMethods() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.postWithoutAccessorMethods = new Post();
        FieldInfo reader = EntityAccessManager.getRelationalReader((ClassInfo)classInfo, (String)"POST_WITHOUT_ACCESSOR_METHODS", (String)"OUTGOING");
        Assertions.assertThat((Object)reader).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)reader.read((Object)domainObject)).isSameAs((Object)domainObject.postWithoutAccessorMethods);
        Assertions.assertThat((String)reader.relationshipType()).isEqualTo((Object)"POST_WITHOUT_ACCESSOR_METHODS");
    }

    @Test
    public void shouldUseFieldAccessUnconditionallyForReadingIdentityProperty() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        long id = 593L;
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.setId(593L);
        FieldInfo idReader = classInfo.identityField();
        Assertions.assertThat((Object)idReader).as("The resultant ID reader shouldn't be null", new Object[0]).isNotNull();
        Assertions.assertThat((Object)idReader.readProperty((Object)domainObject)).isEqualTo((Object)593L);
    }

    @Test
    public void shouldRetrieveAppropriateObjectAccessToAllRelationalAttributesForParticularClass() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.postWithoutAccessorMethods = new Post();
        domainObject.favouriteTopic = new Topic();
        domainObject.member = new Member();
        domainObject.readOnlyComment = new Comment();
        domainObject.registeredMember = new Member();
        domainObject.naturalSatellites = new ArrayList<Satellite>();
        domainObject.artificialSatellites = Collections.singletonList(new Satellite());
        Collection relationalAccessors = classInfo.relationshipFields();
        ((IterableAssert)Assertions.assertThat((Iterable)relationalAccessors).as("The resultant list of object accessors shouldn't be null", new Object[0])).isNotNull();
        ((IterableAssert)Assertions.assertThat((Iterable)relationalAccessors).as("An unexpected number of accessors was returned", new Object[0])).hasSize(7);
        HashMap<String, Class<FieldInfo>> expectedRelationalReaders = new HashMap<String, Class<FieldInfo>>();
        expectedRelationalReaders.put("COMMENT", FieldInfo.class);
        expectedRelationalReaders.put("FAVOURITE_TOPIC", FieldInfo.class);
        expectedRelationalReaders.put("CONTAINS", FieldInfo.class);
        expectedRelationalReaders.put("POST_WITHOUT_ACCESSOR_METHODS", FieldInfo.class);
        expectedRelationalReaders.put("NATURAL", FieldInfo.class);
        expectedRelationalReaders.put("ARTIFICIAL", FieldInfo.class);
        expectedRelationalReaders.put("REGISTERED", FieldInfo.class);
        for (FieldInfo objectAccess : relationalAccessors) {
            String relType = objectAccess.relationshipType();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)expectedRelationalReaders.containsKey(relType)).as("Relationship type " + relType + " wasn't expected", new Object[0])).isTrue();
            Assertions.assertThat(objectAccess.getClass()).isEqualTo(expectedRelationalReaders.get(relType));
            Assertions.assertThat((Object)objectAccess.read((Object)domainObject)).isNotNull();
        }
    }

    @Test
    public void shouldRetrieveAppropriateObjectAccessToEndNodeAttributeOnRelationshipEntity() {
        ClassInfo relationshipEntityClassInfo = this.domainInfo.getClass(ForumTopicLink.class.getName());
        FieldInfo endNodeReader = relationshipEntityClassInfo.getEndNodeReader();
        Assertions.assertThat((Object)endNodeReader).as("The resultant end node reader shouldn't be null", new Object[0]).isNotNull();
        ForumTopicLink forumTopicLink = new ForumTopicLink();
        Topic topic = new Topic();
        forumTopicLink.setTopic(topic);
        Assertions.assertThat((Object)endNodeReader.read((Object)forumTopicLink)).as("The value wasn't read correctly", new Object[0]).isSameAs((Object)topic);
    }

    @Test
    public void shouldReturnNullOnAttemptToAccessNonExistentEndNodeAttributeOnRelationshipEntity() {
        ClassInfo classInfoOfNonRelationshipEntity = this.domainInfo.getClass(Member.class.getName());
        Assertions.assertThat((Object)classInfoOfNonRelationshipEntity.getEndNodeReader()).isNull();
    }

    @Test
    public void shouldPreferAnnotatedFieldWithMatchingRelationshipTypeWhenGettingIterableWriter() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        ArrayList<Satellite> natural = new ArrayList<Satellite>();
        natural.add(new Satellite());
        FieldInfo objectAccess = EntityAccessManager.getIterableField((ClassInfo)classInfo, Satellite.class, (String)"NATURAL", (String)"OUTGOING");
        Assertions.assertThat((Object)objectAccess).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        DummyDomainObject domainObject = new DummyDomainObject();
        objectAccess.write((Object)domainObject, natural);
        Assertions.assertThat(domainObject.naturalSatellites).isEqualTo(natural);
    }

    @Test
    public void shouldPreferAnnotatedFieldWithMatchingRelationshipTypeWhenGettingIterableReader() {
        ClassInfo classInfo = this.domainInfo.getClass(DummyDomainObject.class.getName());
        ArrayList<Satellite> natural = new ArrayList<Satellite>();
        natural.add(new Satellite());
        FieldInfo relationalReader = EntityAccessManager.getIterableField((ClassInfo)classInfo, Satellite.class, (String)"NATURAL", (String)"OUTGOING");
        Assertions.assertThat((Object)relationalReader).as("The resultant object accessor shouldn't be null", new Object[0]).isNotNull();
        DummyDomainObject domainObject = new DummyDomainObject();
        domainObject.naturalSatellites = natural;
        Object o = relationalReader.read((Object)domainObject);
        Assertions.assertThat((Object)o).isEqualTo(natural);
    }

    public static class DummyDomainObject {
        @Property(name="testProp")
        String annotatedTestProperty;
        Double nonAnnotatedTestProperty;
        boolean nonAnnotatedTestPropertyAccessorWasCalled;
        @Property(name="testAnnoProp")
        String fullyAnnotatedProperty;
        @Property(name="testIgnored")
        String propertyMethodsIgnored;
        @Property(name="differentAnnotationOnGetter")
        String propertyWithDifferentAnnotatedGetter;
        boolean fullyAnnotatedPropertyAccessorWasCalled;
        int propertyWithoutAccessorMethods;
        @Relationship(type="CONTAINS")
        Member member;
        @Relationship(type="REGISTERED")
        Member registeredMember;
        @Relationship(type="NATURAL")
        List<Satellite> naturalSatellites;
        @Relationship(type="ARTIFICIAL")
        List<Satellite> artificialSatellites;
        Topic favouriteTopic;
        boolean topicAccessorWasCalled;
        Post postWithoutAccessorMethods;
        @Relationship(type="COMMENT")
        Comment readOnlyComment;
        private Long id;

        public Long getId() {
            throw new UnsupportedOperationException("Shouldn't be calling the ID getter");
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getTestProp() {
            throw new UnsupportedOperationException("Shouldn't be calling the getter");
        }

        public void setTestProp(String value) {
            throw new UnsupportedOperationException("Shouldn't be calling the setter with: " + value);
        }

        public Double getNonAnnotatedTestProperty() {
            this.nonAnnotatedTestPropertyAccessorWasCalled = true;
            return this.nonAnnotatedTestProperty;
        }

        public void setNonAnnotatedTestProperty(Double value) {
            this.nonAnnotatedTestPropertyAccessorWasCalled = true;
            this.nonAnnotatedTestProperty = value;
        }

        public String getFullyAnnotatedProperty() {
            this.fullyAnnotatedPropertyAccessorWasCalled = true;
            return this.fullyAnnotatedProperty;
        }

        public void setFullyAnnotatedProperty(String fullyAnnotatedProperty) {
            this.fullyAnnotatedPropertyAccessorWasCalled = true;
            this.fullyAnnotatedProperty = fullyAnnotatedProperty;
        }

        public Member getContains() {
            throw new UnsupportedOperationException("Shouldn't be calling the getter");
        }

        public void setContains(Member nestedObject) {
            throw new UnsupportedOperationException("Shouldn't be calling the setter with: " + nestedObject);
        }

        public Member getRegisteredMember() {
            throw new UnsupportedOperationException("Shouldn't be calling the getter");
        }

        public void setRegisteredMember(Member registeredMember) {
            throw new UnsupportedOperationException("Shouldn't be calling the setter with: " + registeredMember);
        }

        public Topic getTopic() {
            this.topicAccessorWasCalled = true;
            return this.favouriteTopic;
        }

        public void setTopic(Topic favouriteTopic) {
            this.topicAccessorWasCalled = true;
            this.favouriteTopic = favouriteTopic;
        }

        public Comment getReadOnlyComment() {
            return this.readOnlyComment;
        }

        public String getPropertyMethodsIgnored() {
            return this.propertyMethodsIgnored;
        }

        public void setPropertyMethodsIgnored(String propertyMethodsIgnored) {
            this.propertyMethodsIgnored = propertyMethodsIgnored;
        }

        @JsonIgnore
        public String getDifferentAnnotationOnGetter() {
            return this.propertyWithDifferentAnnotatedGetter;
        }

        @JsonIgnore
        public void setDifferentAnnotationOnGetter(String propertyWithDifferentAnnotatedGetter) {
            this.propertyWithDifferentAnnotatedGetter = propertyWithDifferentAnnotatedGetter;
        }
    }
}

