/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.reflect;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.social.Individual;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.neo4j.ogm.metadata.reflect.ReflectionEntityInstantiator;
import org.neo4j.ogm.model.Node;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.session.EntityInstantiator;

public class EntityFactoryTest {
    private EntityFactory entityFactory;

    @Before
    public void setUp() {
        MetaData metadata = new MetaData(new String[]{"org.neo4j.ogm.domain.social", "org.neo4j.ogm.domain.canonical"});
        this.entityFactory = new EntityFactory(metadata, (EntityInstantiator)new ReflectionEntityInstantiator(metadata));
    }

    @Test
    public void shouldConstructObjectOfParticularTypeUsingItsDefaultZeroArgConstructor() {
        NodeModel personNodeModel = new NodeModel(Long.valueOf(-1L));
        personNodeModel.setLabels(new String[]{"Individual"});
        Individual sheila = (Individual)this.entityFactory.newObject((Node)personNodeModel);
        Assertions.assertThat((Object)sheila).isNotNull();
    }

    @Test
    public void shouldHandleMultipleLabelsSafely() {
        NodeModel personNodeModel = new NodeModel(Long.valueOf(-1L));
        personNodeModel.setLabels(new String[]{"Female", "Individual", "Lass"});
        Individual ourLass = (Individual)this.entityFactory.newObject((Node)personNodeModel);
        Assertions.assertThat((Object)ourLass).isNotNull();
    }

    @Test
    public void shouldBeAbleToConstructObjectWithNonPublicZeroArgConstructor() {
        NodeModel node = new NodeModel(Long.valueOf(163L));
        node.setLabels(new String[]{"ClassWithPrivateConstructor"});
        this.entityFactory.newObject((Node)node);
    }

    @Test(expected=MappingException.class)
    public void shouldFailForGraphModelComponentWithNoTaxa() {
        NodeModel node = new NodeModel(Long.valueOf(302L));
        node.setLabels(new String[0]);
        this.entityFactory.newObject((Node)node);
    }

    @Test
    public void shouldConstructObjectIfExplicitlyGivenClassToInstantiate() {
        Individual instance = (Individual)this.entityFactory.newObject(Individual.class, new HashMap());
        Assertions.assertThat((Object)instance).as("The resultant instance shouldn't be null", new Object[0]).isNotNull();
    }
}

