/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.inheritance.Associated;
import org.neo4j.ogm.domain.inheritance.Person;
import org.neo4j.ogm.domain.simple.Mortal;
import org.neo4j.ogm.domain.simple.Vertex;
import org.neo4j.ogm.metadata.DomainInfo;
import org.neo4j.ogm.metadata.schema.DomainInfoSchemaBuilder;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.Relationship;
import org.neo4j.ogm.metadata.schema.Schema;

public class DomainInfoSchemaBuilderTest {
    public static final String SIMPLE_SCHEMA = "org.neo4j.ogm.domain.simple";
    private Schema schema;

    @Before
    public void setUp() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{SIMPLE_SCHEMA});
        this.schema = new DomainInfoSchemaBuilder(domainInfo).build();
    }

    @Test
    public void givenNodeEntity_thenNodeHasLabelFromEntity() {
        Node person = this.schema.findNode("Person");
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat((Iterable)person.labels()).containsOnly((Object[])new String[]{"Person"});
    }

    @Test
    public void whenBuildSchema_thenNodesHaveLabelsFromNodeEntityAnnotation() {
        Node company = this.schema.findNode("Happening");
        Assertions.assertThat((Object)company).isNotNull();
        Assertions.assertThat((Iterable)company.labels()).containsOnly((Object[])new String[]{"Happening"});
    }

    @Test
    public void givenNodeEntityWithoutRelationships_whenBuildSchema_thenNodeHasNoRelationships() {
        Node organisation = this.schema.findNode("Happening");
        Assertions.assertThat((Map)organisation.relationships()).isEmpty();
    }

    @Test
    public void givenSingleEndedRelationship_thenRelationshipExists() {
        Node person = this.schema.findNode("Person");
        Map relationships = person.relationships();
        Relationship employer = (Relationship)relationships.get("employer");
        Assertions.assertThat((Object)employer).isNotNull();
        Assertions.assertThat((String)employer.type()).isEqualTo((Object)"EMPLOYED_BY");
        Assertions.assertThat((String)employer.direction(person)).isEqualTo((Object)"OUTGOING");
        Assertions.assertThat((Object)employer.other(person)).isEqualTo((Object)this.schema.findNode("Organisation"));
    }

    @Test
    public void givenSingleEndedRelationshipEntity_thenRelationshipExists() {
        Node person = this.schema.findNode("Person");
        Map relationships = person.relationships();
        Relationship organisations = (Relationship)relationships.get("organisations");
        Assertions.assertThat((Object)organisations).isNotNull();
        Assertions.assertThat((String)organisations.type()).isEqualTo((Object)"FOUNDED");
        Assertions.assertThat((String)organisations.direction(person)).isEqualTo((Object)"OUTGOING");
        Assertions.assertThat((Object)organisations.other(person)).isEqualTo((Object)this.schema.findNode("Organisation"));
    }

    @Test
    public void givenDoubleEndedRelationship_thenRelationshipExistsInBoth() {
        Node person = this.schema.findNode("Person");
        Node location = this.schema.findNode("Location");
        Relationship locationRel = (Relationship)person.relationships().get("location");
        Assertions.assertThat((Object)locationRel).isNotNull();
        Assertions.assertThat((String)locationRel.type()).isEqualTo((Object)"LIVES_AT");
        Assertions.assertThat((String)locationRel.direction(person)).isEqualTo((Object)"OUTGOING");
        Assertions.assertThat((Object)locationRel.other(person)).isEqualTo((Object)location);
        Relationship residents = (Relationship)location.relationships().get("residents");
        Assertions.assertThat((Object)residents).isNotNull();
        Assertions.assertThat((String)residents.type()).isEqualTo((Object)"LIVES_AT");
        Assertions.assertThat((String)residents.direction(location)).isEqualTo((Object)"INCOMING");
        Assertions.assertThat((Object)residents.other(location)).isEqualTo((Object)person);
    }

    @Test
    public void givenStartNodeIsSupertype_thenMapCorrectly() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{Associated.class.getPackage().getName()});
        this.schema = new DomainInfoSchemaBuilder(domainInfo).build();
        Node entity = this.schema.findNode("Entity");
        Node organisation = this.schema.findNode("Organisation");
        Relationship associations = (Relationship)organisation.relationships().get("associations");
        Assertions.assertThat((String)associations.type()).isEqualTo((Object)"ASSOCIATED_WITH");
        Assertions.assertThat((Object)associations.other(organisation)).isEqualTo((Object)entity);
    }

    @Test
    public void givenSubtypeOfGenericType_thenPamCorrectly() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{org.neo4j.ogm.domain.generics.Person.class.getPackage().getName()});
        this.schema = new DomainInfoSchemaBuilder(domainInfo).build();
        Node person = this.schema.findNode("Person");
        Map relationships = person.relationships();
        Relationship organisations = (Relationship)relationships.get("organisations");
        Assertions.assertThat((Object)organisations).isNotNull();
        Assertions.assertThat((String)organisations.type()).isEqualTo((Object)"FOUNDED");
        Assertions.assertThat((String)organisations.direction(person)).isEqualTo((Object)"OUTGOING");
        Assertions.assertThat((Object)organisations.other(person)).isEqualTo((Object)this.schema.findNode("Organisation"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void givenNonAnnotatedAbstractClass_thenThrowException() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{Person.class.getPackage().getName()});
        this.schema = new DomainInfoSchemaBuilder(domainInfo).build();
        Node entity = this.schema.findNode("Entity");
        Assertions.assertThat((String)((String)entity.label().get())).isEqualTo((Object)"Entity");
        Assertions.assertThat((Iterable)entity.labels()).containsExactly((Object[])new String[]{"Entity"});
        this.schema.findNode("Company");
    }

    @Test
    public void givenIncomingRelationshipToSelf_thenMapDirectionCorrectly() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{Mortal.class.getPackage().getName()});
        this.schema = new DomainInfoSchemaBuilder(domainInfo).build();
        Node mortal = this.schema.findNode("Mortal");
        Relationship knownBy = (Relationship)mortal.relationships().get("knownBy");
        Assertions.assertThat((String)knownBy.direction(mortal)).isEqualTo((Object)"INCOMING");
    }

    @Test
    public void givenRelationshipIsArray_thenMapRelationshipType() {
        DomainInfo domainInfo = DomainInfo.create((String[])new String[]{Vertex.class.getName()});
        this.schema = new DomainInfoSchemaBuilder(domainInfo).build();
        Node node = this.schema.findNode("Vertex");
        Relationship nodes = (Relationship)node.relationships().get("vertices");
        Assertions.assertThat((String)nodes.type()).isEqualTo((Object)"EDGE");
        Assertions.assertThat((String)nodes.direction(node)).isEqualTo((Object)"OUTGOING");
        Assertions.assertThat((Object)nodes.other(node)).isEqualTo((Object)node);
    }

    @Test
    public void givenRelationshipEntity_whenFindRelationship_thenRelationshipIsFound() {
        Relationship relationship = this.schema.findRelationship("FOUNDED");
        Assertions.assertThat((String)relationship.type()).isEqualTo((Object)"FOUNDED");
    }

    @Test
    public void givenRelationshipEntityNotReferredFromNodeEntities_whenFindRelationship_thenRelationshipIsFound() {
        Relationship relationship = this.schema.findRelationship("VISITED");
        Assertions.assertThat((Object)relationship).isNotNull();
        Assertions.assertThat((Object)relationship.start()).isEqualTo((Object)this.schema.findNode("Person"));
        Assertions.assertThat((String)relationship.type()).isEqualTo((Object)"VISITED");
    }
}

