/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.schema;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.metadata.schema.Node;
import org.neo4j.ogm.metadata.schema.NodeImpl;
import org.neo4j.ogm.metadata.schema.Relationship;
import org.neo4j.ogm.metadata.schema.RelationshipImpl;

public class RelationshipImplTest {
    private NodeImpl start;
    private NodeImpl end;
    private Relationship outgoing;
    private Relationship incoming;
    private Relationship undirected;

    @Before
    public void setUp() {
        this.start = new NodeImpl("Person", Collections.singleton("Person"));
        this.end = new NodeImpl("Person", Collections.singleton("Person"));
        this.outgoing = new RelationshipImpl("FRIEND_OF", "OUTGOING", this.start, this.end);
        this.incoming = new RelationshipImpl("FRIEND_OF", "INCOMING", this.start, this.end);
        this.undirected = new RelationshipImpl("FRIEND_OF", "UNDIRECTED", this.start, this.end);
    }

    @Test
    public void givenUndirectedRelationship_whenDirection_thenReturnUndirected() {
        Assertions.assertThat((String)this.undirected.direction((Node)this.start)).isEqualTo((Object)"UNDIRECTED");
        Assertions.assertThat((String)this.undirected.direction((Node)this.end)).isEqualTo((Object)"UNDIRECTED");
    }

    @Test
    public void givenOutgoingRelationship_whenDirectionStart_thenReturnOutgoing() {
        Assertions.assertThat((String)this.outgoing.direction((Node)this.start)).isEqualTo((Object)"OUTGOING");
    }

    @Test
    public void givenOutgoingRelationship_whenDirectionEnd_thenReturnIncoming() {
        Assertions.assertThat((String)this.outgoing.direction((Node)this.end)).isEqualTo((Object)"INCOMING");
    }

    @Test
    public void givenIncomingRelationship_whenDirectionStart_thenReturnIncoming() {
        Assertions.assertThat((String)this.incoming.direction((Node)this.start)).isEqualTo((Object)"INCOMING");
    }

    @Test
    public void givenIncomingRelationship_whenDirectionEnd_thenReturnOutgoing() {
        Assertions.assertThat((String)this.incoming.direction((Node)this.end)).isEqualTo((Object)"OUTGOING");
    }
}

