/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence;

import java.util.Arrays;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.bike.Bike;
import org.neo4j.ogm.domain.bike.Frame;
import org.neo4j.ogm.domain.bike.Saddle;
import org.neo4j.ogm.domain.bike.Wheel;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class EndToEndTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.bike"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void canSimpleQueryDatabase() {
        Saddle expected = new Saddle();
        expected.setPrice(29.95);
        expected.setMaterial("Leather");
        Wheel frontWheel = new Wheel();
        Wheel backWheel = new Wheel();
        Bike bike = new Bike();
        bike.setBrand("Huffy");
        bike.setWheels(Arrays.asList(frontWheel, backWheel));
        bike.setSaddle(expected);
        this.session.save((Object)bike);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("material", "Leather");
        Saddle actual = (Saddle)this.session.queryForObject(Saddle.class, "MATCH (saddle:Saddle{material: {material}}) RETURN saddle", parameters);
        Assertions.assertThat((Long)actual.getId()).isEqualTo((Object)expected.getId());
        Assertions.assertThat((String)actual.getMaterial()).isEqualTo((Object)expected.getMaterial());
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        parameters2.put("brand", "Huffy");
        Bike actual2 = (Bike)this.session.queryForObject(Bike.class, "MATCH (bike:Bike{brand: {brand}}) RETURN bike", parameters2);
        Assertions.assertThat((Long)actual2.getId()).isEqualTo((Object)bike.getId());
        Assertions.assertThat((String)actual2.getBrand()).isEqualTo((Object)bike.getBrand());
    }

    @Test
    public void canSimpleScalarQueryDatabase() {
        Saddle expected = new Saddle();
        expected.setPrice(29.95);
        expected.setMaterial("Leather");
        this.session.save((Object)expected);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("material", "Leather");
        long actual = (Long)this.session.queryForObject(Long.class, "MATCH (saddle:Saddle{material: {material}}) RETURN COUNT(saddle)", parameters);
        Assertions.assertThat((long)actual).isEqualTo(1L);
    }

    @Test
    public void canComplexQueryDatabase() {
        Saddle saddle = new Saddle();
        saddle.setPrice(29.95);
        saddle.setMaterial("Leather");
        Wheel frontWheel = new Wheel();
        Wheel backWheel = new Wheel();
        Bike bike = new Bike();
        bike.setBrand("Huffy");
        bike.setWheels(Arrays.asList(frontWheel, backWheel));
        bike.setSaddle(saddle);
        this.session.save((Object)bike);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("brand", "Huffy");
        Bike actual = (Bike)this.session.queryForObject(Bike.class, "MATCH (bike:Bike{brand:{brand}})-[rels]-() RETURN bike, COLLECT(DISTINCT rels) as rels", parameters);
        Assertions.assertThat((Long)actual.getId()).isEqualTo((Object)bike.getId());
        Assertions.assertThat((String)actual.getBrand()).isEqualTo((Object)bike.getBrand());
        Assertions.assertThat((int)actual.getWheels().size()).isEqualTo(bike.getWheels().size());
        Assertions.assertThat((Object)actual.getSaddle()).isNotNull();
    }

    @Test
    public void canComplexExecute() {
        Saddle saddle = new Saddle();
        saddle.setPrice(29.95);
        saddle.setMaterial("Leather");
        Wheel frontWheel = new Wheel();
        Wheel backWheel = new Wheel();
        Bike bike = new Bike();
        bike.setBrand("Huffy");
        bike.setWheels(Arrays.asList(frontWheel, backWheel));
        bike.setSaddle(saddle);
        this.session.save((Object)bike);
        Saddle newSaddle = new Saddle();
        newSaddle.setPrice(19.95);
        newSaddle.setMaterial("Vinyl");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("brand", "Huffy");
        parameters.put("saddle", newSaddle);
        this.session.query("MATCH (bike:Bike{brand:{brand}})-[r]-(s:Saddle) SET s = {saddle}", parameters);
        HashMap<String, String> parameters2 = new HashMap<String, String>();
        parameters2.put("brand", "Huffy");
        Bike actual = (Bike)this.session.queryForObject(Bike.class, "MATCH (bike:Bike{brand: $brand})-[rels]-(o) RETURN *", parameters2);
        Assertions.assertThat((Long)actual.getId()).isEqualTo((Object)bike.getId());
        Assertions.assertThat((String)actual.getBrand()).isEqualTo((Object)bike.getBrand());
        Assertions.assertThat((int)actual.getWheels().size()).isEqualTo(bike.getWheels().size());
    }

    @Test
    public void canSaveNewObjectTreeToDatabase() {
        Wheel frontWheel = new Wheel();
        Wheel backWheel = new Wheel();
        Bike bike = new Bike();
        bike.setFrame(new Frame());
        bike.setSaddle(new Saddle());
        bike.setWheels(Arrays.asList(frontWheel, backWheel));
        Assertions.assertThat((Long)frontWheel.getId()).isNull();
        Assertions.assertThat((Long)backWheel.getId()).isNull();
        Assertions.assertThat((Long)bike.getId()).isNull();
        Assertions.assertThat((Long)bike.getFrame().getId()).isNull();
        Assertions.assertThat((Long)bike.getSaddle().getId()).isNull();
        this.session.save((Object)bike);
        Assertions.assertThat((Long)frontWheel.getId()).isNotNull();
        Assertions.assertThat((Long)backWheel.getId()).isNotNull();
        Assertions.assertThat((Long)bike.getId()).isNotNull();
        Assertions.assertThat((Long)bike.getFrame().getId()).isNotNull();
        Assertions.assertThat((Long)bike.getSaddle().getId()).isNotNull();
    }
}

