/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.authentication;

import org.apache.http.client.HttpResponseException;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.drivers.http.driver.HttpDriver;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class AuthenticatingDriverTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void beforeMethod() {
        Assume.assumeTrue((boolean)AuthenticatingDriverTest.getBaseConfiguration().build().getDriverClassName().equals(HttpDriver.class.getName()));
    }

    @Test
    public void testUnauthorizedDriver() {
        this.session = new SessionFactory(AuthenticatingDriverTest.getBaseConfiguration().credentials("", "").build(), new String[]{"dummy"}).openSession();
        try (Transaction tx = this.session.beginTransaction();){
            tx.commit();
            Assertions.fail((String)"Driver should not have authenticated");
        }
        catch (Exception rpe) {
            Throwable cause = rpe.getCause();
            while (!(cause instanceof HttpResponseException)) {
                cause = cause.getCause();
            }
            Assertions.assertThat((boolean)cause.getMessage().startsWith("Invalid username or password")).isTrue();
        }
    }

    @Test
    public void testAuthorizedDriver() {
        this.session = new SessionFactory(driver, new String[]{"dummy"}).openSession();
        try (Transaction ignored = this.session.beginTransaction();){
            Assertions.assertThat((Object)ignored).isNotNull();
        }
        catch (Exception rpe) {
            Assertions.fail((String)("'" + rpe.getLocalizedMessage() + "' was not expected here"));
        }
    }

    @Test
    public void testInvalidCredentials() {
        this.session = new SessionFactory(AuthenticatingDriverTest.getBaseConfiguration().credentials("neo4j", "invalid_password").build(), new String[]{"dummy"}).openSession();
        try (Transaction tx = this.session.beginTransaction();){
            Assertions.fail((String)"Driver should not have authenticated");
        }
        catch (Exception rpe) {
            Throwable cause = rpe.getCause();
            while (!(cause instanceof HttpResponseException)) {
                cause = cause.getCause();
            }
            Assertions.assertThat((String)cause.getMessage()).isEqualTo((Object)"Invalid username or password.");
        }
    }
}

