/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.canonical;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.canonical.Mappable;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class CanonicalTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.canonical"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldMapArraysWhenUsingCustomQueries() {
        Mappable mappable = new Mappable();
        mappable.setPrimitiveBoolean(false);
        mappable.setPrimitiveByte((byte)100);
        mappable.setPrimitiveChar('c');
        mappable.setPrimitiveDouble(123.4);
        mappable.setPrimitiveFloat(567.8f);
        mappable.setPrimitiveInt(5);
        mappable.setPrimitiveLong(8L);
        mappable.setPrimitiveShort((short)200);
        mappable.setPrimitiveBooleanArray(new boolean[]{true, false});
        mappable.setPrimitiveByteArray(new byte[]{10, 100});
        mappable.setPrimitiveCharArray(new char[]{'d', '\u0001'});
        mappable.setPrimitiveDoubleArray(new double[]{34.5, 67.8});
        mappable.setPrimitiveFloatArray(new float[]{1.2f, 3.4f});
        mappable.setPrimitiveIntArray(new int[]{6, 7});
        mappable.setPrimitiveLongArray(new long[]{9L, 10L});
        mappable.setPrimitiveShortArray(new short[]{30, 300});
        mappable.setObjectBoolean(Boolean.FALSE);
        mappable.setObjectByte(Byte.valueOf("100"));
        mappable.setObjectDouble(567.8);
        mappable.setObjectFloat(Float.valueOf(123.4f));
        mappable.setObjectInteger(99);
        mappable.setObjectLong(1000L);
        mappable.setObjectShort(Short.valueOf("100"));
        mappable.setObjectString("abc");
        mappable.setObjectCharacter(Character.valueOf('d'));
        mappable.setObjectBooleanArray(new Boolean[]{Boolean.TRUE, Boolean.FALSE});
        mappable.setObjectByteArray(new Byte[]{(byte)10, (byte)100});
        mappable.setObjectCharArray(new Character[]{Character.valueOf('d'), Character.valueOf('(')});
        mappable.setObjectDoubleArray(new Double[]{34.5, 67.8});
        mappable.setObjectFloatArray(new Float[]{Float.valueOf(1.2f), Float.valueOf(3.4f)});
        mappable.setObjectIntegerArray(new Integer[]{6, 7});
        mappable.setObjectLongArray(new Long[]{9L, 10L});
        mappable.setObjectShortArray(new Short[]{(short)30, (short)300});
        mappable.setObjectStringArray(new String[]{"abc", "xyz"});
        mappable.setListOfString(Arrays.asList("a", "bb", "cc"));
        mappable.setListOfCharacter(Arrays.asList(Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')));
        this.session.save((Object)mappable);
        this.session.clear();
        Result result = this.session.query("match (n) return n", Collections.EMPTY_MAP);
        Assertions.assertThat((Iterable)result).isNotNull();
        Mappable loaded = (Mappable)((Map)result.iterator().next()).get("n");
        Assertions.assertThat((Object)loaded).isNotNull();
        Assertions.assertThat((boolean)loaded.isPrimitiveBoolean()).isFalse();
        Assertions.assertThat((byte)loaded.getPrimitiveByte()).isEqualTo(mappable.getPrimitiveByte());
        Assertions.assertThat((char)loaded.getPrimitiveChar()).isEqualTo(mappable.getPrimitiveChar());
        Assertions.assertThat((double)loaded.getPrimitiveDouble()).isEqualTo(mappable.getPrimitiveDouble(), Assertions.within((Double)0.0));
        Assertions.assertThat((float)loaded.getPrimitiveFloat()).isEqualTo(mappable.getPrimitiveFloat(), Assertions.within((Float)Float.valueOf(0.0f)));
        Assertions.assertThat((int)loaded.getPrimitiveInt()).isEqualTo(mappable.getPrimitiveInt());
        Assertions.assertThat((long)loaded.getPrimitiveLong()).isEqualTo(mappable.getPrimitiveLong());
        Assertions.assertThat((short)loaded.getPrimitiveShort()).isEqualTo(mappable.getPrimitiveShort());
        Assertions.assertThat((boolean[])loaded.getPrimitiveBooleanArray()).isEqualTo((Object)mappable.getPrimitiveBooleanArray());
        Assertions.assertThat((byte[])loaded.getPrimitiveByteArray()).isEqualTo((Object)mappable.getPrimitiveByteArray());
        Assertions.assertThat((char[])loaded.getPrimitiveCharArray()).isEqualTo((Object)mappable.getPrimitiveCharArray());
        Assertions.assertThat((double[])loaded.getPrimitiveDoubleArray()).isEqualTo((Object)mappable.getPrimitiveDoubleArray());
        Assertions.assertThat((float[])loaded.getPrimitiveFloatArray()).isEqualTo((Object)mappable.getPrimitiveFloatArray());
        Assertions.assertThat((int[])loaded.getPrimitiveIntArray()).isEqualTo((Object)mappable.getPrimitiveIntArray());
        Assertions.assertThat((long[])loaded.getPrimitiveLongArray()).isEqualTo((Object)mappable.getPrimitiveLongArray());
        Assertions.assertThat((short[])loaded.getPrimitiveShortArray()).isEqualTo((Object)mappable.getPrimitiveShortArray());
        Assertions.assertThat((Boolean)loaded.getObjectBoolean()).isEqualTo((Object)mappable.getObjectBoolean());
        Assertions.assertThat((Byte)loaded.getObjectByte()).isEqualTo((Object)mappable.getObjectByte());
        Assertions.assertThat((Double)loaded.getObjectDouble()).isEqualTo((Object)mappable.getObjectDouble());
        Assertions.assertThat((Float)loaded.getObjectFloat()).isEqualTo((Object)mappable.getObjectFloat());
        Assertions.assertThat((Integer)loaded.getObjectInteger()).isEqualTo((Object)mappable.getObjectInteger());
        Assertions.assertThat((Long)loaded.getObjectLong()).isEqualTo((Object)mappable.getObjectLong());
        Assertions.assertThat((Short)loaded.getObjectShort()).isEqualTo((Object)mappable.getObjectShort());
        Assertions.assertThat((String)loaded.getObjectString()).isEqualTo((Object)mappable.getObjectString());
        Assertions.assertThat((Character)loaded.getObjectCharacter()).isEqualTo((Object)mappable.getObjectCharacter());
        Assertions.assertThat((Object[])loaded.getObjectBooleanArray()).isEqualTo((Object)mappable.getObjectBooleanArray());
        Assertions.assertThat((Object[])loaded.getObjectByteArray()).isEqualTo((Object)mappable.getObjectByteArray());
        Assertions.assertThat((Object[])loaded.getObjectCharArray()).isEqualTo((Object)mappable.getObjectCharArray());
        Assertions.assertThat((Object[])loaded.getObjectDoubleArray()).isEqualTo((Object)mappable.getObjectDoubleArray());
        Assertions.assertThat((Object[])loaded.getObjectFloatArray()).isEqualTo((Object)mappable.getObjectFloatArray());
        Assertions.assertThat((Object[])loaded.getObjectIntegerArray()).isEqualTo((Object)mappable.getObjectIntegerArray());
        Assertions.assertThat((Object[])loaded.getObjectLongArray()).isEqualTo((Object)mappable.getObjectLongArray());
        Assertions.assertThat((Object[])loaded.getObjectShortArray()).isEqualTo((Object)mappable.getObjectShortArray());
        Assertions.assertThat((Object[])loaded.getObjectStringArray()).isEqualTo((Object)mappable.getObjectStringArray());
        Assertions.assertThat(loaded.getListOfString()).isEqualTo(mappable.getListOfString());
        Assertions.assertThat(loaded.getListOfCharacter()).isEqualTo(mappable.getListOfCharacter());
    }
}

