/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.cineasts.annotated;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.domain.cineasts.annotated.Actor;
import org.neo4j.ogm.domain.cineasts.annotated.Movie;
import org.neo4j.ogm.domain.cineasts.annotated.Pet;
import org.neo4j.ogm.domain.cineasts.annotated.Plays;
import org.neo4j.ogm.domain.cineasts.annotated.Rating;
import org.neo4j.ogm.domain.cineasts.annotated.SecurityRole;
import org.neo4j.ogm.domain.cineasts.annotated.Title;
import org.neo4j.ogm.domain.cineasts.annotated.User;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.testutil.TestUtils;

public class CineastsIntegrationTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.annotated"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.importCineasts();
    }

    private void importCineasts() {
        this.session.query(TestUtils.readCQLFile((String)"org/neo4j/ogm/cql/cineasts.cql").toString(), Utils.map((Object[])new Object[0]));
    }

    @After
    public void teardown() {
        this.session.purgeDatabase();
    }

    @Test
    public void loadRatingsAndCommentsAboutMovies() {
        Collection movies = this.session.loadAll(Movie.class);
        Assertions.assertThat((Iterable)movies).hasSize(3);
        for (Movie movie : movies) {
            if (movie.getRatings() == null) continue;
            for (Rating rating : movie.getRatings()) {
                Assertions.assertThat((Object)rating.getMovie()).as("The film on the rating shouldn't be null", new Object[0]).isNotNull();
                Assertions.assertThat((Object)rating.getMovie()).as("The film on the rating was not mapped correctly", new Object[0]).isSameAs((Object)movie);
                Assertions.assertThat((Object)rating.getUser()).as("The film critic wasn't set", new Object[0]).isNotNull();
            }
        }
    }

    @Test
    public void loadParticularUserRatingsAndComments() {
        Collection filmCritics = this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Michal"));
        Assertions.assertThat((Iterable)filmCritics).hasSize(1);
        User critic = (User)filmCritics.iterator().next();
        Assertions.assertThat(critic.getRatings()).hasSize(2);
        for (Rating rating : critic.getRatings()) {
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)rating.getComment()).as("The comment should've been mapped", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((rating.getStars() > 0 ? 1 : 0) != 0).as("The star rating should've been mapped", new Object[0])).isTrue();
            Assertions.assertThat((Object)rating.getUser()).as("The user start node should've been mapped", new Object[0]).isNotNull();
            Assertions.assertThat((Object)rating.getMovie()).as("The movie end node should've been mapped", new Object[0]).isNotNull();
        }
    }

    @Test
    public void loadRatingsForSpecificFilm() {
        Collection films = this.session.loadAll(Movie.class, new Filter("title", ComparisonOperator.EQUALS, (Object)"Top Gear"));
        Assertions.assertThat((Iterable)films).hasSize(1);
        Movie film = (Movie)films.iterator().next();
        Assertions.assertThat(film.getRatings()).hasSize(2);
        for (Rating rating : film.getRatings()) {
            ((AbstractBooleanAssert)Assertions.assertThat((rating.getStars() > 0 ? 1 : 0) != 0).as("The star rating should've been mapped", new Object[0])).isTrue();
            Assertions.assertThat((Object)rating.getUser()).as("The user start node should've been mapped", new Object[0]).isNotNull();
            Assertions.assertThat((Object)rating.getMovie()).as("The wrong film was mapped to the rating", new Object[0]).isSameAs((Object)film);
        }
    }

    @Test
    public void loadFilmByRatingUsersPet() {
        Filter filter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Catty");
        filter.setOwnerEntityType(Movie.class);
        filter.setNestedPath(new Filter.NestedPathSegment[]{new Filter.NestedPathSegment("ratings", Rating.class), new Filter.NestedPathSegment("user", User.class), new Filter.NestedPathSegment("pets", Pet.class)});
        Collection films = this.session.loadAll(Movie.class, filter);
        Assertions.assertThat((Iterable)films).hasSize(2);
    }

    @Test
    public void loadFilmByRating() {
        Filter filter = new Filter("stars", ComparisonOperator.EQUALS, (Object)5);
        filter.setOwnerEntityType(Movie.class);
        filter.setNestedPath(new Filter.NestedPathSegment[]{new Filter.NestedPathSegment("ratings", Rating.class)});
        Collection films = this.session.loadAll(Movie.class, filter);
        Assertions.assertThat((Iterable)films).hasSize(1);
    }

    @Test
    public void loadFilmByRatingUserPlays() {
        Filter filter = new Filter("level", ComparisonOperator.EQUALS, (Object)"ok");
        filter.setOwnerEntityType(Movie.class);
        filter.setNestedPath(new Filter.NestedPathSegment[]{new Filter.NestedPathSegment("ratings", Rating.class), new Filter.NestedPathSegment("user", User.class), new Filter.NestedPathSegment("plays", Plays.class)});
        Collection films = this.session.loadAll(Movie.class, filter);
        Assertions.assertThat((Iterable)films).hasSize(2);
    }

    @Test
    public void loadFilmByUserAndRatingUserPlays() {
        Filter userFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Michal");
        userFilter.setNestedPath(new Filter.NestedPathSegment[]{new Filter.NestedPathSegment("ratings", Rating.class), new Filter.NestedPathSegment("user", User.class)});
        Filter playsFilter = new Filter("level", ComparisonOperator.EQUALS, (Object)"ok");
        playsFilter.setOwnerEntityType(Movie.class);
        playsFilter.setNestedPath(new Filter.NestedPathSegment[]{new Filter.NestedPathSegment("ratings", Rating.class), new Filter.NestedPathSegment("user", User.class), new Filter.NestedPathSegment("plays", Plays.class)});
        Filters filters = userFilter.and(playsFilter);
        Collection films = this.session.loadAll(Movie.class, filters);
        Assertions.assertThat((Iterable)films).hasSize(2);
    }

    @Test
    public void loadRatingByUserName() {
        Filter userNameFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Michal");
        Filter ratingFilter = new Filter("stars", ComparisonOperator.EQUALS, (Object)5);
        userNameFilter.setNestedPath(new Filter.NestedPathSegment[]{new Filter.NestedPathSegment("user", User.class)});
        Collection ratings = this.session.loadAll(Rating.class, userNameFilter.and(ratingFilter));
        Assertions.assertThat((Iterable)ratings).hasSize(1);
    }

    @Test
    public void loadRatingByUserNameAndStars() {
        Filter userNameFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Michal");
        userNameFilter.setNestedPath(new Filter.NestedPathSegment[]{new Filter.NestedPathSegment("user", User.class)});
        Collection ratings = this.session.loadAll(Rating.class, userNameFilter);
        Assertions.assertThat((Iterable)ratings).hasSize(2);
    }

    @Test
    public void saveAndRetrieveUserWithSecurityRoles() {
        User user = new User();
        user.setLogin("daniela");
        user.setName("Daniela");
        user.setPassword("daniela");
        user.setSecurityRoles(new SecurityRole[]{SecurityRole.USER});
        this.session.save((Object)user);
        User daniela = (User)this.session.load(User.class, (Serializable)((Object)"daniela"));
        Assertions.assertThat((Object)daniela).isNotNull();
        Assertions.assertThat((String)daniela.getName()).isEqualTo((Object)"Daniela");
        Assertions.assertThat((int)daniela.getSecurityRoles().length).isEqualTo(1);
        Assertions.assertThat((Comparable)((Object)daniela.getSecurityRoles()[0])).isEqualTo((Object)SecurityRole.USER);
    }

    @Test
    public void saveAndRetrieveUserWithTitles() {
        User user = new User();
        user.setLogin("vince");
        user.setName("Vince");
        user.setPassword("vince");
        user.setTitles(Arrays.asList(Title.MR));
        this.session.save((Object)user);
        User vince = (User)this.session.load(User.class, (Serializable)((Object)"vince"));
        Assertions.assertThat((Object)vince).isNotNull();
        Assertions.assertThat((String)vince.getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat(vince.getTitles()).hasSize(1);
        Assertions.assertThat((Comparable)((Comparable)((Object)vince.getTitles().get(0)))).isEqualTo((Object)Title.MR);
    }

    @Test
    public void saveAndRetrieveUserWithDifferentCharset() {
        User user = new User();
        user.setLogin("aki");
        user.setName("Aki Kaurism\u00e4ki");
        user.setPassword("aki");
        this.session.save((Object)user);
        User aki = (User)this.session.load(User.class, (Serializable)((Object)"aki"));
        Assertions.assertThat((Object)aki).isNotNull();
        try {
            Assertions.assertThat((byte[])aki.getName().getBytes("UTF-8")).isEqualTo((Object)"Aki Kaurism\u00e4ki".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            Assertions.fail((String)"UTF-8 encoding not supported on this platform");
        }
    }

    @Test
    public void shouldQueryForSpecificActorUsingBespokeParameterisedCypherQuery() {
        this.session.save((Object)new Actor("Alec Baldwin"));
        this.session.save((Object)new Actor("Helen Mirren"));
        this.session.save((Object)new Actor("Matt Damon"));
        Actor loadedActor = (Actor)this.session.queryForObject(Actor.class, "MATCH (a:Actor) WHERE a.name={param} RETURN a", Collections.singletonMap("param", "Alec Baldwin"));
        Assertions.assertThat((Object)loadedActor).as("The entity wasn't loaded", new Object[0]).isNotNull();
        Assertions.assertThat((String)loadedActor.getName()).isEqualTo((Object)"Alec Baldwin");
    }

    @Test
    public void shouldQueryForCollectionOfActorsUsingBespokeCypherQuery() {
        this.session.save((Object)new Actor("Jeff"));
        this.session.save((Object)new Actor("John"));
        this.session.save((Object)new Actor("Colin"));
        Iterable actors = this.session.query(Actor.class, "MATCH (a:Actor) WHERE a.name=~'J.*' RETURN a", Collections.emptyMap());
        ((IterableAssert)Assertions.assertThat((Iterable)actors).as("The entities weren't loaded", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)actors.iterator().hasNext()).as("The entity wasn't loaded", new Object[0])).isTrue();
        Assertions.assertThat((Iterable)actors).extracting(Actor::getName).containsOnly((Object[])new String[]{"John", "Jeff"});
    }

    @Test
    public void shouldQueryForActorByIdUsingBespokeParameterisedCypherQuery() {
        this.session.save((Object)new Actor("Keanu Reeves"));
        Actor carrie = new Actor("Carrie-Ann Moss");
        this.session.save((Object)carrie);
        this.session.save((Object)new Actor("Laurence Fishbourne"));
        Actor loadedActor = (Actor)this.session.queryForObject(Actor.class, "MATCH (a:Actor) WHERE a.uuid={param} RETURN a", Collections.singletonMap("param", carrie.getUuid()));
        Assertions.assertThat((Object)loadedActor).as("The entity wasn't loaded", new Object[0]).isNotNull();
        Assertions.assertThat((String)loadedActor.getName()).isEqualTo((Object)"Carrie-Ann Moss");
    }

    @Test
    public void shouldModifyStringArraysCorrectly() throws MalformedURLException {
        User user = new User("joker", "Joker", "password");
        URL[] urls = new URL[]{new URL("http://www.apple.com"), new URL("http://www.google.com"), new URL("http://www.neo4j.com")};
        user.setUrls(urls);
        String[] nicknames = new String[]{"batman", "robin"};
        user.setNicknames(nicknames);
        this.session.save((Object)user);
        user.getUrls()[0] = new URL("http://www.graphaware.com");
        user.getNicknames()[0] = "batgirl";
        this.session.save((Object)user);
        user = (User)this.session.load(User.class, (Serializable)((Object)user.getLogin()));
        Assertions.assertThat((int)user.getUrls().length).isEqualTo(3);
        Assertions.assertThat((String)user.getUrls()[0].toString()).isEqualTo((Object)"http://www.graphaware.com");
        Assertions.assertThat((String)user.getUrls()[1].toString()).isEqualTo((Object)"http://www.google.com");
        Assertions.assertThat((String)user.getUrls()[2].toString()).isEqualTo((Object)"http://www.neo4j.com");
        Assertions.assertThat((int)user.getNicknames().length).isEqualTo(2);
        Assertions.assertThat((String)user.getNicknames()[0]).isEqualTo((Object)"batgirl");
        Assertions.assertThat((String)user.getNicknames()[1]).isEqualTo((Object)"robin");
    }

    @Test
    public void shouldBeAbleToSetNodePropertiesToNull() throws MalformedURLException {
        Movie movie = new Movie("Zootopia", 2016);
        movie.setImdbUrl(new URL("http://www.imdb.com/title/tt2948356/"));
        this.session.save((Object)movie);
        movie.setTitle(null);
        movie.setImdbUrl(null);
        this.session.save((Object)movie);
        movie = (Movie)this.session.load(Movie.class, (Serializable)movie.getUuid());
        Assertions.assertThat((String)movie.getTitle()).isNull();
        Assertions.assertThat((URL)movie.getImdbUrl()).isNull();
        this.session.clear();
        movie = (Movie)this.session.load(Movie.class, (Serializable)movie.getUuid());
        Assertions.assertThat((String)movie.getTitle()).isNull();
        Assertions.assertThat((URL)movie.getImdbUrl()).isNull();
    }
}

