/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.cineasts.annotated;

import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.cineasts.annotated.Movie;
import org.neo4j.ogm.domain.cineasts.annotated.Rating;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.persistence.examples.cineasts.annotated.MoviesRequest;
import org.neo4j.ogm.session.Neo4jSession;

public class MovieTest {
    @Test
    public void testDeserialiseMovie() {
        MetaData metadata = new MetaData(new String[]{"org.neo4j.ogm.domain.cineasts.annotated"});
        Neo4jSession session = new Neo4jSession(metadata, true, (Driver)new MoviesRequest());
        Movie movie = (Movie)session.load(Movie.class, (Serializable)UUID.fromString("38ebe777-bc85-4810-8217-096f29a361f1"), 1);
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Pulp Fiction");
        Assertions.assertThat(movie.getRatings()).isNotNull();
        Assertions.assertThat(movie.getRatings()).hasSize(1);
        Rating rating = movie.getRatings().iterator().next();
        Assertions.assertThat((String)rating.getUser().getName()).isEqualTo((Object)"Michal");
        Assertions.assertThat((String)rating.getMovie().getTitle()).isEqualTo((Object)"Pulp Fiction");
    }
}

