/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.companies;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.companies.annotated.Company;
import org.neo4j.ogm.domain.companies.annotated.Device;
import org.neo4j.ogm.domain.companies.annotated.Person;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class CompaniesIntegrationTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void init() throws IOException {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.companies.annotated"});
    }

    @Before
    public void setUp() {
        this.session = sessionFactory.openSession();
    }

    @After
    public void teardown() {
        this.session.purgeDatabase();
    }

    @Test
    public void employeesShouldNotBeSetAsOwnersWhenLoadingCompanies() {
        Company company = new Company("GraphAware");
        Person michal = new Person("Michal");
        Person daniela = new Person("Daniela");
        HashSet<Person> employees = new HashSet<Person>();
        employees.add(michal);
        employees.add(daniela);
        company.setEmployees(employees);
        this.session.save((Object)company);
        this.session.clear();
        company = (Company)this.session.load(Company.class, (Serializable)company.getId());
        Assertions.assertThat((Object)company).isNotNull();
        Assertions.assertThat(company.getEmployees()).hasSize(2);
        Assertions.assertThat(company.getOwners()).isNull();
        for (Person employee : company.getEmployees()) {
            Assertions.assertThat((Object)employee.getEmployer()).isNotNull();
            Assertions.assertThat(employee.getOwns()).isNull();
        }
    }

    @Test
    public void employeesAndOwnersShouldBeLoaded() {
        Company company = new Company("GraphAware");
        Person michal = new Person("Michal");
        Person daniela = new Person("Daniela");
        michal.setOwns(Collections.singleton(company));
        daniela.setOwns(Collections.singleton(company));
        HashSet<Person> employees = new HashSet<Person>();
        employees.add(michal);
        employees.add(daniela);
        company.setEmployees(employees);
        company.setOwners(employees);
        this.session.save((Object)company);
        this.session.clear();
        company = (Company)this.session.load(Company.class, (Serializable)company.getId());
        Assertions.assertThat((Object)company).isNotNull();
        Assertions.assertThat(company.getEmployees()).hasSize(2);
        Assertions.assertThat(company.getOwners()).hasSize(2);
        for (Person employee : company.getEmployees()) {
            Assertions.assertThat((Long)employee.getEmployer().getId()).isEqualTo((Object)company.getId());
            Assertions.assertThat(employee.getOwns()).hasSize(1);
            Assertions.assertThat((Long)employee.getOwns().iterator().next().getId()).isEqualTo((Object)company.getId());
        }
    }

    @Test
    public void shouldDeleteUndirectedRelationship() {
        Person person = new Person();
        Device device = new Device();
        person.addDevice(device);
        this.session.save((Object)person);
        person.removeDevice(device);
        Assertions.assertThat(person.getDevices()).isEmpty();
        this.session.save((Object)person);
        this.session.clear();
        person = (Person)this.session.load(Person.class, (Serializable)person.getId());
        Assertions.assertThat((Object)person).isNotNull();
        Assertions.assertThat(person.getDevices()).isNull();
    }
}

