/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.companies;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.companies.partial.Company;
import org.neo4j.ogm.domain.companies.partial.Person;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class PartialCompaniesIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void init() throws IOException {
        sessionFactory = new SessionFactory(new String[]{"org.neo4j.ogm.domain.companies.partial"});
    }

    @Before
    public void setUp() throws Exception {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void whenSaveAndLoadCompany_thenShouldCorrectlySetPersonFields() throws Exception {
        Person alice = new Person("Alice the Founder");
        Person bob = new Person("Bob the employee");
        Company company = new Company("The Unicorn");
        company.setFounder(alice);
        company.setEmployees(Collections.singleton(bob));
        this.session.save((Object)company);
        this.session.clear();
        Company loaded = (Company)this.session.load(Company.class, (Serializable)company.getId());
        Assertions.assertThat((String)loaded.getFounder().getName()).isEqualTo((Object)"Alice the Founder");
        Assertions.assertThat(loaded.getEmployees()).hasSize(1);
        Person employee = loaded.getEmployees().iterator().next();
        Assertions.assertThat((String)employee.getName()).isEqualTo((Object)"Bob the employee");
    }
}

