/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.education;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.education.Course;
import org.neo4j.ogm.domain.education.Student;
import org.neo4j.ogm.domain.education.Teacher;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.persistence.examples.education.CoursesRequest;
import org.neo4j.ogm.persistence.examples.education.TeacherRequest;
import org.neo4j.ogm.session.Neo4jSession;

public class EducationTest {
    private static MetaData metadata = new MetaData(new String[]{"org.neo4j.ogm.domain.education"});
    private static Neo4jSession session = new Neo4jSession(metadata, true, (Driver)new TeacherRequest());

    @Test
    public void testTeachers() throws Exception {
        Map<String, Teacher> teachers = this.loadTeachers();
        Teacher mrThomas = teachers.get("Mr Thomas");
        Teacher mrsRoberts = teachers.get("Mrs Roberts");
        Teacher missYoung = teachers.get("Miss Young");
        this.checkCourseNames(mrThomas, "Maths", "English", "Physics");
        this.checkCourseNames(mrsRoberts, "English", "History", "PE");
        this.checkCourseNames(missYoung, "History", "Geography", "Philosophy and Ethics");
    }

    @Test
    public void testFetchCoursesTaughtByAllTeachers() throws Exception {
        Map<String, Teacher> teachers = this.loadTeachers();
        this.hydrateCourses(teachers.values());
        HashSet<Course> courses = new HashSet<Course>();
        for (Teacher teacher : teachers.values()) {
            for (Course course : teacher.getCourses()) {
                if (courses.contains(course)) continue;
                List<Student> students = course.getStudents();
                switch (course.getName()) {
                    case "Maths": {
                        this.checkMaths(students);
                        break;
                    }
                    case "Physics": {
                        this.checkPhysics(students);
                        break;
                    }
                    case "Philosophy and Ethics": {
                        this.checkPhilosophyAndEthics(students);
                        break;
                    }
                    case "PE": {
                        this.checkPE(students);
                        break;
                    }
                    case "History": {
                        this.checkHistory(students);
                        break;
                    }
                    case "Geography": {
                        this.checkGeography(students);
                        break;
                    }
                    default: {
                        this.checkEnglish(students);
                    }
                }
                courses.add(course);
            }
        }
        Assertions.assertThat(courses).hasSize(7);
    }

    private void test(long hash, List<Student> students) {
        for (Student student : students) {
            hash -= student.getId().longValue();
        }
        Assertions.assertThat((long)hash).isEqualTo(0L);
    }

    private void checkEnglish(List<Student> students) {
        long hash = 0L;
        for (int i = 101; i < 127; ++i) {
            hash += (long)i;
        }
        this.test(hash, students);
    }

    private void checkGeography(List<Student> students) {
        long hash = 1000L;
        this.test(hash, students);
    }

    private void checkHistory(List<Student> students) {
        long hash = 0L;
        for (int i = 102; i < 127; i += 2) {
            hash += (long)i;
        }
        this.test(hash, students);
    }

    private void checkPE(List<Student> students) {
        long hash = 0L;
        for (int i = 103; i < 127; i += 3) {
            hash += (long)i;
        }
        this.test(hash, students);
    }

    private void checkPhilosophyAndEthics(List<Student> students) {
        long hash = 0L;
        for (int i = 101; i < 127; ++i) {
            hash += (long)i;
        }
        this.test(hash, students);
    }

    private void checkPhysics(List<Student> students) {
        long hash = 0L;
        for (int i = 101; i < 127; i += 2) {
            hash += (long)i;
        }
        this.test(hash, students);
    }

    private void checkMaths(List<Student> students) {
        long hash = 0L;
        for (int i = 101; i < 127; ++i) {
            hash += (long)i;
        }
        this.test(hash, students);
    }

    private Map<String, Teacher> loadTeachers() {
        HashMap<String, Teacher> teachers = new HashMap<String, Teacher>();
        session.setDriver((Driver)new TeacherRequest());
        Collection teacherList = session.loadAll(Teacher.class);
        for (Teacher teacher : teacherList) {
            teachers.put(teacher.getName(), teacher);
        }
        return teachers;
    }

    private void hydrateCourses(Collection<Teacher> teachers) {
        session.setDriver((Driver)new TeacherRequest());
        session.setDriver((Driver)new CoursesRequest());
        session.loadAll(Course.class);
    }

    private void checkCourseNames(Teacher teacher, String ... courseNames) {
        int n = courseNames.length;
        List<String> test = Arrays.asList(courseNames);
        for (Course course : teacher.getCourses()) {
            if (!test.contains(course.getName())) continue;
            --n;
        }
        Assertions.assertThat((int)n).isEqualTo(0);
    }
}

