/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.friendships;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.friendships.Person;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class FriendsInLongTransactionTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.friendships"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
    }

    @Test
    public void createPersonAndFriendsInLongTransaction() {
        try (Transaction tx = this.session.beginTransaction();){
            Assertions.assertThat((Comparable)tx.status()).isEqualTo((Object)Transaction.Status.OPEN);
            Person john = new Person("John");
            this.session.save((Object)john);
            Person bob = new Person("Bob");
            this.session.save((Object)bob);
            Person bill = new Person("Bill");
            this.session.save((Object)bill);
            john = (Person)this.session.load(Person.class, (Serializable)john.getId());
            bob = (Person)this.session.load(Person.class, (Serializable)bob.getId());
            john.addFriend(bob);
            this.session.save((Object)john);
            john = (Person)this.session.load(Person.class, (Serializable)john.getId());
            bill = (Person)this.session.load(Person.class, (Serializable)bill.getId());
            john.addFriend(bill);
            this.session.save((Object)john);
            this.session.clear();
            this.session.load(Person.class, (Serializable)john.getId());
            Assertions.assertThat(john.getFriends()).hasSize(2);
        }
    }
}

