/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.linkedlist;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.linkedlist.Item;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class BidirectionalMappingTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.linkedlist"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldLoadDoublyLinkedList() {
        Item first = new Item();
        Item second = new Item();
        Item third = new Item();
        first.next = second;
        second.next = third;
        this.session.save((Object)first);
        this.session.clear();
        first = (Item)this.session.load(Item.class, (Serializable)first.getId(), -1);
        Assertions.assertThat((Long)first.next.getId()).isEqualTo((Object)second.getId());
        Assertions.assertThat((Long)first.next.next.getId()).isEqualTo((Object)third.getId());
        Assertions.assertThat((Object)first.next.next.next).isNull();
        Assertions.assertThat((Object)first.previous).isNull();
        Assertions.assertThat((Long)first.next.previous.getId()).isEqualTo((Object)first.getId());
        Assertions.assertThat((Long)first.next.next.previous.getId()).isEqualTo((Object)second.getId());
    }

    @Test
    public void shouldHandleSelfReferencingObjectOnRollback() {
        Item item;
        item.next = item = new Item();
        item.previous = item;
        try (Transaction tx = this.session.beginTransaction();){
            this.session.save((Object)item);
            this.session.deleteAll(Item.class);
        }
    }
}

