/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.locking;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.locking.EnemyOf;
import org.neo4j.ogm.domain.locking.FriendOf;
import org.neo4j.ogm.domain.locking.User;
import org.neo4j.ogm.exception.OptimisticLockingException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipEntityOptimisticLockingTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void setUpClass() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.locking"});
    }

    @Before
    public void setUp() throws Exception {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void whenSaveRelationshipEntityThenSetVersionToZero() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        Assertions.assertThat((Long)friendOf.getVersion()).isEqualTo(0L);
    }

    @Test
    public void givenRelationshipEntityWhenUpdateThenIncrementVersion() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        Date sinceUpdated = new Date();
        friendOf.setSince(sinceUpdated);
        this.session.save((Object)michael);
        Assertions.assertThat((Long)friendOf.getVersion()).isEqualTo(1L);
        this.session.clear();
        FriendOf loaded = (FriendOf)this.session.load(FriendOf.class, (Serializable)friendOf.getId());
        Assertions.assertThat((Date)loaded.getSince()).isEqualTo((Object)sinceUpdated);
        Assertions.assertThat((Long)loaded.getVersion()).isEqualTo(1L);
    }

    @Test
    public void givenRelationshipEntityWithWrongVersionWhenSaveThenFailWithOptimisticLockingException() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        friendOf.setSince(new Date());
        this.session.save((Object)friendOf);
        FriendOf wrongVersion = new FriendOf(michael, oliver);
        wrongVersion.setId(friendOf.getId());
        wrongVersion.setVersion(0L);
        Date updatedSince = new Date();
        wrongVersion.setSince(updatedSince);
        Assertions.assertThatThrownBy(() -> this.session.save((Object)wrongVersion, 0)).isInstanceOf(OptimisticLockingException.class);
    }

    @Test
    public void givenRelationshipEntityCustomThenOptimisticLockingCheckWorksAndThrowsException() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        EnemyOf enemyOf = new EnemyOf(michael, oliver, new Date());
        this.session.save((Object)enemyOf);
        Assertions.assertThat((Long)enemyOf.getCustomVersion()).isEqualTo(0L);
        enemyOf.setSince(new Date());
        this.session.save((Object)enemyOf);
        Assertions.assertThat((Long)enemyOf.getCustomVersion()).isEqualTo(1L);
        EnemyOf wrongVersion = new EnemyOf(michael, oliver, new Date());
        wrongVersion.setId(enemyOf.getId());
        wrongVersion.setCustomVersion(0L);
        Assertions.assertThatThrownBy(() -> this.session.save((Object)wrongVersion, 0)).isInstanceOf(OptimisticLockingException.class);
    }

    @Test
    public void givenRelationshipEntityWhenDeleteThenDeleteRelationshipEntity() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        this.session.delete((Object)friendOf);
        Collection friendOfs = this.session.loadAll(FriendOf.class);
        Assertions.assertThat((Iterable)friendOfs).isEmpty();
    }

    @Test
    public void saveDeletedRelationshipEntityShouldFailWithOptimisticLockingException() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        this.session.delete((Object)friendOf);
        friendOf.setSince(new Date());
        Assertions.assertThatThrownBy(() -> this.session.save((Object)friendOf)).isInstanceOf(OptimisticLockingException.class);
        Assertions.assertThatThrownBy(() -> this.session.save((Object)michael)).isInstanceOf(OptimisticLockingException.class);
        Collection friendOfs = this.session.loadAll(FriendOf.class);
        Assertions.assertThat((Iterable)friendOfs).isEmpty();
    }

    @Test
    public void givenRelationshipEntityWithWrongVersionWhenDeleteThenThrowOptimisticLockingException() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)friendOf);
        friendOf.setVersion(1L);
        Assertions.assertThatThrownBy(() -> this.session.delete((Object)friendOf)).isInstanceOf(OptimisticLockingException.class);
        this.session.clear();
        Collection friendOfs = this.session.loadAll(FriendOf.class);
        Assertions.assertThat((Iterable)friendOfs).hasSize(1);
    }

    @Test
    public void optimisticLockingExceptionShouldRollbackDefaultTransaction() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        friendOf.setSince(new Date());
        this.session.save((Object)friendOf);
        michael.setName("Michael Updated");
        oliver.setName("Oliver Updated");
        FriendOf wrongVersion = new FriendOf(michael, oliver);
        wrongVersion.setId(friendOf.getId());
        wrongVersion.setVersion(0L);
        Date updatedSince = new Date();
        wrongVersion.setSince(updatedSince);
        try {
            this.session.save((Object)wrongVersion, 0);
            Assertions.fail((String)"Expected OptimisticLockingException");
        }
        catch (OptimisticLockingException ex) {
            this.session.clear();
            Collection users = this.session.loadAll(User.class);
            Assertions.assertThat((Iterable)users).extracting(User::getName).containsOnly((Object[])new String[]{"Michael", "Oliver"});
        }
    }

    @Test
    public void removeVersionedRelationship() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        michael.clearFriends();
        this.session.save((Object)michael);
        this.ensureFriendsOfRelationshipsHaveCount(0L);
    }

    @Test
    public void updateVersionedRelationship() {
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        this.session.save((Object)michael);
        oliver.clearFriends();
        User george = new User("George");
        george.addFriend(friendOf);
        this.session.save((Object)michael);
        this.ensureFriendsOfRelationshipsHaveCount(1L);
    }

    private void ensureFriendsOfRelationshipsHaveCount(long count) {
        this.session.clear();
        Long relationshipCount = (Long)((Map)((Iterable)this.session.query("MATCH ()-[r:FRIEND_OF]->() return count(r) as c", Collections.emptyMap()).queryResults()).iterator().next()).get("c");
        Assertions.assertThat((Long)relationshipCount).isEqualTo(count);
    }
}

