/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.locking;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.locking.FriendOf;
import org.neo4j.ogm.domain.locking.User;
import org.neo4j.ogm.domain.locking.VersionedEntityWithExternalId;
import org.neo4j.ogm.exception.OptimisticLockingException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SessionCacheOptimisticLockingTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void setUpClass() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.locking"});
    }

    @Before
    public void setUp() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldLoadNewNodeVersionInSessionAfterFailureToSave() {
        Session session1 = sessionFactory.openSession();
        User frantisek = new User("Frantisek");
        session1.save((Object)frantisek);
        Session session2 = sessionFactory.openSession();
        User updated = new User("Frantisek The Ugly");
        updated.setId(frantisek.getId());
        updated.setVersion(0L);
        session2.save((Object)updated);
        try {
            frantisek.setName("Frantisek The Mighty");
            session1.save((Object)frantisek);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            User loaded = (User)session1.load(User.class, (Serializable)frantisek.getId());
            Assertions.assertThat((String)loaded.getName()).isEqualTo((Object)"Frantisek The Ugly");
        }
    }

    @Test
    public void shouldLoadNewNodeVersionInSessionAfterFailureToDelete() {
        Session session1 = sessionFactory.openSession();
        User frantisek = new User("Frantisek");
        session1.save((Object)frantisek);
        Session session2 = sessionFactory.openSession();
        User updated = new User("Frantisek The Ugly");
        updated.setId(frantisek.getId());
        updated.setVersion(0L);
        session2.save((Object)updated);
        try {
            session1.delete((Object)frantisek);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            User loaded = (User)session1.load(User.class, (Serializable)frantisek.getId());
            Assertions.assertThat((String)loaded.getName()).isEqualTo((Object)"Frantisek The Ugly");
            session1.delete((Object)loaded);
            loaded = (User)session1.load(User.class, (Serializable)frantisek.getId());
            Assertions.assertThat((Object)loaded).isNull();
        }
    }

    @Test
    public void shouldLoadNewRelationshipVersionInSessionAfterFailureToSave() {
        Session session1 = sessionFactory.openSession();
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        friendOf.setDescription("m-o");
        session1.save((Object)friendOf);
        Session session2 = sessionFactory.openSession();
        FriendOf updated = new FriendOf(michael, oliver);
        updated.setDescription("updated session 2");
        updated.setId(friendOf.getId());
        updated.setVersion(0L);
        session2.save((Object)updated, 0);
        try {
            friendOf.setDescription("updated session 1");
            session1.save((Object)friendOf, 0);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            FriendOf loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((String)loaded.getDescription()).isEqualTo((Object)"updated session 2");
        }
    }

    @Test
    public void shouldLoadNewRelationshipVersionInSessionAfterFailureToDelete() {
        Session session1 = sessionFactory.openSession();
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        friendOf.setDescription("m-o");
        session1.save((Object)friendOf);
        Session session2 = sessionFactory.openSession();
        FriendOf updated = new FriendOf(michael, oliver);
        updated.setDescription("updated session 2");
        updated.setId(friendOf.getId());
        updated.setVersion(0L);
        session2.save((Object)updated, 0);
        try {
            session1.delete((Object)friendOf);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            FriendOf loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((String)loaded.getDescription()).isEqualTo((Object)"updated session 2");
            session1.delete((Object)loaded);
            loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((Object)loaded).isNull();
        }
    }

    @Test
    public void shouldLoadNewRelationshipVersionInSessionAfterFailureToDeleteBySave() {
        Session session1 = sessionFactory.openSession();
        User alice = new User("Alice");
        User bob = new User("Bob");
        FriendOf friendOf = alice.addFriend(bob);
        friendOf.setDescription("a-b");
        session1.save((Object)friendOf);
        Session session2 = sessionFactory.openSession();
        FriendOf updated = new FriendOf(alice, bob);
        updated.setDescription("updated session 2");
        updated.setId(friendOf.getId());
        updated.setVersion(0L);
        session2.save((Object)updated, 0);
        try {
            alice.clearFriends();
            bob.clearFriends();
            session1.save((Object)alice);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            FriendOf loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((String)loaded.getDescription()).isEqualTo((Object)"updated session 2");
            session1.delete((Object)loaded);
            loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((Object)loaded).isNull();
        }
    }

    @Test
    public void lockingWithExternalIdsShouldWorkInDifferentSessions() throws InterruptedException {
        String cypherTemplate = "MATCH (n:VersionedEntityWithExternalId) WHERE n.name = 'Michael' RETURN n";
        VersionedEntityWithExternalId emp = new VersionedEntityWithExternalId();
        emp.setName("Michael");
        this.session.save((Object)emp);
        CountDownLatch t1latch = new CountDownLatch(1);
        CountDownLatch t2latch = new CountDownLatch(1);
        CountDownLatch outer = new CountDownLatch(2);
        AtomicBoolean gotException = new AtomicBoolean(false);
        new Thread(() -> {
            try {
                Session session1 = sessionFactory.openSession();
                VersionedEntityWithExternalId t1emp = (VersionedEntityWithExternalId)session1.queryForObject(VersionedEntityWithExternalId.class, "MATCH (n:VersionedEntityWithExternalId) WHERE n.name = 'Michael' RETURN n", Collections.emptyMap());
                t1emp.setSomething("OGM needs some real change here to trigger updates. " + ThreadLocalRandom.current().nextLong());
                t2latch.countDown();
                try {
                    t1latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                session1 = sessionFactory.openSession();
                session1.save((Object)t1emp);
            }
            catch (OptimisticLockingException e) {
                gotException.set(true);
            }
            finally {
                outer.countDown();
            }
        }).start();
        new Thread(() -> {
            try {
                try {
                    t2latch.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Session session2 = sessionFactory.openSession();
                VersionedEntityWithExternalId t2emp = (VersionedEntityWithExternalId)session2.queryForObject(VersionedEntityWithExternalId.class, "MATCH (n:VersionedEntityWithExternalId) WHERE n.name = 'Michael' RETURN n", Collections.emptyMap());
                t2emp.setSomething("OGM needs some real change here to trigger updates. " + ThreadLocalRandom.current().nextLong());
                session2.save((Object)t2emp);
                t1latch.countDown();
            }
            catch (OptimisticLockingException e) {
                gotException.set(true);
            }
            finally {
                outer.countDown();
            }
        }).start();
        outer.await();
        Assertions.assertThat((boolean)gotException.get()).isTrue();
    }
}

