/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.meetup;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.meetup.Meetup;
import org.neo4j.ogm.domain.meetup.Person;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class MeetupIntegrationTest
extends MultiDriverTestClass {
    private static Session session;

    @Before
    public void init() throws IOException {
        session = new SessionFactory(new String[]{"org.neo4j.ogm.domain.meetup"}).openSession();
    }

    @After
    public void clear() {
        session.purgeDatabase();
    }

    @Test
    public void shouldLoadRelatedPersonsCorrectly() {
        Meetup meetup = new Meetup("Neo4j UAE");
        Person michal = new Person("Michal");
        Person luanne = new Person("Luanne");
        meetup.setOrganiser(michal);
        michal.getMeetupOrganised().add(meetup);
        meetup.getAttendees().add(luanne);
        luanne.getMeetupsAttended().add(meetup);
        session.save((Object)meetup);
        session.clear();
        Meetup neoUae = (Meetup)session.load(Meetup.class, (Serializable)meetup.getId());
        Assertions.assertThat((Object)neoUae).isNotNull();
        Assertions.assertThat((Object)neoUae.getOrganiser()).isNotNull();
        Assertions.assertThat(neoUae.getAttendees()).hasSize(1);
    }
}

