/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.pets;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.pets.Dog;
import org.neo4j.ogm.domain.pets.DomesticDog;
import org.neo4j.ogm.domain.pets.Kid;
import org.neo4j.ogm.domain.pets.Mammal;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class PetIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.pets"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void teardown() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldResolveMetadataCorrectly() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.pets"});
        Assertions.assertThat((String)metaData.resolve(new String[]{"Animal"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.pets.Animal");
        Assertions.assertThat((String)metaData.resolve(new String[]{"Mammal", "Animal"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.pets.Mammal");
        Assertions.assertThat((String)metaData.resolve(new String[]{"Mammal", "Animal", "Dog"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.pets.Dog");
        Assertions.assertThat((String)metaData.resolve(new String[]{"Dog", "Mammal", "Animal"}).name()).isEqualTo((Object)"org.neo4j.ogm.domain.pets.Dog");
    }

    @Test
    public void shouldBeAbleToSaveAndLoadMammals() {
        Kid kid = new Kid("Charlie");
        Mammal mammal = new Mammal("unknown");
        kid.hasPet(mammal);
        this.session.save((Object)kid);
        this.session.clear();
        Kid charlie = (Kid)this.session.loadAll(Kid.class).iterator().next();
        Assertions.assertThat((Object)charlie).isNotNull();
        Assertions.assertThat(charlie.getPets()).hasSize(1);
        Assertions.assertThat((String)charlie.getPets().iterator().next().getName()).isEqualTo((Object)mammal.getName());
    }

    @Test
    public void shouldBeAbleToSaveAndLoadDogs() {
        Kid kid = new Kid("Charlie");
        Dog dog = new Dog("Snoopy");
        kid.hasPet(dog);
        this.session.save((Object)kid);
        this.session.clear();
        Kid charlie = (Kid)this.session.loadAll(Kid.class).iterator().next();
        Assertions.assertThat((Object)charlie).isNotNull();
        Assertions.assertThat(charlie.getPets()).hasSize(1);
        Assertions.assertThat((String)charlie.getPets().iterator().next().getName()).isEqualTo((Object)dog.getName());
    }

    @Test
    public void shouldBeAbleToSaveAndLoadDogsDirectly() {
        Dog dog = new Dog("Snoopy");
        this.session.save((Object)dog);
        this.session.clear();
        Dog snoopy = (Dog)this.session.loadAll(Dog.class).iterator().next();
        Assertions.assertThat((Object)snoopy).isNotNull();
        Assertions.assertThat((String)snoopy.getName()).isEqualTo((Object)dog.getName());
    }

    @Test
    public void shouldBeAbleToSaveAndLoadDomesticDogsDirectly() {
        DomesticDog dog = new DomesticDog("Snoopy");
        this.session.save((Object)dog);
        this.session.clear();
        DomesticDog snoopy = (DomesticDog)this.session.loadAll(DomesticDog.class).iterator().next();
        Assertions.assertThat((Object)snoopy).isNotNull();
        Assertions.assertThat((String)snoopy.getName()).isEqualTo((Object)dog.getName());
    }
}

