/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.pizza;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.domain.pizza.Cheese;
import org.neo4j.ogm.domain.pizza.Crust;
import org.neo4j.ogm.domain.pizza.Pizza;
import org.neo4j.ogm.domain.pizza.PizzaCheese;
import org.neo4j.ogm.domain.pizza.PizzaSauce;
import org.neo4j.ogm.domain.pizza.PizzaSeasoning;
import org.neo4j.ogm.domain.pizza.Quantity;
import org.neo4j.ogm.domain.pizza.Sauce;
import org.neo4j.ogm.domain.pizza.Seasoning;
import org.neo4j.ogm.domain.pizza.Topping;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class PizzaIntegrationTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.pizza"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void teardown() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldBeAbleToSaveAndLoadPizzaWithCrustOnly() {
        Crust crust = new Crust("Thin Crust");
        Pizza pizza = new Pizza("Just bread");
        pizza.setCrust(crust);
        this.session.save((Object)pizza);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat((Object)loadedPizza.getCrust()).isNotNull();
        Assertions.assertThat((String)loadedPizza.getCrust().getName()).isEqualTo((Object)crust.getName());
    }

    @Test
    public void shouldBeAbleToSaveAndLoadPizzaWithToppingsOnly() {
        Topping mushroom = new Topping("Mushroom");
        Topping pepperoni = new Topping("Pepperoni");
        Pizza pizza = new Pizza("Just toppings");
        pizza.setToppings(Arrays.asList(mushroom, pepperoni));
        this.session.save((Object)pizza);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat(loadedPizza.getToppings()).isNotNull();
        Assertions.assertThat(loadedPizza.getToppings()).hasSize(2);
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(mushroom)).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(pepperoni)).isTrue();
    }

    @Test
    public void shouldBeAbleToSaveAndLoadPizzaWithToppingsAndCrust() {
        Crust crust = new Crust("Thin Crust");
        Topping mushroom = new Topping("Mushroom");
        Topping pepperoni = new Topping("Pepperoni");
        Pizza pizza = new Pizza("Mushroom & Pepperoni", crust, Arrays.asList(mushroom, pepperoni));
        this.session.save((Object)pizza);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat((Object)loadedPizza.getCrust()).isNotNull();
        Assertions.assertThat((String)loadedPizza.getCrust().getName()).isEqualTo((Object)crust.getName());
        Assertions.assertThat(loadedPizza.getToppings()).isNotNull();
        Assertions.assertThat(loadedPizza.getToppings()).hasSize(2);
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(mushroom)).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(pepperoni)).isTrue();
    }

    @Test
    public void shouldBeAbleToSavePizzaWithOnlySauce() {
        Sauce sauce = new Sauce("Marinara");
        PizzaSauce pizzaSauce = new PizzaSauce();
        pizzaSauce.setSauce(sauce);
        pizzaSauce.setSpicy(true);
        Pizza pizza = new Pizza("Just sauce");
        pizza.setPizzaSauce(pizzaSauce);
        this.session.save((Object)pizza);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat((Object)loadedPizza.getPizzaSauce()).isNotNull();
        Assertions.assertThat((boolean)loadedPizza.getPizzaSauce().isSpicy()).isTrue();
        Assertions.assertThat((String)loadedPizza.getPizzaSauce().getSauce().getName()).isEqualTo((Object)sauce.getName());
    }

    @Test
    public void shouldBeAbleToSaveAndLoadAPizzaWithSeasonings() {
        Seasoning seasoning = new Seasoning("Chilli Flakes");
        Pizza pizza = new Pizza("Crazy Hot Pizza");
        PizzaSeasoning pizzaSeasoning = new PizzaSeasoning(pizza, seasoning, Quantity.DIE_TOMORROW);
        this.session.save((Object)pizzaSeasoning);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat(loadedPizza.getSeasonings()).hasSize(1);
        Assertions.assertThat((String)loadedPizza.getSeasonings().iterator().next().getSeasoning().getName()).isEqualTo((Object)seasoning.getName());
        Assertions.assertThat((Comparable)((Object)loadedPizza.getSeasonings().iterator().next().getQuantity())).isEqualTo((Object)Quantity.DIE_TOMORROW);
    }

    @Test
    public void shouldBeAbleToSaveAndLoadAPizzaWithCheese() {
        Cheese cheese = new Cheese("Mozzarella");
        Pizza pizza = new Pizza("Cheesy!");
        PizzaCheese pizzaCheese = new PizzaCheese(pizza, cheese, Quantity.DOUBLE);
        this.session.save((Object)pizzaCheese);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat(loadedPizza.getCheeses()).hasSize(1);
        Assertions.assertThat((String)loadedPizza.getCheeses().iterator().next().getCheese().getName()).isEqualTo((Object)cheese.getName());
        Assertions.assertThat((Comparable)((Object)loadedPizza.getCheeses().iterator().next().getQuantity())).isEqualTo((Object)Quantity.DOUBLE);
    }

    @Test
    public void shouldBeAbleToSaveAndRetrieveFullyLoadedPizza() {
        Crust crust = new Crust("Thin Crust");
        Topping mushroom = new Topping("Mushroom");
        Topping pepperoni = new Topping("Pepperoni");
        Sauce sauce = new Sauce("Marinara");
        PizzaSauce pizzaSauce = new PizzaSauce();
        pizzaSauce.setSauce(sauce);
        pizzaSauce.setSpicy(true);
        Pizza pizza = new Pizza("Mushroom & Pepperoni", crust, Arrays.asList(mushroom, pepperoni));
        pizza.setPizzaSauce(pizzaSauce);
        Seasoning seasoning = new Seasoning("Chilli Flakes");
        PizzaSeasoning pizzaSeasoning = new PizzaSeasoning(pizza, seasoning, Quantity.DIE_TOMORROW);
        Cheese cheese = new Cheese("Mozzarella");
        PizzaCheese pizzaCheese = new PizzaCheese(pizza, cheese, Quantity.DOUBLE);
        this.session.save((Object)pizza);
        this.session.save((Object)pizzaSeasoning);
        this.session.save((Object)pizzaCheese);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat((Object)loadedPizza.getPizzaSauce()).isNotNull();
        Assertions.assertThat((boolean)loadedPizza.getPizzaSauce().isSpicy()).isTrue();
        Assertions.assertThat((String)loadedPizza.getPizzaSauce().getSauce().getName()).isEqualTo((Object)sauce.getName());
        Assertions.assertThat((Object)loadedPizza.getCrust()).isNotNull();
        Assertions.assertThat((String)loadedPizza.getCrust().getName()).isEqualTo((Object)crust.getName());
        Assertions.assertThat(loadedPizza.getToppings()).isNotNull();
        Assertions.assertThat(loadedPizza.getToppings()).hasSize(2);
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(mushroom)).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(pepperoni)).isTrue();
        Assertions.assertThat(loadedPizza.getSeasonings()).hasSize(1);
        Assertions.assertThat((String)loadedPizza.getSeasonings().iterator().next().getSeasoning().getName()).isEqualTo((Object)seasoning.getName());
        Assertions.assertThat((Comparable)((Object)loadedPizza.getSeasonings().iterator().next().getQuantity())).isEqualTo((Object)Quantity.DIE_TOMORROW);
        Assertions.assertThat(loadedPizza.getCheeses()).hasSize(1);
        Assertions.assertThat((String)loadedPizza.getCheeses().iterator().next().getCheese().getName()).isEqualTo((Object)cheese.getName());
        Assertions.assertThat((Comparable)((Object)loadedPizza.getCheeses().iterator().next().getQuantity())).isEqualTo((Object)Quantity.DOUBLE);
    }

    @Test
    public void shouldUseOptimizedCypherWhenSavingRelationships() {
        Crust crust = new Crust("Thin Crust");
        this.session.save((Object)crust);
        Topping mushroom = new Topping("Mushroom");
        this.session.save((Object)mushroom);
        Topping pepperoni = new Topping("Pepperoni");
        this.session.save((Object)pepperoni);
        Pizza pizza = new Pizza();
        pizza.setName("Mushroom & Pepperoni");
        this.session.save((Object)pizza);
        pizza.setCrust(crust);
        pizza.setToppings(Arrays.asList(mushroom, pepperoni));
        this.session.save((Object)pizza);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((Object)loadedPizza).isNotNull();
        Assertions.assertThat((String)loadedPizza.getName()).isEqualTo((Object)pizza.getName());
        Assertions.assertThat((Object)loadedPizza.getCrust()).isNotNull();
        Assertions.assertThat((String)loadedPizza.getCrust().getName()).isEqualTo((Object)crust.getName());
        Assertions.assertThat(loadedPizza.getToppings()).isNotNull();
        Assertions.assertThat(loadedPizza.getToppings()).hasSize(2);
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(mushroom)).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getToppings().contains(pepperoni)).isTrue();
    }

    @Test
    public void shouldSyncMappedLabelsFromEntityToTheNode_and_NodeToEntity_noGetterOrSetter() {
        Pizza pizza = new Pizza();
        pizza.setName("Mushroom & Pepperoni");
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("Delicious");
        labels.add("Hot");
        labels.add("Spicy");
        pizza.setLabels(labels);
        this.session.save((Object)pizza);
        this.session.clear();
        GraphTestUtils.assertSameGraph((GraphDatabaseService)PizzaIntegrationTest.getGraphDatabaseService(), (String)"CREATE (n:`Pizza`:`Spicy`:`Hot`:`Delicious` {name: 'Mushroom & Pepperoni'})");
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((boolean)loadedPizza.getLabels().contains("Delicious")).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getLabels().contains("Hot")).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getLabels().contains("Spicy")).isTrue();
        Assertions.assertThat(loadedPizza.getLabels()).hasSize(3);
        ArrayList<String> newLabels = new ArrayList<String>();
        newLabels.add("Cold");
        newLabels.add("Stale");
        loadedPizza.setLabels(newLabels);
        this.session.save((Object)loadedPizza);
        this.session.clear();
        Pizza reloadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat(reloadedPizza.getLabels()).hasSize(2);
        Assertions.assertThat((boolean)reloadedPizza.getLabels().contains("Cold")).isTrue();
        Assertions.assertThat((boolean)reloadedPizza.getLabels().contains("Stale")).isTrue();
        newLabels = new ArrayList();
        newLabels.add("Cold");
        newLabels.add("Decomposed");
        reloadedPizza.setLabels(newLabels);
        this.session.save((Object)reloadedPizza);
        this.session.clear();
        Pizza zombiePizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat(zombiePizza.getLabels()).hasSize(2);
        Assertions.assertThat((boolean)zombiePizza.getLabels().contains("Cold")).isTrue();
        Assertions.assertThat((boolean)zombiePizza.getLabels().contains("Decomposed")).isTrue();
    }

    @Test
    public void shouldApplyLabelsWhenSessionClearedBeforeSave() {
        Pizza pizza = new Pizza();
        pizza.setName("Mushroom & Pepperoni");
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("Delicious");
        labels.add("Hot");
        labels.add("Spicy");
        pizza.setLabels(labels);
        this.session.save((Object)pizza);
        this.session.clear();
        GraphTestUtils.assertSameGraph((GraphDatabaseService)PizzaIntegrationTest.getGraphDatabaseService(), (String)"CREATE (n:`Pizza`:`Spicy`:`Hot`:`Delicious` {name: 'Mushroom & Pepperoni'})");
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((boolean)loadedPizza.getLabels().contains("Delicious")).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getLabels().contains("Hot")).isTrue();
        Assertions.assertThat((boolean)loadedPizza.getLabels().contains("Spicy")).isTrue();
        Assertions.assertThat(loadedPizza.getLabels()).hasSize(3);
        ArrayList<String> newLabels = new ArrayList<String>();
        newLabels.add("Cold");
        newLabels.add("Stale");
        loadedPizza.setLabels(newLabels);
        this.session.clear();
        this.session.save((Object)loadedPizza);
        Pizza reloadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat(reloadedPizza.getLabels()).hasSize(2);
        Assertions.assertThat((boolean)reloadedPizza.getLabels().contains("Cold")).isTrue();
        Assertions.assertThat((boolean)reloadedPizza.getLabels().contains("Stale")).isTrue();
    }

    @Test
    public void shouldRaiseExceptionWhenAmbiguousClassLabelApplied() {
        Session session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.pizza", "org.neo4j.ogm.domain.music"}).openSession();
        Pizza pizza = new Pizza();
        pizza.setName("Mushroom & Pepperoni");
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("Studio");
        pizza.setLabels(labels);
        session.save((Object)pizza);
        session.clear();
        try {
            session.load(Pizza.class, (Serializable)pizza.getId());
        }
        catch (MappingException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo((Object)"Multiple classes found in type hierarchy that map to: [Pizza, Studio]");
        }
    }

    @Test
    public void shouldUpdateSessionContextAfterSaveForSingleAndMultiStatementCypherQueries() {
        Pizza pizza = new Pizza();
        this.session.save((Object)pizza);
        this.session.clear();
        Pizza loadedPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Crust crust = new Crust("Thin Crust");
        pizza.setCrust(crust);
        pizza.setName("Just bread");
        Assertions.assertThat((boolean)((Neo4jSession)this.session).context().isDirty((Object)pizza)).isTrue();
        this.session.save((Object)pizza);
        Assertions.assertThat((boolean)((Neo4jSession)this.session).context().isDirty((Object)pizza)).isFalse();
    }

    @Test
    public void shouldBeAbleToModifyPropertiesAndRelsWithinSingleSave() {
        Crust crust = new Crust("Thin Crust");
        Topping pepperoni = new Topping("Pepperoni");
        ArrayList<Topping> toppings = new ArrayList<Topping>();
        toppings.add(pepperoni);
        Pizza pizza = new Pizza("Godfather", crust, toppings);
        this.session.save((Object)pizza);
        Topping mushroom = new Topping("Mushroom");
        this.session.save((Object)pepperoni);
        this.session.save((Object)mushroom);
        this.session.clear();
        Long id = pizza.getId();
        Assertions.assertThat((Long)id).isNotNull();
        Session session2 = sessionFactory.openSession();
        Pizza loadedPizza = (Pizza)session2.load(Pizza.class, (Serializable)id);
        loadedPizza.setName("Just bread");
        loadedPizza.getToppings().clear();
        Topping pepperoniTopping = (Topping)session2.load(Topping.class, (Serializable)pepperoni.getId());
        loadedPizza.getToppings().add(pepperoniTopping);
        Topping mushroomTopping = (Topping)session2.load(Topping.class, (Serializable)pepperoni.getId());
        loadedPizza.getToppings().add(mushroomTopping);
        Assertions.assertThat((boolean)((Neo4jSession)session2).context().isDirty((Object)loadedPizza)).isTrue();
        session2.save((Object)loadedPizza);
        Assertions.assertThat((boolean)((Neo4jSession)session2).context().isDirty((Object)loadedPizza)).isFalse();
    }

    @Test
    public void shouldMarkLabelsAsDirtyWhenExistingCollectionUpdated() {
        Pizza entity = new Pizza();
        List<String> labels = new ArrayList<String>();
        labels.add("TestLabel1");
        labels.add("TestLabel2");
        entity.setLabels(labels);
        this.session.save((Object)entity);
        this.session.clear();
        entity = (Pizza)this.session.load(Pizza.class, (Serializable)entity.getId());
        entity.getLabels().remove("TestLabel1");
        this.session.save((Object)entity);
        this.session.clear();
        labels = ((Pizza)this.session.load(Pizza.class, (Serializable)entity.getId())).getLabels();
        Assertions.assertThat(labels).hasSize(1);
    }

    @Test
    public void shouldDeleteChangedIncomingRelationship() throws Exception {
        Pizza pizza = new Pizza();
        Crust deepDishCrust = new Crust("Deep Dish");
        Crust thinNCrispyCrust = new Crust("Thin 'n Crispy");
        pizza.setCrust(deepDishCrust);
        this.session.save((Object)pizza);
        this.assertOneRelationshipInDb();
        pizza.setCrust(thinNCrispyCrust);
        this.session.save((Object)pizza);
        this.assertOneRelationshipInDb();
    }

    @Test
    public void shouldDeleteChangedIncomingRelationshipWithClearSessionAndLoad() throws Exception {
        Pizza pizza = new Pizza();
        Crust deepDishCrust = new Crust("Deep Dish");
        Crust thinNCrispyCrust = new Crust("Thin 'n Crispy");
        pizza.setCrust(deepDishCrust);
        this.session.save((Object)pizza);
        this.assertOneRelationshipInDb();
        this.session.clear();
        pizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        pizza.setCrust(thinNCrispyCrust);
        this.session.save((Object)pizza);
        this.assertOneRelationshipInDb();
    }

    @Test
    public void shouldUpdateLabelWhenLoadingEntityInSameSession() {
        Pizza pizza = new Pizza();
        pizza.addLabel("A0");
        this.session.save((Object)pizza);
        this.session.clear();
        Pizza dbPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((int)dbPizza.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbPizza.getLabels()).contains((Object[])new String[]{"A0"});
        dbPizza.removeLabel("A0");
        dbPizza.addLabel("A1");
        this.session.save((Object)dbPizza);
        this.session.clear();
        dbPizza = (Pizza)this.session.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((int)dbPizza.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbPizza.getLabels()).contains((Object[])new String[]{"A1"});
    }

    @Test
    public void shouldUpdateLabelWhenLoadingEntityInNewSession() {
        Pizza pizza = new Pizza();
        pizza.addLabel("A0");
        this.session.save((Object)pizza);
        Session newSession = sessionFactory.openSession();
        Pizza dbPizza = (Pizza)newSession.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((int)dbPizza.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbPizza.getLabels()).contains((Object[])new String[]{"A0"});
        dbPizza.removeLabel("A0");
        dbPizza.addLabel("A1");
        newSession.save((Object)dbPizza);
        newSession.clear();
        dbPizza = (Pizza)newSession.load(Pizza.class, (Serializable)pizza.getId());
        Assertions.assertThat((int)dbPizza.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbPizza.getLabels()).contains((Object[])new String[]{"A1"});
    }

    private void assertOneRelationshipInDb() {
        Result result = sessionFactory.openSession().query("MATCH (p:Pizza)-[r]-() return count(r) as c", new HashMap());
        Map row = (Map)result.iterator().next();
        Number count = (Number)row.get("c");
        Assertions.assertThat((long)count.longValue()).isEqualTo(1L);
    }
}

