/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.satellite;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.domain.satellites.Program;
import org.neo4j.ogm.domain.satellites.Satellite;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.testutil.TestUtils;
import org.neo4j.ogm.transaction.Transaction;

public class SatelliteIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.satellites"});
        Session initialSession = sessionFactory.openSession();
        initialSession.query(TestUtils.readCQLFile((String)"org/neo4j/ogm/cql/satellites.cql").toString(), Utils.map((Object[])new Object[0]));
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @Test
    @Ignore(value="ignored after asymmetric querying, relationship Program - Satellite is inconsistent, test data satellites.cqlcontains something that would not be possible to create with OGM with current model")
    public void shouldLoadPrograms() {
        Collection programs = this.session.loadAll(Program.class);
        if (!programs.isEmpty()) {
            Assertions.assertThat((Iterable)programs).hasSize(4);
            for (Program program : programs) {
                for (Satellite satellite : program.getSatellites()) {
                    Assertions.assertThat((Object)satellite.getProgram()).isNull();
                }
            }
        } else {
            Assertions.fail((String)"Satellite Integration Tests not run: Is there a database?");
        }
    }

    @Test
    public void shouldLoadSatellites() {
        Collection satellites = this.session.loadAll(Satellite.class);
        if (!satellites.isEmpty()) {
            Assertions.assertThat((Iterable)satellites).hasSize(11);
            for (Satellite satellite : satellites) {
                Assertions.assertThat((String)satellite.getName()).isEqualTo((Object)satellite.getRef());
            }
        } else {
            Assertions.fail((String)"Satellite Integration Tests not run: Is there a database?");
        }
    }

    @Test
    public void shouldUpdateSatellite() {
        Collection satellites = this.session.loadAll(Satellite.class);
        if (!satellites.isEmpty()) {
            Satellite satellite = (Satellite)satellites.iterator().next();
            Long id = satellite.getId();
            satellite.setName("Updated satellite");
            Date date = new Date();
            satellite.setUpdated(date);
            this.session.save((Object)satellite);
            Satellite updatedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
            Assertions.assertThat((String)updatedSatellite.getName()).isEqualTo((Object)"Updated satellite");
            Assertions.assertThat((Date)updatedSatellite.getUpdated()).isEqualTo((Object)date);
        } else {
            Assertions.fail((String)"Satellite Integration Tests not run: Is there a database?");
        }
    }

    @Test
    public void shouldUseLongTransaction() {
        try (Transaction tx = this.session.beginTransaction();){
            Collection satellites = this.session.loadAll(Satellite.class);
            Assertions.assertThat((Iterable)satellites).hasSize(11);
            Satellite satellite = (Satellite)satellites.iterator().next();
            Long id = satellite.getId();
            satellite.setName("Updated satellite");
            this.session.save((Object)satellite);
            Satellite updatedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
            Assertions.assertThat((String)updatedSatellite.getName()).isEqualTo((Object)"Updated satellite");
        }
    }

    @Test
    public void shouldRollbackLongTransaction() {
        String name;
        Long id;
        try (Transaction tx = this.session.beginTransaction();){
            Collection satellites = this.session.loadAll(Satellite.class);
            Assertions.assertThat((Iterable)satellites).hasSize(11);
            Satellite satellite = (Satellite)satellites.iterator().next();
            id = satellite.getId();
            name = satellite.getName();
            satellite.setName("Updated satellite");
            this.session.save((Object)satellite);
            this.session.clear();
            Satellite updatedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
            Assertions.assertThat((String)updatedSatellite.getName()).isEqualTo((Object)"Updated satellite");
            tx.rollback();
        }
        this.session.clear();
        Satellite reloadedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
        Assertions.assertThat((String)reloadedSatellite.getName()).isEqualTo((Object)name);
    }

    @Test
    public void shouldRollbackClosedAndUnCommittedTransaction() {
        String name;
        Long id;
        try (Transaction tx = this.session.beginTransaction();){
            Collection satellites = this.session.loadAll(Satellite.class);
            Assertions.assertThat((Iterable)satellites).hasSize(11);
            Satellite satellite = (Satellite)satellites.iterator().next();
            id = satellite.getId();
            name = satellite.getName();
            satellite.setName("Updated satellite");
            this.session.save((Object)satellite);
            this.session.clear();
            Satellite updatedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
            Assertions.assertThat((String)updatedSatellite.getName()).isEqualTo((Object)"Updated satellite");
        }
        this.session.clear();
        Satellite reloadedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
        Assertions.assertThat((String)reloadedSatellite.getName()).isEqualTo((Object)name);
    }

    @Test
    public void shouldCommitLongTransaction() {
        Long id;
        try (Transaction tx = this.session.beginTransaction();){
            Collection satellites = this.session.loadAll(Satellite.class);
            Assertions.assertThat((Iterable)satellites).hasSize(11);
            Satellite satellite = (Satellite)satellites.iterator().next();
            id = satellite.getId();
            satellite.setName("Updated satellite");
            this.session.save((Object)satellite);
            this.session.clear();
            Satellite updatedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
            Assertions.assertThat((String)updatedSatellite.getName()).isEqualTo((Object)"Updated satellite");
            tx.commit();
        }
        this.session.clear();
        Satellite reloadedSatellite = (Satellite)this.session.load(Satellite.class, (Serializable)id);
        Assertions.assertThat((String)reloadedSatellite.getName()).isEqualTo((Object)"Updated satellite");
    }

    @Test
    public void shouldReturnSatellitesSortedByRefAsc() {
        Collection satellites = this.session.loadAll(Satellite.class, new SortOrder().add(new String[]{"ref"}));
        Iterator iter = satellites.iterator();
        Satellite first = (Satellite)iter.next();
        while (iter.hasNext()) {
            Satellite next = (Satellite)iter.next();
            Assertions.assertThat((first.getRef().compareTo(next.getRef()) < 0 ? 1 : 0) != 0).isTrue();
            first = next;
        }
    }

    @Test
    public void shouldReturnProgramsSortedByRefDesc() {
        Collection objects = this.session.loadAll(Program.class, new SortOrder().add(SortOrder.Direction.DESC, new String[]{"ref"}));
        Iterator iter = objects.iterator();
        Program first = (Program)iter.next();
        while (iter.hasNext()) {
            Program next = (Program)iter.next();
            Assertions.assertThat((first.getRef().compareTo(next.getRef()) > 0 ? 1 : 0) != 0).isTrue();
            first = next;
        }
    }

    @Test
    public void shouldLoadActiveSatellitesByPropertySorted() {
        Collection satellites = this.session.loadAll(Satellite.class, new Filter("manned", ComparisonOperator.EQUALS, (Object)"Y"), new SortOrder().add(new String[]{"ref"}));
        Iterator iter = satellites.iterator();
        Satellite first = (Satellite)iter.next();
        while (iter.hasNext()) {
            Satellite next = (Satellite)iter.next();
            Assertions.assertThat((first.getRef().compareTo(next.getRef()) < 0 ? 1 : 0) != 0).isTrue();
            first = next;
        }
    }
}

