/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.simpleNetwork;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.simpleNetwork.classes.IdentityNode;
import org.neo4j.ogm.domain.simpleNetwork.classes.StateNode;
import org.neo4j.ogm.domain.simpleNetwork.classes.TimeRelation;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SimpleNetworkIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.simpleNetwork"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldReadIdentityNodeAlongWithStates() {
        IdentityNode identityNode = new IdentityNode();
        StateNode stateNode1 = new StateNode();
        stateNode1.setName("Good graph databases");
        stateNode1.setDescription("We sell World's Leading Graph Database");
        StateNode stateNode2 = new StateNode();
        stateNode2.setName("Great graph databases");
        stateNode2.setDescription("We sell World's Leading Graph Database");
        TimeRelation identityState1 = new TimeRelation();
        identityState1.setSourceNode(identityNode);
        identityState1.setTargetNode(stateNode1);
        TimeRelation identityState2 = new TimeRelation();
        identityState2.setSourceNode(identityNode);
        identityState2.setTargetNode(stateNode2);
        HashSet<TimeRelation> identityStates = new HashSet<TimeRelation>();
        identityStates.add(identityState1);
        identityStates.add(identityState2);
        identityNode.setStates((Set<TimeRelation>)identityStates);
        this.session.save((Object)identityNode);
        this.session.clear();
        IdentityNode loadedIdentityNode = (IdentityNode)this.session.load(IdentityNode.class, (Serializable)identityNode.getId());
        Assertions.assertThat(loadedIdentityNode.getStates()).hasSize(2);
    }
}

