/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.social;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.social.Individual;
import org.neo4j.ogm.domain.social.Mortal;
import org.neo4j.ogm.domain.social.Person;
import org.neo4j.ogm.domain.social.User;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SocialIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldFetchOnlyPeopleILike() {
        this.session.query("create (p1:Person {name:'A'}) create (p2:Person {name:'B'}) create (p3:Person {name:'C'}) create (p4:Person {name:'D'}) create (p1)-[:LIKES]->(p2) create (p1)-[:LIKES]->(p3) create (p4)-[:LIKES]->(p1)", Collections.EMPTY_MAP);
        Person personA = (Person)this.session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"A")).iterator().next();
        Assertions.assertThat((Object)personA).isNotNull();
        Assertions.assertThat(personA.getPeopleILike()).hasSize(2);
        Person personD = (Person)this.session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"D")).iterator().next();
        Assertions.assertThat((Object)personD).isNotNull();
        Assertions.assertThat(personD.getPeopleILike()).hasSize(1);
        Assertions.assertThat((Object)personD.getPeopleILike().get(0)).isEqualTo((Object)personA);
    }

    @Test
    public void shouldFetchFriendsInBothDirections() {
        this.session.query("create (p1:Individual {name:'A'}) create (p2:Individual {name:'B'}) create (p3:Individual {name:'C'}) create (p4:Individual {name:'D'}) create (p1)-[:FRIENDS]->(p2) create (p1)-[:FRIENDS]->(p3) create (p4)-[:FRIENDS]->(p1)", Collections.EMPTY_MAP);
        Individual individualA = (Individual)this.session.loadAll(Individual.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"A")).iterator().next();
        Assertions.assertThat((Object)individualA).isNotNull();
        Assertions.assertThat(individualA.getFriends()).hasSize(2);
    }

    @Test
    public void shouldFetchFriendsForUndirectedRelationship() {
        this.session.query("create (p1:User {name:'A'}) create (p2:User {name:'B'}) create (p3:User {name:'C'}) create (p4:User {name:'D'}) create (p1)-[:FRIEND]->(p2) create (p1)-[:FRIEND]->(p3) create (p4)-[:FRIEND]->(p1)", Collections.EMPTY_MAP);
        User userA = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"A")).iterator().next();
        Assertions.assertThat((Object)userA).isNotNull();
        Assertions.assertThat(userA.getFriends()).hasSize(3);
        User userB = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"B")).iterator().next();
        Assertions.assertThat((Object)userB).isNotNull();
        Assertions.assertThat(userB.getFriends()).hasSize(1);
        Assertions.assertThat((Object)userB.getFriends().get(0)).isEqualTo((Object)userA);
        User userD = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"D")).iterator().next();
        Assertions.assertThat((Object)userD).isNotNull();
        Assertions.assertThat(userD.getFriends()).hasSize(1);
        Assertions.assertThat((Object)userD.getFriends().get(0)).isEqualTo((Object)userA);
    }

    @Test
    public void shouldSaveUndirectedFriends() {
        User userA = new User("A");
        User userB = new User("B");
        User userC = new User("C");
        User userD = new User("D");
        userA.getFriends().add(userB);
        userA.getFriends().add(userC);
        userD.getFriends().add(userA);
        this.session.save((Object)userA);
        this.session.save((Object)userB);
        this.session.save((Object)userC);
        this.session.save((Object)userD);
        this.session.clear();
        userA = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"A")).iterator().next();
        Assertions.assertThat((Object)userA).isNotNull();
        Assertions.assertThat(userA.getFriends()).hasSize(3);
        userB = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"B")).iterator().next();
        Assertions.assertThat((Object)userB).isNotNull();
        Assertions.assertThat(userB.getFriends()).hasSize(1);
        Assertions.assertThat((String)userB.getFriends().get(0).getName()).isEqualTo((Object)userA.getName());
        userD = (User)this.session.loadAll(User.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"D")).iterator().next();
        Assertions.assertThat((Object)userD).isNotNull();
        Assertions.assertThat(userD.getFriends()).hasSize(1);
        Assertions.assertThat((String)userD.getFriends().get(0).getName()).isEqualTo((Object)userA.getName());
    }

    @Test
    public void shouldSaveUndirectedFriendsInBothDirections() {
        Person userA = new Person("A");
        Person userB = new Person("B");
        userA.getPeopleILike().add(userB);
        userB.getPeopleILike().add(userA);
        this.session.save((Object)userA);
        this.session.clear();
        userA = (Person)this.session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"A")).iterator().next();
        Assertions.assertThat((Object)userA).isNotNull();
        Assertions.assertThat(userA.getPeopleILike()).hasSize(1);
        this.session.clear();
        userB = (Person)this.session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"B")).iterator().next();
        Assertions.assertThat((Object)userB).isNotNull();
        Assertions.assertThat(userB.getPeopleILike()).hasSize(1);
    }

    @Test
    public void shouldSaveIncomingKnownMortals() {
        Mortal mortalA = new Mortal("A");
        Mortal mortalB = new Mortal("B");
        Mortal mortalC = new Mortal("C");
        Mortal mortalD = new Mortal("D");
        mortalA.getKnownBy().add(mortalB);
        mortalA.getKnownBy().add(mortalC);
        mortalD.getKnownBy().add(mortalA);
        this.session.save((Object)mortalA);
        this.session.save((Object)mortalB);
        this.session.save((Object)mortalC);
        this.session.save((Object)mortalD);
        this.session.clear();
        mortalA = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"A")).iterator().next();
        Assertions.assertThat((Object)mortalA).isNotNull();
        Assertions.assertThat(mortalA.getKnownBy()).hasSize(2);
        mortalB = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"B")).iterator().next();
        Assertions.assertThat((Object)mortalB).isNotNull();
        Assertions.assertThat(mortalB.getKnownBy()).isEmpty();
        mortalC = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"C")).iterator().next();
        Assertions.assertThat((Object)mortalC).isNotNull();
        Assertions.assertThat(mortalC.getKnownBy()).isEmpty();
        mortalD = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"D")).iterator().next();
        Assertions.assertThat((Object)mortalD).isNotNull();
        Assertions.assertThat(mortalD.getKnownBy()).hasSize(1);
        Assertions.assertThat((String)mortalD.getKnownBy().iterator().next().getName()).isEqualTo((Object)"A");
    }

    @Test
    public void shouldFetchIncomingKnownMortals() {
        this.session.query("create (m1:Mortal {name:'A'}) create (m2:Mortal {name:'B'}) create (m3:Mortal {name:'C'}) create (m4:Mortal {name:'D'}) create (m1)<-[:KNOWN_BY]-(m2) create (m1)<-[:KNOWN_BY]-(m3) create (m4)<-[:KNOWN_BY]-(m1)", Collections.EMPTY_MAP);
        Mortal mortalA = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"A")).iterator().next();
        Assertions.assertThat((Object)mortalA).isNotNull();
        Assertions.assertThat(mortalA.getKnownBy()).hasSize(2);
        Mortal mortalB = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"B")).iterator().next();
        Assertions.assertThat((Object)mortalB).isNotNull();
        Assertions.assertThat(mortalB.getKnownBy()).isEmpty();
        Mortal mortalC = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"C")).iterator().next();
        Assertions.assertThat((Object)mortalC).isNotNull();
        Assertions.assertThat(mortalC.getKnownBy()).isEmpty();
        Mortal mortalD = (Mortal)this.session.loadAll(Mortal.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"D")).iterator().next();
        Assertions.assertThat((Object)mortalD).isNotNull();
        Assertions.assertThat(mortalD.getKnownBy()).hasSize(1);
        Assertions.assertThat((String)mortalD.getKnownBy().iterator().next().getName()).isEqualTo((Object)"A");
    }

    @Test
    public void shouldFetchFriendsUndirected() {
        User adam = new User("Adam");
        User daniela = new User("Daniela");
        User michal = new User("Michal");
        User vince = new User("Vince");
        adam.befriend(daniela);
        daniela.befriend(michal);
        michal.befriend(vince);
        this.session.save((Object)adam);
        this.session.clear();
        adam = (User)this.session.load(User.class, (Serializable)adam.getId());
        Assertions.assertThat(adam.getFriends()).hasSize(1);
        daniela = (User)this.session.load(User.class, (Serializable)daniela.getId());
        Assertions.assertThat(daniela.getFriends()).hasSize(2);
        ArrayList<String> friendNames = new ArrayList<String>();
        for (User friend : daniela.getFriends()) {
            friendNames.add(friend.getName());
        }
        Assertions.assertThat((boolean)friendNames.contains("Adam")).isTrue();
        Assertions.assertThat((boolean)friendNames.contains("Michal")).isTrue();
        this.session.clear();
        michal = (User)this.session.load(User.class, (Serializable)michal.getId());
        Assertions.assertThat(michal.getFriends()).hasSize(2);
        this.session.clear();
        vince = (User)this.session.load(User.class, (Serializable)vince.getId());
        Assertions.assertThat(vince.getFriends()).hasSize(1);
    }

    @Test
    public void shouldSaveObjectsToCorrectDepth() throws Exception {
        Person a = new Person("A");
        Person b = new Person("B");
        Person c = new Person("C");
        Person d = new Person("D");
        Person e = new Person("E");
        a.addPersonILike(b);
        b.addPersonILike(c);
        a.addPersonILike(d);
        d.addPersonILike(e);
        b.addPersonILike(d);
        d.addPersonILike(b);
        this.session.save((Object)a, 2);
        this.session.clear();
        Collection people = this.session.loadAll(Person.class);
        Assertions.assertThat((Iterable)people).hasSize(5);
    }

    @Test
    public void shouldSaveAllDirectedRelationships() throws Exception {
        Person a = new Person("A");
        Person b = new Person("B");
        Person c = new Person("C");
        Person d = new Person("D");
        Person e = new Person("E");
        a.addPersonILike(b);
        b.addPersonILike(c);
        a.addPersonILike(d);
        d.addPersonILike(e);
        b.addPersonILike(d);
        d.addPersonILike(b);
        this.session.save((Object)a);
        this.session.clear();
        Person loadedB = (Person)this.session.load(Person.class, (Serializable)b.getId());
        Assertions.assertThat(loadedB.getPeopleILike()).hasSize(2);
        Person loadedD = (Person)this.session.load(Person.class, (Serializable)d.getId());
        Assertions.assertThat(loadedD.getPeopleILike()).hasSize(2);
    }
}

