/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.tree;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.tree.Node;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SingleDirectionMappingTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        this.session = new SessionFactory(new String[]{"org.neo4j.ogm.domain.tree"}).openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldLoadCorrectRelationshipsWhenUsingDefaultDirection() throws Exception {
        Node node1 = new Node("Node 1");
        Node node2 = new Node("Node 2");
        node1.add(node2);
        Node node3 = new Node("Node 3");
        node2.add(node3);
        this.session.save((Object)node1);
        Node loaded = (Node)this.session.load(Node.class, (Serializable)node1.getId());
        Assertions.assertThat(loaded.getNodes()).hasSize(1);
        Assertions.assertThat(loaded.getNodes().iterator().next().getNodes()).hasSize(1);
    }
}

