/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.tree;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.tree.Entity;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class TreeIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.tree"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldCreateTreeProperly() {
        Entity parent = new Entity("parent");
        Entity child01 = new Entity("child01").setParent(parent);
        Entity child02 = new Entity("child02").setParent(parent);
        this.session.save((Object)parent);
        this.session.clear();
        parent = (Entity)this.session.load(Entity.class, (Serializable)parent.getId());
        Assertions.assertThat((Comparable)parent).isNotNull();
        Assertions.assertThat(parent.getChildren()).hasSize(2);
        Assertions.assertThat((Comparable)parent.getParent()).isNull();
        ArrayList<String> childNames = new ArrayList<String>();
        for (Entity child : parent.getChildren()) {
            childNames.add(child.getName());
            Assertions.assertThat((String)child.getParent().getName()).isEqualTo((Object)parent.getName());
        }
        Assertions.assertThat((boolean)childNames.contains(child01.getName())).isTrue();
        Assertions.assertThat((boolean)childNames.contains(child02.getName())).isTrue();
    }

    @Test
    public void shouldLoadTreeProperly() {
        String cypher = "CREATE (parent:Entity {name:'parent'}) CREATE (child1:Entity {name:'c1'}) CREATE (child2:Entity {name:'c2'}) CREATE (child1)-[:REL]->(parent) CREATE (child2)-[:REL]->(parent)";
        this.session.query(cypher, Utils.map((Object[])new Object[0]));
        this.session.clear();
        Entity parent = (Entity)this.session.loadAll(Entity.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"parent")).iterator().next();
        Assertions.assertThat((Comparable)parent).isNotNull();
        Assertions.assertThat(parent.getChildren()).hasSize(2);
        Assertions.assertThat((Comparable)parent.getParent()).isNull();
        ArrayList<String> childNames = new ArrayList<String>();
        for (Entity child : parent.getChildren()) {
            childNames.add(child.getName());
            Assertions.assertThat((String)child.getParent().getName()).isEqualTo((Object)parent.getName());
        }
        Assertions.assertThat((boolean)childNames.contains("c1")).isTrue();
        Assertions.assertThat((boolean)childNames.contains("c2")).isTrue();
    }

    @Test
    public void shouldMapElementsToTreeSetProperly() {
        String cypher = "CREATE (parent:Entity {name:'parent'}) CREATE (child1:Entity {name:'c1'}) CREATE (child2:Entity {name:'c2'}) CREATE (child1)-[:REL]->(parent) CREATE (child2)-[:REL]->(parent)";
        this.session.query(cypher, Utils.map((Object[])new Object[0]));
        this.session.clear();
        Entity parent = (Entity)this.session.loadAll(Entity.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"parent")).iterator().next();
        Assertions.assertThat((Comparable)parent).isNotNull();
        Assertions.assertThat(parent.getChildren()).hasSize(2);
        Assertions.assertThat((Comparable)parent.getParent()).isNull();
        ArrayList<String> childNames = new ArrayList<String>();
        for (Entity child : parent.getChildren()) {
            childNames.add(child.getName());
            Assertions.assertThat((String)child.getParent().getName()).isEqualTo((Object)parent.getName());
        }
        Assertions.assertThat((String)((String)childNames.get(0))).isEqualTo((Object)"c1");
        Assertions.assertThat((String)((String)childNames.get(1))).isEqualTo((Object)"c2");
    }
}

