/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.domain.social.Individual;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ArraysMappingTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
    }

    @Before
    public void setUpMapper() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldGenerateCypherToPersistArraysOfPrimitives() {
        Individual individual = new Individual();
        individual.setName("Jeff");
        individual.setAge(41);
        individual.setBankBalance(1000.5f);
        individual.setPrimitiveIntArray(new int[]{1, 6, 4, 7, 2});
        this.session.save((Object)individual);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ArraysMappingTest.getGraphDatabaseService(), (String)"CREATE (:Individual {name:'Jeff', age:41, bankBalance: 1000.50, code:0, primitiveIntArray:[1,6,4,7,2]})");
        this.session.clear();
        Individual loadedIndividual = (Individual)this.session.load(Individual.class, (Serializable)individual.getId());
        Assertions.assertThat((int[])loadedIndividual.getPrimitiveIntArray()).isEqualTo((Object)individual.getPrimitiveIntArray());
    }

    @Test
    public void shouldGenerateCypherToPersistByteArray() {
        Individual individual = new Individual();
        individual.setAge(41);
        individual.setBankBalance(1000.5f);
        individual.setPrimitiveByteArray(new byte[]{1, 2, 3, 4, 5});
        this.session.save((Object)individual);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ArraysMappingTest.getGraphDatabaseService(), (String)"CREATE (:Individual {age:41, bankBalance: 1000.50, code:0, primitiveByteArray:'AQIDBAU='})");
        Result executionResult = ArraysMappingTest.getGraphDatabaseService().execute("MATCH (i:Individual) RETURN i.primitiveByteArray AS bytes");
        Map result = executionResult.next();
        executionResult.close();
        Assertions.assertThat(result.get("bytes")).as("The array wasn't persisted as the correct type", new Object[0]).isEqualTo((Object)"AQIDBAU=");
    }

    @Test
    public void shouldGenerateCypherToPersistCollectionOfBoxedPrimitivesToArrayOfPrimitives() {
        Individual individual = new Individual();
        individual.setName("Gary");
        individual.setAge(36);
        individual.setBankBalance(99.25f);
        individual.setFavouriteRadioStations(new Vector<Double>(Arrays.asList(97.4, 105.4, 98.2)));
        this.session.save((Object)individual);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ArraysMappingTest.getGraphDatabaseService(), (String)"CREATE (:Individual {name:'Gary', age:36, bankBalance:99.25, code:0, favouriteRadioStations:[97.4, 105.4, 98.2]})");
    }
}

