/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.domain.filesystem.Folder;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class DegenerateEntityModelTests
extends MultiDriverTestClass {
    private Session session;
    private Folder f;
    private Document a;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.filesystem"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        Result executionResult = DegenerateEntityModelTests.getGraphDatabaseService().execute("CREATE (f:Folder { name: 'f' } )CREATE (a:Document { name: 'a' } ) CREATE (b:Document { name: 'b' } ) CREATE (f)-[:CONTAINS]->(a) CREATE (f)-[:CONTAINS]->(b) RETURN id(f) AS fid, id(a) AS aid, id(b) AS bid");
        Map resultSet = executionResult.next();
        this.a = (Document)this.session.load(Document.class, (Serializable)((Long)resultSet.get("aid")));
        Document b = (Document)this.session.load(Document.class, (Serializable)((Long)resultSet.get("bid")));
        this.f = (Folder)this.session.load(Folder.class, (Serializable)((Long)resultSet.get("fid")));
    }

    @Test
    public void testSaveDegenerateDocument() {
        this.a.setFolder(null);
        this.session.save((Object)this.a);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)DegenerateEntityModelTests.getGraphDatabaseService(), (String)"CREATE (f:Folder {name : 'f' } )CREATE (a:Document { name: 'a' } ) CREATE (b:Document { name: 'b' } ) CREATE (f)-[:CONTAINS]->(b)");
    }

    @Test
    public void testSaveDegenerateFolder() {
        this.f.setDocuments(new HashSet<Document>());
        this.session.save((Object)this.f);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)DegenerateEntityModelTests.getGraphDatabaseService(), (String)"CREATE (f:Folder { name: 'f' } )CREATE (a:Document { name: 'a' } ) CREATE (b:Document { name: 'b' } ) ");
    }

    @Test
    public void testSaveDegenerateDocumentClone() {
        Document clone = new Document();
        clone.setId(this.a.getId());
        clone.setName(this.a.getName());
        clone.setFolder(null);
        this.session.save((Object)clone);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)DegenerateEntityModelTests.getGraphDatabaseService(), (String)"CREATE (f:Folder { name: 'f' } )CREATE (a:Document { name: 'a'} ) CREATE (b:Document { name: 'b'} ) CREATE (f)-[:CONTAINS]->(b)");
    }

    @Test
    public void testSaveDegenerateFolderClone() {
        Folder clone = new Folder();
        clone.setId(this.f.getId());
        clone.setName(this.f.getName());
        clone.setDocuments(new HashSet<Document>());
        this.session.save((Object)clone);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)DegenerateEntityModelTests.getGraphDatabaseService(), (String)"CREATE (f:Folder { name: 'f' } )CREATE (a:Document { name: 'a' } ) CREATE (b:Document { name: 'b' } ) ");
    }

    @Test
    public void testSaveChangedDocument() {
        this.a.setFolder(new Folder());
        this.a.getFolder().setName("g");
        this.session.save((Object)this.a);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)DegenerateEntityModelTests.getGraphDatabaseService(), (String)"CREATE (f:Folder { name: 'f' } )CREATE (g:Folder { name: 'g' } ) CREATE (a:Document { name: 'a' }) CREATE (b:Document { name: 'b' }) CREATE (f)-[:CONTAINS]->(b) CREATE (g)-[:CONTAINS]->(a) ");
    }

    @Test
    public void testSaveChangedFolder() {
        Document c = new Document();
        c.setName("c");
        this.f.getDocuments().add(c);
        this.f.getDocuments().remove(this.a);
        this.session.save((Object)this.f);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)DegenerateEntityModelTests.getGraphDatabaseService(), (String)"CREATE (f:Folder { name: 'f' })CREATE (a:Document { name: 'a' } ) CREATE (b:Document { name: 'b' } ) CREATE (c:Document { name: 'c' } ) CREATE (f)-[:CONTAINS]->(b) CREATE (f)-[:CONTAINS]->(c) ");
    }
}

