/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.generic_hierarchy.relationship.GenericRelationship;
import org.neo4j.ogm.domain.generic_hierarchy.relationship.SourceEntityWithEntityInterface;
import org.neo4j.ogm.domain.generic_hierarchy.relationship.SourceEntityWithEntitySuperInterface;
import org.neo4j.ogm.domain.generic_hierarchy.relationship.TargetEntityWithEntityInterface;
import org.neo4j.ogm.domain.generic_hierarchy.relationship.TargetEntityWithEntitySuperInterface;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class GenericRelationshipEntityTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        this.session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.generic_hierarchy.relationship"}).openSession();
        this.session.purgeDatabase();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
        this.session.clear();
    }

    @Test
    public void loadEntitySuperInterfaceToEntitySuperInterfaceRelationship() {
        this.createSuperInterfaceToSuperInterfaceRelationship();
        SourceEntityWithEntitySuperInterface source = (SourceEntityWithEntitySuperInterface)this.session.loadAll(SourceEntityWithEntitySuperInterface.class).iterator().next();
        Assertions.assertThat(source.relationship).isNotNull();
        Assertions.assertThat(source.relationship.target).isNotNull();
    }

    @Test
    public void loadEntitySuperInterfaceToEntityInterfaceRelationship() {
        this.createSuperInterfaceToInterfaceRelationship();
        SourceEntityWithEntitySuperInterface source = (SourceEntityWithEntitySuperInterface)this.session.loadAll(SourceEntityWithEntitySuperInterface.class).iterator().next();
        Assertions.assertThat(source.relationship).isNotNull();
        Assertions.assertThat(source.relationship.target).isNotNull();
    }

    @Test
    public void loadEntityInterfaceToEntitySuperInterfaceRelationship() {
        this.createInterfaceToSuperInterfaceRelationship();
        SourceEntityWithEntityInterface source = (SourceEntityWithEntityInterface)this.session.loadAll(SourceEntityWithEntityInterface.class).iterator().next();
        Assertions.assertThat(source.relationship).isNotNull();
        Assertions.assertThat(source.relationship.target).isNotNull();
    }

    @Test
    public void loadEntityInterfaceToEntityInterfaceRelationship() {
        this.createInterfaceToInterfaceRelationship();
        SourceEntityWithEntityInterface source = (SourceEntityWithEntityInterface)this.session.loadAll(SourceEntityWithEntityInterface.class).iterator().next();
        Assertions.assertThat(source.relationship).isNotNull();
        Assertions.assertThat(source.relationship.target).isNotNull();
    }

    private void createSuperInterfaceToSuperInterfaceRelationship() {
        SourceEntityWithEntitySuperInterface source = new SourceEntityWithEntitySuperInterface();
        GenericRelationship relationship = new GenericRelationship();
        relationship.source = source;
        relationship.target = new TargetEntityWithEntitySuperInterface();
        source.relationship = relationship;
        this.session.save((Object)source);
        this.session.clear();
    }

    private void createSuperInterfaceToInterfaceRelationship() {
        SourceEntityWithEntitySuperInterface source = new SourceEntityWithEntitySuperInterface();
        GenericRelationship relationship = new GenericRelationship();
        relationship.source = source;
        relationship.target = new TargetEntityWithEntityInterface();
        source.relationship = relationship;
        this.session.save((Object)source);
        this.session.clear();
    }

    private void createInterfaceToSuperInterfaceRelationship() {
        SourceEntityWithEntityInterface source = new SourceEntityWithEntityInterface();
        GenericRelationship relationship = new GenericRelationship();
        relationship.source = source;
        relationship.target = new TargetEntityWithEntitySuperInterface();
        source.relationship = relationship;
        this.session.save((Object)source);
        this.session.clear();
    }

    private void createInterfaceToInterfaceRelationship() {
        SourceEntityWithEntityInterface source = new SourceEntityWithEntityInterface();
        GenericRelationship relationship = new GenericRelationship();
        relationship.source = source;
        relationship.target = new TargetEntityWithEntityInterface();
        source.relationship = relationship;
        this.session.save((Object)source);
        this.session.clear();
    }
}

