/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ListAssert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.gh670.Course;
import org.neo4j.ogm.domain.gh670.Klassenclown;
import org.neo4j.ogm.domain.gh670.Person;
import org.neo4j.ogm.domain.gh670.Teacher;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class InheritedRelationshipsQueryTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private static Long idOfCreatedTeacher;

    @BeforeClass
    public static void setUpTestDatabase() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.gh670"});
        Session session = sessionFactory.openSession();
        Teacher teacher = new Teacher();
        teacher.setName("Edna Krabappel");
        Course course = new Course();
        course.setTitle("Math");
        Klassenclown bart = new Klassenclown();
        bart.setName("Bart Simpson");
        course.setTakenBy(Collections.singletonList(bart));
        teacher.getCources().add(course);
        session.save((Object)teacher);
        Iterable results = (Iterable)session.query("MATCH (t:Teacher) WHERE t.name = $name RETURN id(t) as id", Collections.singletonMap("name", teacher.getName())).queryResults();
        ((IterableAssert)Assertions.assertThat((Iterable)results).hasSize(1)).allSatisfy(row -> Assertions.assertThat((Map)row).containsKeys((Object[])new String[]{"id"}));
        idOfCreatedTeacher = (Long)((Map)results.iterator().next()).get("id");
    }

    @Test
    public void shouldReturnConcreteClassWithRelationships() {
        Session session = sessionFactory.openSession();
        Collection persons = session.loadAll(Person.class, 1);
        ((IterableAssert)Assertions.assertThat((Iterable)persons).hasSize(2)).allSatisfy(p -> {
            List<Object> courses;
            if (p instanceof Teacher) {
                Teacher t = (Teacher)p;
                courses = t.getCources();
            } else if (p instanceof Klassenclown) {
                Klassenclown c = (Klassenclown)p;
                courses = c.getCoursesTaken();
            } else {
                courses = Collections.emptyList();
            }
            ((ListAssert)Assertions.assertThat(courses).hasSize(1)).extracting(Course::getTitle).contains((Object[])new String[]{"Math"});
        });
    }
}

