/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.ogm.config.AutoIndexMode;
import org.neo4j.ogm.domain.generic_hierarchy.AnotherEntity;
import org.neo4j.ogm.domain.generic_hierarchy.ChildA;
import org.neo4j.ogm.domain.generic_hierarchy.ChildB;
import org.neo4j.ogm.domain.generic_hierarchy.ChildC;
import org.neo4j.ogm.domain.generic_hierarchy.Entity;
import org.neo4j.ogm.domain.generic_hierarchy.EntityWithImplicitPlusAdditionalLabels;
import org.neo4j.ogm.domain.gh619.model.RealNode;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.utils.EntityUtils;

public class LabelDeterminationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void setupSessionFactory() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.generic_hierarchy"});
    }

    @Before
    public void setUp() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldNotSaveEntityLabelAndMustRetrieveChildA() {
        ChildA a = new ChildA();
        a.setValue("ChildA");
        this.session.save((Object)a);
        this.session.clear();
        Assertions.assertThat((Iterable)this.session.loadAll(Entity.class)).isEmpty();
        Assertions.assertThat((Object)this.session.load(Entity.class, (Serializable)((Object)a.getUuid()))).isNull();
        ChildA dbA = (ChildA)this.session.load(ChildA.class, (Serializable)((Object)a.getUuid()));
        Assertions.assertThat((Object)dbA).isNotNull();
        Assertions.assertThat((String)dbA.getValue()).isEqualTo((Object)"ChildA");
    }

    @Test
    public void shouldNotSaveEntityLabelAndMustRetrieveChildAChildren() {
        ChildA a = new ChildA();
        ChildB b1 = new ChildB();
        ChildB b2 = new ChildB();
        ChildC c1 = new ChildC();
        a.add(b1);
        a.add(b2);
        a.add(c1);
        this.session.save((Object)a);
        this.session.clear();
        Assertions.assertThat((Iterable)this.session.loadAll(Entity.class)).isEmpty();
        Assertions.assertThat((Iterable)this.session.loadAll(AnotherEntity.class)).isEmpty();
        a.getChildren().forEach(c -> Assertions.assertThat((Object)this.session.load(AnotherEntity.class, (Serializable)((Object)c.getUuid()))).isNull());
        Set<AnotherEntity> children = ((ChildA)this.session.load(ChildA.class, (Serializable)((Object)a.getUuid()))).getChildren();
        Assertions.assertThat(children).contains((Object[])new AnotherEntity[]{b1, b2, c1});
    }

    @Test
    public void indexesShouldBeCreatedForLoadableClassesInHierarchy() {
        Object[] expectedIndexes = new IndexDescription[]{new IndexDescription("DefaultUser", "id"), new IndexDescription("Admin", "id"), new IndexDescription("ChildA", "uuid"), new IndexDescription("ChildB", "uuid"), new IndexDescription("ChildC", "uuid"), new IndexDescription("LabeledEntity", "uuid"), new IndexDescription("EntityWithImplicitPlusAdditionalLabels", "id")};
        sessionFactory.runAutoIndexManager(LabelDeterminationTest.getBaseConfiguration().autoIndex(AutoIndexMode.UPDATE.name()).build());
        GraphDatabaseService service = LabelDeterminationTest.getGraphDatabaseService();
        try (Transaction tx = service.beginTx();){
            Object[] indexes = (IndexDescription[])StreamSupport.stream(service.schema().getIndexes().spliterator(), false).map(IndexDescription::new).toArray(IndexDescription[]::new);
            Assertions.assertThat((Object[])indexes).containsExactlyInAnyOrder(expectedIndexes);
            tx.success();
        }
    }

    @Test
    public void shouldUpdateLabelWhenLoadingEntityInSameSession() {
        ChildA a = new ChildA();
        a.addLabel("A0");
        this.session.save((Object)a);
        this.session.clear();
        ChildA dbA = (ChildA)this.session.load(ChildA.class, (Serializable)((Object)a.getUuid()));
        Assertions.assertThat((int)dbA.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbA.getLabels()).contains((Object[])new String[]{"A0"});
        dbA.removeLabel("A0");
        dbA.addLabel("A1");
        this.session.save((Object)dbA);
        this.session.clear();
        dbA = (ChildA)this.session.load(ChildA.class, (Serializable)((Object)a.getUuid()));
        Assertions.assertThat((int)dbA.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbA.getLabels()).contains((Object[])new String[]{"A1"});
    }

    @Test
    public void shouldUpdateLabelWhenLoadingEntityInNewSession() {
        ChildA a = new ChildA();
        a.addLabel("A0");
        this.session.save((Object)a);
        Session newSession = sessionFactory.openSession();
        ChildA dbA = (ChildA)newSession.load(ChildA.class, (Serializable)((Object)a.getUuid()));
        Assertions.assertThat((int)dbA.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbA.getLabels()).contains((Object[])new String[]{"A0"});
        dbA.removeLabel("A0");
        dbA.addLabel("A1");
        newSession.save((Object)dbA);
        newSession.clear();
        dbA = (ChildA)newSession.load(ChildA.class, (Serializable)((Object)a.getUuid()));
        Assertions.assertThat((int)dbA.getLabels().size()).isEqualTo(1);
        Assertions.assertThat(dbA.getLabels()).contains((Object[])new String[]{"A1"});
    }

    @Test
    public void labelsShouldBeDeleted() {
        Session throwAwaySession = sessionFactory.openSession();
        throwAwaySession.query("CREATE (a:EntityWithImplicitPlusAdditionalLabels:Label1:Label2 {id: 'myId'}) RETURN a", Collections.emptyMap());
        throwAwaySession.clear();
        throwAwaySession = sessionFactory.openSession();
        EntityWithImplicitPlusAdditionalLabels entity = (EntityWithImplicitPlusAdditionalLabels)this.session.load(EntityWithImplicitPlusAdditionalLabels.class, (Serializable)((Object)"myId"));
        Assertions.assertThat(entity.getLabels()).containsExactlyInAnyOrder((Object[])new String[]{"Label1", "Label2"});
        entity.getLabels().remove("Label1");
        throwAwaySession.save((Object)entity);
        throwAwaySession.clear();
        throwAwaySession = sessionFactory.openSession();
        entity = (EntityWithImplicitPlusAdditionalLabels)this.session.load(EntityWithImplicitPlusAdditionalLabels.class, (Serializable)((Object)"myId"));
        Assertions.assertThat(entity.getLabels()).containsExactlyInAnyOrder((Object[])new String[]{"Label2"});
    }

    @Test
    public void metaDataFromParentPackageShouldWork() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh619"});
        Collection labels = EntityUtils.labels((Object)new RealNode(), (MetaData)metaData);
        ((IterableAssert)Assertions.assertThat((Iterable)labels).hasSize(1)).containsExactly((Object[])new String[]{"real"});
    }

    @Test
    public void metaDataWithExplicitPackagesShouldWork() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh619.base", "org.neo4j.ogm.domain.gh619.model"});
        Collection labels = EntityUtils.labels((Object)new RealNode(), (MetaData)metaData);
        ((IterableAssert)Assertions.assertThat((Iterable)labels).hasSize(1)).containsExactly((Object[])new String[]{"real"});
    }

    @Test
    public void metaDataWithImplicitParentPackageShouldWork() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.gh619.model"});
        Collection labels = EntityUtils.labels((Object)new RealNode(), (MetaData)metaData);
        Assertions.assertThat((Iterable)labels).hasSize(1).containsExactly(new Object[]{"real"});
    }

    static class IndexDescription {
        final String label;
        final String[] propertyKeys;

        public IndexDescription(String label, String ... propertyKeys) {
            this.label = label;
            this.propertyKeys = propertyKeys;
        }

        public IndexDescription(IndexDefinition indexDefinition) {
            this.label = indexDefinition.getLabel().name();
            this.propertyKeys = (String[])StreamSupport.stream(indexDefinition.getPropertyKeys().spliterator(), false).toArray(String[]::new);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IndexDescription)) {
                return false;
            }
            IndexDescription that = (IndexDescription)o;
            return Objects.equals(this.label, that.label) && Arrays.equals(this.propertyKeys, that.propertyKeys);
        }

        public int hashCode() {
            int result = Objects.hash(this.label);
            result = 31 * result + Arrays.hashCode(this.propertyKeys);
            return result;
        }

        public String toString() {
            return "IndexDescription{label='" + this.label + '\'' + ", propertyKeys=" + Arrays.toString(this.propertyKeys) + '}';
        }
    }
}

