/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.domain.canonical.hierarchies.A;
import org.neo4j.ogm.domain.canonical.hierarchies.B;
import org.neo4j.ogm.domain.canonical.hierarchies.CR;
import org.neo4j.ogm.domain.cineasts.annotated.Actor;
import org.neo4j.ogm.domain.cineasts.annotated.Movie;
import org.neo4j.ogm.domain.cineasts.annotated.Role;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipEntityMappingTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.annotated", "org.neo4j.ogm.domain.canonical.hierarchies"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void testThatAnnotatedRelationshipOnRelationshipEntityCreatesTheCorrectRelationshipTypeInTheGraph() {
        Movie hp = new Movie("Goblet of Fire", 2005);
        Actor daniel = new Actor("Daniel Radcliffe");
        daniel.playedIn(hp, "Harry Potter");
        this.session.save((Object)daniel);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipEntityMappingTest.getGraphDatabaseService(), (String)("MERGE (m:Movie {uuid:\"" + hp.getUuid().toString() + "\"}) SET m.title = 'Goblet of Fire', m.year = 2005 MERGE (a:Actor {uuid:\"" + daniel.getUuid().toString() + "\"}) SET a.name='Daniel Radcliffe' create (a)-[:ACTS_IN {role:'Harry Potter'}]->(m)"));
    }

    @Test
    public void testThatRelationshipEntityNameIsUsedAsRelationshipTypeWhenTypeIsNotDefined() {
        Movie hp = new Movie("Goblet of Fire", 2005);
        Actor daniel = new Actor("Daniel Radcliffe");
        daniel.nominatedFor(hp, "Saturn Award", 2005);
        this.session.save((Object)daniel);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipEntityMappingTest.getGraphDatabaseService(), (String)("MERGE (m:Movie {uuid:\"" + hp.getUuid().toString() + "\"}) SET m.title = 'Goblet of Fire', m.year = 2005 MERGE (a:Actor {uuid:\"" + daniel.getUuid().toString() + "\"}) SET a.name='Daniel Radcliffe' create (a)-[:NOMINATIONS {name:'Saturn Award', year:2005}]->(m)"));
    }

    @Test
    public void shouldUseCorrectTypeFromHierarchyOfRelationshipEntities() {
        A a = new A();
        B b = new B();
        CR r = new CR();
        r.setA(a);
        r.setB(b);
        a.setR(r);
        this.session.save((Object)a);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipEntityMappingTest.getGraphDatabaseService(), (String)"CREATE (a:A) CREATE (b:B) CREATE (a)-[:CR]->(b)");
    }

    @Test
    public void shouldBeAbleToSaveAndLoadRelationshipEntityWithNullProperties() {
        Actor keanu = new Actor("Keanu Reeves");
        Movie matrix = new Movie("The Matrix", 1999);
        HashSet<Role> roles = new HashSet<Role>();
        Role role = new Role(matrix, keanu, null);
        roles.add(role);
        keanu.setRoles(roles);
        this.session.save((Object)keanu);
        HashMap<String, Long> params = new HashMap<String, Long>();
        params.put("actorId", keanu.getId());
        Result result = this.session.query("MATCH (a:Actor)-[r:ACTS_IN]-(m:Movie) WHERE ID(a) = {actorId} RETURN r as rel", params, true);
        Iterator iterator = result.iterator();
        Map first = (Map)iterator.next();
        Assert.assertSame((Object)role, first.get("rel"));
    }
}

