/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.domain.cineasts.minimum.Actor;
import org.neo4j.ogm.domain.cineasts.minimum.Movie;
import org.neo4j.ogm.domain.cineasts.minimum.Role;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipEntityPartialMappingTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetup() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.minimum"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void testCreateActorRoleAndMovie() {
        Actor keanu = new Actor("Keanu Reeves");
        Movie matrix = new Movie("The Matrix");
        keanu.addRole("Neo", matrix);
        this.session.save((Object)keanu);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipEntityPartialMappingTest.getGraphDatabaseService(), (String)"create (a:Actor {name:'Keanu Reeves'}) create (m:Movie {name:'The Matrix'}) create (a)-[:ACTS_IN {played:'Neo'}]->(m)");
    }

    @Test
    public void shouldNotDropUnmappedRelationshipModels() {
        Session session = sessionFactory.openSession();
        Actor actor = new Actor("A1");
        Movie movie = new Movie("M1");
        Role role = new Role("R1", actor, movie);
        session.save((Object)role);
        session = sessionFactory.openSession();
        Iterable results = (Iterable)session.query("MATCH (m) - [r] - (a) WHERE id(a) = $id RETURN r", Collections.singletonMap("id", actor.getId())).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Map row = (Map)results.iterator().next();
        Assertions.assertThat((Map)row).containsKeys((Object[])new String[]{"r"});
        ((AbstractObjectAssert)Assertions.assertThat(row.get("r")).isNotNull()).isInstanceOf(RelationshipModel.class);
    }

    @Test
    public void shouldMapSingleRelationshipModel() {
        Session session = sessionFactory.openSession();
        Actor actor = new Actor("A1");
        Movie movie = new Movie("M1");
        Role role = new Role("R1", actor, movie);
        session.save((Object)role);
        session = sessionFactory.openSession();
        Iterable results = (Iterable)session.query("MATCH (m) - [r] - (a) WHERE id(a) = $id RETURN m, r, a", Collections.singletonMap("id", actor.getId())).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Map row = (Map)results.iterator().next();
        Assertions.assertThat((Map)row).containsKeys((Object[])new String[]{"r"});
        ((AbstractObjectAssert)Assertions.assertThat(row.get("r")).isNotNull()).isInstanceOf(Role.class);
    }
}

