/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.domain.election.Candidate;
import org.neo4j.ogm.domain.election.Voter;
import org.neo4j.ogm.domain.gh640.MyNode;
import org.neo4j.ogm.domain.gh640.MyNodeWithAssignedId;
import org.neo4j.ogm.domain.gh641.Entity1;
import org.neo4j.ogm.domain.gh641.MyRelationship;
import org.neo4j.ogm.domain.gh656.Group;
import org.neo4j.ogm.domain.gh656.GroupVersion;
import org.neo4j.ogm.domain.gh666.MessedUpNode1;
import org.neo4j.ogm.domain.gh666.MessedUpNode2;
import org.neo4j.ogm.domain.gh666.MessedUpNode3;
import org.neo4j.ogm.domain.gh704.Country;
import org.neo4j.ogm.domain.gh704.CountryRevision;
import org.neo4j.ogm.domain.gh737.Gh737Node1;
import org.neo4j.ogm.domain.gh737.Gh737Node2;
import org.neo4j.ogm.domain.policy.Person;
import org.neo4j.ogm.domain.policy.Policy;
import org.neo4j.ogm.domain.typed_relationships.SomeEntity;
import org.neo4j.ogm.domain.typed_relationships.TypedEntity;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipMappingTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetup() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.policy", "org.neo4j.ogm.domain.election", "org.neo4j.ogm.domain.gh640", "org.neo4j.ogm.domain.gh641", "org.neo4j.ogm.domain.typed_relationships", "org.neo4j.ogm.domain.gh656", "org.neo4j.ogm.domain.gh666", "org.neo4j.ogm.domain.gh704", "org.neo4j.ogm.domain.gh737"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void testThatABiDirectionalMappingIsEstablishedWhenAMutualRelationshipWithNoAnnotationsIsSaved() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.getInfluencers().add(jim);
        jim.getInfluenced().add(policy);
        this.session.save((Object)policy);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})-[:INFLUENCERS]->(m:Person:DomainObject {name:'Jim'})-[:INFLUENCED]->(n)");
    }

    @Test
    public void testThatAnAnnotatedRelationshipOnTwoObjectsThatIsSavedFromTheOutgoingCreatesTheCorrectRelationshipInTheGraph() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        jim.getWritten().add(policy);
        this.session.save((Object)jim);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:WRITES_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void testThatAnAnnotatedRelationshipSavedFromTheIncomingSideCreatesTheCorrectRelationshipInTheGraph() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.getWriters().add(jim);
        this.session.save((Object)policy);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:WRITES_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void testPersistAnnotatedSingleRelationshipMappingBothDomainObjectsParticipating() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.getWriters().add(jim);
        jim.getWritten().add(policy);
        this.session.save((Object)policy);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:WRITES_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void testAnnotatedRelationshipTypeWhenMethodsAreJsonIgnored() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.setAuthorized(jim);
        jim.setAuthorized(policy);
        this.session.save((Object)jim);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:AUTHORIZED_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void shouldAllowVoterToChangeHerMind() {
        Result executionResult = RelationshipMappingTest.getGraphDatabaseService().execute("CREATE (a:Voter:Candidate {name:'A'}), (b:Voter:Candidate {name:'B'}), (v:Voter {name:'V'})-[:CANDIDATE_VOTED_FOR]->(b) RETURN id(a) AS a_id, id(b) AS b_id, id(v) AS v_id");
        Map results = executionResult.next();
        Long aid = (Long)results.get("a_id");
        Long bid = (Long)results.get("b_id");
        Long vid = (Long)results.get("v_id");
        Candidate a = (Candidate)this.session.load(Candidate.class, (Serializable)aid);
        Candidate b = (Candidate)this.session.load(Candidate.class, (Serializable)bid);
        Voter v = (Voter)this.session.load(Voter.class, (Serializable)vid);
        v.candidateVotedFor = a;
        this.session.save((Object)v);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (a:Voter:Candidate {name:'A'}) CREATE (b:Voter:Candidate {name:'B'}) CREATE (v:Voter {name:'V'})-[:CANDIDATE_VOTED_FOR]->(a)");
    }

    @Test
    public void shouldDealWithTheSameButNotEqualParentEntities() {
        Session tx = sessionFactory.openSession();
        Map result = (Map)tx.query("CREATE (n1:MyNode {name: 'node1'})\nCREATE (n2:MyNode {name: 'node2'})\nCREATE (n3:MyNode {name: 'node3'})\nCREATE (n1) - [:REL_TWO] -> (n2)\nCREATE (n2) - [:REL_ONE] -> (n1)\nRETURN id(n1) as idOfn1, id(n2) as idOfn2, id(n3) as idOfn3", Collections.emptyMap()).iterator().next();
        tx = sessionFactory.openSession();
        MyNode node1 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn1")));
        MyNode node2 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn2")));
        MyNode node3 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn3")));
        Assertions.assertThat((Object)node1).isNotNull();
        Assertions.assertThat((Object)node2).isNotNull();
        Assertions.assertThat((Object)node3).isNotNull();
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node2);
        Assertions.assertThat(node1.getRefTwo()).containsOnly((Object[])new MyNode[]{node2});
        tx = sessionFactory.openSession();
        MyNode changed = ((MyNode)tx.load(MyNode.class, (Serializable)node1.getId())).copy();
        changed.setName("Dirty thing.");
        changed.setRefOne(node3);
        tx.save((Object)changed);
        tx = sessionFactory.openSession();
        node1 = (MyNode)tx.load(MyNode.class, (Serializable)changed.getId());
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node3);
        Assertions.assertThat(node1.getRefTwo()).containsOnly((Object[])new MyNode[]{node2});
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n1:MyNode {name: 'Dirty thing.'})\nCREATE (n2:MyNode {name: 'node2'})\nCREATE (n3:MyNode {name: 'node3'})\nCREATE (n1) - [:REL_TWO] -> (n2)\nCREATE (n3) - [:REL_ONE] -> (n1)");
    }

    @Test
    public void shouldDealWithTheSameButNotEqualParentEntitiesWithAssignedId() {
        Session tx = sessionFactory.openSession();
        tx.query("CREATE (n1:MyNodeWithAssignedId {name: 'node1'})\nCREATE (n2:MyNodeWithAssignedId {name: 'node2'})\nCREATE (n3:MyNodeWithAssignedId {name: 'node3'})\nCREATE (n1) - [:REL_TWO] -> (n2)\nCREATE (n2) - [:REL_ONE] -> (n1)\nRETURN id(n1) as idOfn1, id(n2) as idOfn2, id(n3) as idOfn3", Collections.emptyMap()).iterator().next();
        tx = sessionFactory.openSession();
        MyNodeWithAssignedId node1 = (MyNodeWithAssignedId)tx.load(MyNodeWithAssignedId.class, (Serializable)((Object)"node1"));
        MyNodeWithAssignedId node2 = (MyNodeWithAssignedId)tx.load(MyNodeWithAssignedId.class, (Serializable)((Object)"node2"));
        MyNodeWithAssignedId node3 = (MyNodeWithAssignedId)tx.load(MyNodeWithAssignedId.class, (Serializable)((Object)"node3"));
        Assertions.assertThat((Object)node1).isNotNull();
        Assertions.assertThat((Object)node2).isNotNull();
        Assertions.assertThat((Object)node3).isNotNull();
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node2);
        Assertions.assertThat(node1.getRefTwo()).containsOnly((Object[])new MyNodeWithAssignedId[]{node2});
        tx = sessionFactory.openSession();
        MyNodeWithAssignedId changed = ((MyNodeWithAssignedId)tx.load(MyNodeWithAssignedId.class, (Serializable)((Object)node1.getName()))).copy();
        changed.setRefOne(node3);
        tx.save((Object)changed);
        tx = sessionFactory.openSession();
        node1 = (MyNodeWithAssignedId)tx.load(MyNodeWithAssignedId.class, (Serializable)((Object)changed.getName()));
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node3);
        Assertions.assertThat(node1.getRefTwo()).containsOnly((Object[])new MyNodeWithAssignedId[]{node2});
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n1:MyNodeWithAssignedId {name: 'node1'})\nCREATE (n2:MyNodeWithAssignedId {name: 'node2'})\nCREATE (n3:MyNodeWithAssignedId {name: 'node3'})\nCREATE (n1) - [:REL_TWO] -> (n2)\nCREATE (n3) - [:REL_ONE] -> (n1)");
    }

    @Test
    public void shouldKeepOrderOfRelatedElements() {
        this.session.query("CREATE (e1:Entity1)\nCREATE (e2:Entity2)\nCREATE (e3:Entity2)\nCREATE (e4:Entity2)\nCREATE (e1) - [:MY_RELATIONSHIP {ordering: 1}] -> (e3)\nCREATE (e1) - [:MY_RELATIONSHIP {ordering: 2}] -> (e4)\nCREATE (e1) - [:MY_RELATIONSHIP {ordering: 3}] -> (e2)\nRETURN *", Collections.emptyMap());
        this.session.clear();
        Entity1 entity1 = (Entity1)this.session.queryForObject(Entity1.class, "MATCH (e1:Entity1)-[r:MY_RELATIONSHIP]->(e2:Entity2)\nRETURN e1, r, e2\nORDER BY r.ordering", Collections.emptyMap());
        Assertions.assertThat(entity1.getEntries()).extracting(MyRelationship::getOrdering).containsExactly((Object[])new Integer[]{1, 2, 3});
    }

    @Test
    public void shouldDealWithTypedRelationships() {
        SomeEntity someEntity = new SomeEntity();
        someEntity.setThing(new TypedEntity<Double>(42.21));
        someEntity.setMoreThings(Arrays.asList(new TypedEntity<String>("Die halbe Wahrheit"), new TypedEntity<String>("21")));
        someEntity.setSomeOtherStuff(Arrays.asList("A", "B", "C"));
        this.session.save((Object)someEntity);
        this.session.clear();
        someEntity = (SomeEntity)this.session.load(SomeEntity.class, (Serializable)someEntity.getId());
        Assertions.assertThat(someEntity.getThing().getSomeThing()).isEqualTo((Object)42.21);
        Assertions.assertThat(someEntity.getMoreThings()).extracting(t -> (String)t.getSomeThing()).containsExactlyInAnyOrder((Object[])new String[]{"Die halbe Wahrheit", "21"});
        Assertions.assertThat(someEntity.getSomeOtherStuff()).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "C"});
    }

    @Test
    public void genericRelationshipsInParentClassesShouldWork() {
        Group group = new Group();
        GroupVersion groupVersion = new GroupVersion();
        group.setVersions(Collections.singleton(groupVersion));
        sessionFactory.openSession().save((Object)group);
        group = (Group)sessionFactory.openSession().load(Group.class, (Serializable)((Object)group.getUuid()));
        Assertions.assertThat((Iterable)group.getVersions()).hasSize(1);
    }

    @Test
    public void generic1To1RelationshipsShouldWork() {
        Country oldRev = new Country();
        oldRev.setName("oldCountry");
        sessionFactory.openSession().save((Object)oldRev);
        Session session = sessionFactory.openSession();
        oldRev = (Country)session.load(Country.class, (Serializable)((Object)oldRev.getId()));
        Assertions.assertThat(oldRev.getPreviousRevision()).isNull();
        Country newRev = new Country();
        newRev.setName("newCountry");
        newRev.setPreviousRevision(oldRev);
        session.save((Object)newRev);
        newRev = (Country)sessionFactory.openSession().load(Country.class, (Serializable)((Object)newRev.getId()));
        Assertions.assertThat(newRev.getPreviousRevision()).isNotNull();
        Assertions.assertThat((String)((CountryRevision)newRev.getPreviousRevision()).getName()).isEqualTo((Object)"oldCountry");
        Assertions.assertThat(newRev.getPreviousRevision()).isEqualTo((Object)oldRev);
    }

    @Test
    public void deletesOfEntitiesWithTheSameButNotEqualParentShouldWork() {
        Session tx = sessionFactory.openSession();
        Map result = (Map)tx.query("CREATE (n1:MyNode {name: 'node1'})\nCREATE (n2:MyNode {name: 'node2'})\nCREATE (n3:MyNode {name: 'node3'})\nCREATE (n1) - [:REL_TWO] -> (n2)\nCREATE (n2) - [:REL_ONE] -> (n1)\nRETURN id(n1) as idOfn1, id(n2) as idOfn2, id(n3) as idOfn3", Collections.emptyMap()).iterator().next();
        tx = sessionFactory.openSession();
        MyNode node1 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn1")));
        MyNode node2 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn2")));
        MyNode node3 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn3")));
        Assertions.assertThat((Object)node1).isNotNull();
        Assertions.assertThat((Object)node2).isNotNull();
        Assertions.assertThat((Object)node3).isNotNull();
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node2);
        Assertions.assertThat(node1.getRefTwo()).containsOnly((Object[])new MyNode[]{node2});
        Assertions.assertThat(node2.getRefTwo()).containsOnly((Object[])new MyNode[]{node1});
        tx = sessionFactory.openSession();
        MyNode changed = ((MyNode)tx.load(MyNode.class, (Serializable)node1.getId())).copy();
        changed.setName("Dirty thing.");
        changed.setRefTwo(Collections.emptyList());
        tx.save((Object)changed);
        tx = sessionFactory.openSession();
        node1 = (MyNode)tx.load(MyNode.class, (Serializable)changed.getId());
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node2);
        Assertions.assertThat(node1.getRefTwo()).isEmpty();
        Iterable actual = (Iterable)sessionFactory.openSession().query(" MATCH (n1:MyNode {name: 'Dirty thing.'}),       (n2:MyNode {name: 'node2'}),       (n3:MyNode {name: 'node3'}),       (n2) - [:REL_ONE] -> (n1)  RETURN n1,n2,n3,exists((n1) - [:REL_TWO] -> (n2)) as relTwo", Collections.emptyMap()).queryResults();
        Assertions.assertThat((Iterable)actual).hasSize(1);
        Assertions.assertThat((Map)((Map)actual.iterator().next())).containsEntry((Object)"relTwo", (Object)false);
    }

    @Test
    public void deletesOfEntitiesWithTheSameButNotEqualParentShouldWork2() {
        Session tx = sessionFactory.openSession();
        Map result = (Map)tx.query("CREATE (n1:MyNode {name: 'node1'})\nCREATE (n2:MyNode {name: 'node2'})\nCREATE (n3:MyNode {name: 'node3'})\nCREATE (n1) - [:REL_TWO] -> (n2)\nCREATE (n2) - [:REL_ONE] -> (n1)\nRETURN id(n1) as idOfn1, id(n2) as idOfn2, id(n3) as idOfn3", Collections.emptyMap()).iterator().next();
        tx = sessionFactory.openSession();
        MyNode node1 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn1")));
        MyNode node2 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn2")));
        MyNode node3 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn3")));
        Assertions.assertThat((Object)node1).isNotNull();
        Assertions.assertThat((Object)node2).isNotNull();
        Assertions.assertThat((Object)node3).isNotNull();
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node2);
        Assertions.assertThat(node1.getRefTwo()).containsOnly((Object[])new MyNode[]{node2});
        Assertions.assertThat((Object)node2.getRefOne()).isNull();
        Assertions.assertThat(node2.getRefTwo()).containsOnly((Object[])new MyNode[]{node1});
        tx = sessionFactory.openSession();
        MyNode changed = ((MyNode)tx.load(MyNode.class, (Serializable)node2.getId())).copy();
        changed.setName("Dirty thing.");
        changed.setRefTwo(Collections.emptyList());
        tx.save((Object)changed);
        tx = sessionFactory.openSession();
        node2 = (MyNode)tx.load(MyNode.class, (Serializable)changed.getId());
        Assertions.assertThat((Object)node2.getRefOne()).isNull();
        Assertions.assertThat(node2.getRefTwo()).isEmpty();
        Iterable actual = (Iterable)sessionFactory.openSession().query(" MATCH (n1:MyNode {name: 'node1'}),       (n2:MyNode {name: 'Dirty thing.'}),       (n3:MyNode {name: 'node3'}),       (n2) - [:REL_ONE] -> (n1)  RETURN n1,n2,n3,exists((n1) - [:REL_TWO] -> (n2)) as relTwo", Collections.emptyMap()).queryResults();
        Assertions.assertThat((Iterable)actual).hasSize(1);
        Assertions.assertThat((Map)((Map)actual.iterator().next())).containsEntry((Object)"relTwo", (Object)false);
    }

    @Test
    public void deletesOfEntitiesWithTheSameButNotEqualParentShouldWork3() {
        Session tx = sessionFactory.openSession();
        Map result = (Map)tx.query("CREATE (n1:MyNode {name: 'node1'})\nCREATE (n2:MyNode {name: 'node2'})\nCREATE (n3:MyNode {name: 'node3'})\nCREATE (n2) - [:REL_ONE] -> (n1)\nRETURN id(n1) as idOfn1, id(n2) as idOfn2, id(n3) as idOfn3", Collections.emptyMap()).iterator().next();
        tx = sessionFactory.openSession();
        MyNode node1 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn1")));
        MyNode node2 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn2")));
        MyNode node3 = (MyNode)tx.load(MyNode.class, (Serializable)((Long)result.get("idOfn3")));
        Assertions.assertThat((Object)node1).isNotNull();
        Assertions.assertThat((Object)node2).isNotNull();
        Assertions.assertThat((Object)node3).isNotNull();
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node2);
        Assertions.assertThat(node1.getRefTwo()).isEmpty();
        Assertions.assertThat(node2.getRefTwo()).isEmpty();
        tx = sessionFactory.openSession();
        MyNode changed = ((MyNode)tx.load(MyNode.class, (Serializable)node1.getId())).copy();
        changed.setName("Dirty thing.");
        changed.setRefTwo(Collections.singletonList(node2));
        tx.save((Object)changed);
        tx = sessionFactory.openSession();
        node1 = (MyNode)tx.load(MyNode.class, (Serializable)changed.getId());
        node2 = (MyNode)tx.load(MyNode.class, (Serializable)node2.getId());
        Assertions.assertThat((Object)node1.getRefOne()).isEqualTo((Object)node2);
        Assertions.assertThat(node1.getRefTwo()).containsOnly((Object[])new MyNode[]{node2});
        Assertions.assertThat(node2.getRefTwo()).containsOnly((Object[])new MyNode[]{node1});
        Iterable actual = (Iterable)sessionFactory.openSession().query(" MATCH (n1:MyNode {name: 'Dirty thing.'}),       (n2:MyNode {name: 'node2'}),       (n3:MyNode {name: 'node3'}),       (n2) - [:REL_ONE] -> (n1)  RETURN n1,n2,n3,exists((n1) - [:REL_TWO] - (n2)) as relTwo", Collections.emptyMap()).queryResults();
        Assertions.assertThat((Iterable)actual).hasSize(1);
        Assertions.assertThat((Map)((Map)actual.iterator().next())).containsEntry((Object)"relTwo", (Object)true);
    }

    @Test
    public void shouldNotDropUnmappedRelationshipModels() {
        Session session = sessionFactory.openSession();
        Voter voter = new Voter("V");
        voter.candidateVotedFor = new Candidate("C");
        session.save((Object)voter);
        session = sessionFactory.openSession();
        Iterable results = (Iterable)session.query("MATCH (v) - [r] - (c) WHERE id(v) = $id RETURN r", Collections.singletonMap("id", voter.getId())).queryResults();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Map row = (Map)results.iterator().next();
        Assertions.assertThat((Map)row).containsKeys((Object[])new String[]{"r"});
        ((AbstractObjectAssert)Assertions.assertThat(row.get("r")).isNotNull()).isInstanceOf(RelationshipModel.class);
    }

    @Test
    public void patternComprehensionShouldBeMappedToCorrectRelationships() {
        Map ids = (Map)((Iterable)sessionFactory.openSession().query("CREATE (n1:Gh737Node1) - [:RELATION_A] -> (n2:Gh737Node2) RETURN id(n1) AS idn1, id(n2) AS idn2", Collections.emptyMap()).queryResults()).iterator().next();
        Session session = sessionFactory.openSession();
        Gh737Node1 node1 = (Gh737Node1)session.load(Gh737Node1.class, (Serializable)((Long)ids.get("idn1")));
        Gh737Node2 node2 = (Gh737Node2)session.load(Gh737Node2.class, (Serializable)((Long)ids.get("idn2")));
        Assertions.assertThat((Object)node1).isNotNull();
        Assertions.assertThat((Object)node2).isNotNull();
        Assertions.assertThat((Object)node1.getRef()).isEqualTo((Object)node2);
        String query = "MATCH (n:Gh737Node1) RETURN n, [(n)-[rn:RELATION_A]-(n2) | [rn, n2]]";
        session = sessionFactory.openSession();
        node1 = (Gh737Node1)session.queryForObject(Gh737Node1.class, query, Collections.emptyMap());
        Assertions.assertThat((Object)node1).isNotNull();
        Assertions.assertThat((Object)node1.getRef()).isNotNull();
        session = sessionFactory.openSession();
        org.neo4j.ogm.model.Result result = session.query(query, Collections.emptyMap(), true);
        Assertions.assertThat((boolean)result.iterator().hasNext()).isTrue();
        result.forEach(m -> {
            Gh737Node1 n = (Gh737Node1)m.get("n");
            Assertions.assertThat((Object)n).isNotNull();
            Assertions.assertThat((Object)n.getRef()).isNotNull();
        });
    }

    @Test
    public void shouldNotMessUpNodes() {
        this.assertMapping(MessedUpNode1.class, node -> node.getRef(), false);
    }

    @Test
    public void mayMessUpNodes() {
        this.assertMapping(MessedUpNode3.class, node -> node.getRef(), true);
    }

    private <T> void assertMapping(Class<T> targetClass, Function<T, MessedUpNode2> refExtractor, boolean wildCardMappingAllowed) {
        ClassInfo targetclassInfo = sessionFactory.metaData().classInfo(targetClass);
        Map ids = (Map)((Iterable)sessionFactory.openSession().query("MERGE (n3:MessedUpNode2:TypeY) <-[:RELATION_A] - (n1:" + targetclassInfo.neo4jName() + ")-[:RELATION_NOT_MODELED]->(n2:MessedUpNode2:TypeX) RETURN id(n1) as id1, id(n2) as id2, id(n3) as id3", Collections.emptyMap()).queryResults()).iterator().next();
        Session session = sessionFactory.openSession();
        Object n1 = session.load(targetClass, (Serializable)((Long)ids.get("id1")));
        MessedUpNode2 n2 = (MessedUpNode2)session.load(MessedUpNode2.class, (Serializable)((Long)ids.get("id2")));
        MessedUpNode2 n3 = (MessedUpNode2)session.load(MessedUpNode2.class, (Serializable)((Long)ids.get("id3")));
        Assertions.assertThat((Object)n1).isNotNull();
        Assertions.assertThat((Object)n2).isNotNull();
        Assertions.assertThat((Object)n3).isNotNull();
        Assertions.assertThat((Object)refExtractor.apply(n1)).isEqualTo((Object)n3);
        String query = "MATCH (n1:" + targetclassInfo.neo4jName() + ")-[rel:RELATION_NOT_MODELED]->(n2:`TypeX`) WHERE id(n1) = $id1 RETURN n1, rel, n2";
        Iterable r = (Iterable)session.query(query, Collections.singletonMap("id1", Long.valueOf((Long)ids.get("id1"))), true).queryResults();
        RelationshipMappingTest.assertCorrectRelationShip(r, wildCardMappingAllowed ? n2 : n3);
        session = sessionFactory.openSession();
        r = (Iterable)session.query(query, Collections.singletonMap("id1", Long.valueOf((Long)ids.get("id1"))), true).queryResults();
        RelationshipMappingTest.assertCorrectRelationShip(r, wildCardMappingAllowed ? n2 : null);
    }

    private static void assertCorrectRelationShip(Iterable<Map<String, Object>> result, MessedUpNode2 expectedNode) {
        Assertions.assertThat(result).hasSize(1);
        Assertions.assertThat(result).allSatisfy(row -> {
            Assertions.assertThat((Map)row).containsKeys((Object[])new String[]{"n1"});
            if (expectedNode != null) {
                Assertions.assertThat(row.get("n1")).extracting(new String[]{"ref"}).extracting("id").containsExactly(new Object[]{expectedNode.getId()});
            } else {
                Assertions.assertThat(row.get("n1")).extracting(new String[]{"ref"}).hasSize(1).containsNull();
            }
        });
    }
}

