/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.mappings.Category;
import org.neo4j.ogm.domain.mappings.Event;
import org.neo4j.ogm.domain.mappings.Tag;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class DualTargetEntityRelationshipTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        this.session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.mappings"}).openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void mappingShouldConsiderClasses() {
        Category category = new Category("cat1");
        Tag tag1 = new Tag("tag1");
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.add(tag1);
        Event event = new Event("title");
        event.setCategory(category);
        event.setTags(tags);
        this.session.save((Object)event);
        Assertions.assertThat((Long)event.getNodeId()).isNotNull();
        Assertions.assertThat((Long)event.getCategory().getNodeId()).isNotNull();
        Assertions.assertThat((Long)event.getTags().iterator().next().getNodeId()).isNotNull();
        this.session.clear();
        event = (Event)this.session.load(Event.class, (Serializable)event.getNodeId(), 1);
        Assertions.assertThat((Object)event).isNotNull();
        Assertions.assertThat((Object)event.getCategory()).isEqualTo((Object)category);
        Assertions.assertThat((Object)event.getTags().iterator().next()).isEqualTo((Object)tag1);
    }

    @Test
    public void shouldKeepAllRelations() {
        Category category = new Category("cat1");
        Tag tag1 = new Tag("tag1");
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.add(tag1);
        Event event = new Event("title");
        event.setCategory(category);
        event.setTags(tags);
        this.session.save((Object)event);
        Assertions.assertThat((Long)event.getNodeId()).isNotNull();
        Assertions.assertThat((Long)category.getNodeId()).isNotNull();
        Assertions.assertThat((Long)tag1.getNodeId()).isNotNull();
        this.session.clear();
        Collection tagsFound = this.session.loadAll(Tag.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"tag1"));
        Assertions.assertThat((Iterable)tagsFound).hasSize(1);
        event.setTags(new HashSet<Tag>(tagsFound));
        Collection categoriesFound = this.session.loadAll(Category.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"cat1"));
        Assertions.assertThat((Iterable)categoriesFound).hasSize(1);
        event.setCategory((Category)categoriesFound.iterator().next());
        Assertions.assertThat((Object)event.getTags().iterator().next()).isEqualTo((Object)tag1);
        Assertions.assertThat((Object)event.getCategory()).isEqualTo((Object)category);
        this.session.save((Object)event);
        this.session.clear();
        Event eventFound = (Event)this.session.load(Event.class, (Serializable)event.getNodeId(), 1);
        Assertions.assertThat((Long)eventFound.getNodeId()).isNotNull();
        Assertions.assertThat((Object)eventFound.getCategory()).isEqualTo((Object)category);
        Assertions.assertThat((Object)eventFound.getTags().iterator().next()).isEqualTo((Object)tag1);
    }
}

