/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.ogm.domain.mappings.Article;
import org.neo4j.ogm.domain.mappings.Person;
import org.neo4j.ogm.domain.mappings.RichRelation;
import org.neo4j.ogm.domain.mappings.Tag;
import org.neo4j.ogm.domain.versioned_rel.Service;
import org.neo4j.ogm.domain.versioned_rel.Template;
import org.neo4j.ogm.domain.versioned_rel.UsedBy;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.testutil.RepeatRule;

public class RichRelationTest
extends MultiDriverTestClass {
    @Rule
    public RepeatRule repeatRule = new RepeatRule();
    private Session session;

    @BeforeClass
    public static void prepareSessionFactory() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.mappings", "org.neo4j.ogm.domain.versioned_rel"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    @RepeatRule.Repeat(times=20)
    public void versionedRelationshipsTargetingDifferentEndNodes() {
        Session localSession = sessionFactory.openSession();
        Service serviceA = new Service();
        serviceA.setName("A service");
        Service serviceB = new Service();
        serviceB.setName("B service");
        Template template = new Template();
        template.setName("A template");
        UsedBy userAUsingA = new UsedBy();
        userAUsingA.setUser("A user");
        userAUsingA.setService(serviceA);
        userAUsingA.setTemplate(template);
        UsedBy userBUsingA = new UsedBy();
        userBUsingA.setUser("B user");
        userBUsingA.setService(serviceA);
        userBUsingA.setTemplate(template);
        UsedBy userBUsingB = new UsedBy();
        userBUsingB.setUser("B user");
        userBUsingB.setService(serviceB);
        userBUsingB.setTemplate(template);
        template.setUsedBy(new HashSet<UsedBy>(Arrays.asList(userAUsingA, userBUsingA, userBUsingB)));
        serviceA.setUsedBy(userAUsingA);
        localSession.save((Object)template);
        Template loaded = null;
        loaded = new Template();
        loaded.setName("new name");
        loaded.setId(template.getId());
        loaded.setUuid(template.getUuid());
        loaded.setOptlock(template.getOptlock());
        loaded.set_identifier(template.get_identifier());
        loaded.setRef(template.getRef());
        localSession.save((Object)loaded);
    }

    @Test
    public void shouldCreateARichRelation() {
        Person person = new Person();
        this.session.save((Object)person);
        Article article1 = new Article();
        this.session.save((Object)article1);
        Article article2 = new Article();
        this.session.save((Object)article2);
        RichRelation relation1 = new RichRelation();
        person.addRelation(article1, relation1);
        this.session.save((Object)person, 1);
        this.session.clear();
        RichRelation relation2 = new RichRelation();
        person.addRelation(article2, relation2);
        this.session.save((Object)person, 1);
    }

    @Test
    public void shouldUpdateEndNodeEntityWithoutException() {
        Person person = new Person();
        this.session.save((Object)person);
        Article article1 = new Article();
        Tag tag1 = new Tag("tag1");
        article1.tags = Collections.singletonList(tag1);
        this.session.save((Object)article1);
        RichRelation relation1 = new RichRelation();
        person.addRelation(article1, relation1);
        this.session.save((Object)person, 1);
        Article updateArticle = (Article)this.session.load(Article.class, (Serializable)article1.getNodeId(), 1);
        Assertions.assertThat((Object)((RichRelation)updateArticle.relations.toArray()[0]).article).isSameAs((Object)updateArticle);
        updateArticle.tags = Collections.singletonList(new Tag("tag2"));
        this.session.save((Object)updateArticle, 1);
        updateArticle = (Article)this.session.load(Article.class, (Serializable)article1.getNodeId(), 1);
        Assertions.assertThat((Object)((RichRelation)updateArticle.relations.toArray()[0]).article).isSameAs((Object)updateArticle);
        this.session.save((Object)updateArticle, 1);
    }

    @Test
    public void shouldSaveRelationshipEntityWhenNoReferencesToRelationshipEntityOnEitherStartOrEndNode() {
        RichRelation relation = new RichRelation();
        Person person = new Person();
        Article article = new Article();
        relation.person = person;
        relation.article = article;
        this.session.save((Object)relation);
        Assertions.assertThat((Long)person.getNodeId()).isNotNull();
        Assertions.assertThat((Long)article.getNodeId()).isNotNull();
        this.session.clear();
        Person savedPerson = (Person)this.session.load(Person.class, (Serializable)person.getNodeId());
        Article savedArticle = (Article)this.session.load(Article.class, (Serializable)article.getNodeId());
        Assertions.assertThat((Object)savedPerson).isNotNull();
        Assertions.assertThat((Object)savedArticle).isNotNull();
    }

    @Test
    public void shouldSaveRelationshipEntityWhenReferenceToRelationshipEntityOnStartNodeOnly() {
        RichRelation relation = new RichRelation();
        Person person = new Person();
        Article article = new Article();
        relation.person = person;
        relation.article = article;
        person.relations.add(relation);
        this.session.save((Object)relation);
        Assertions.assertThat((Long)person.getNodeId()).isNotNull();
        Assertions.assertThat((Long)article.getNodeId()).isNotNull();
        this.session.clear();
        Person savedPerson = (Person)this.session.load(Person.class, (Serializable)person.getNodeId());
        Article savedArticle = (Article)this.session.load(Article.class, (Serializable)article.getNodeId());
        Assertions.assertThat((Object)savedPerson).isNotNull();
        Assertions.assertThat((Object)savedArticle).isNotNull();
    }

    @Test
    public void shouldSaveRelationshipEntityWhenReferenceToRelationshipEntityOnEndNodeOnly() {
        RichRelation relation = new RichRelation();
        Person person = new Person();
        Article article = new Article();
        relation.person = person;
        relation.article = article;
        article.relations.add(relation);
        this.session.save((Object)relation);
        Assertions.assertThat((Long)person.getNodeId()).isNotNull();
        Assertions.assertThat((Long)article.getNodeId()).isNotNull();
        this.session.clear();
        Person savedPerson = (Person)this.session.load(Person.class, (Serializable)person.getNodeId());
        Article savedArticle = (Article)this.session.load(Article.class, (Serializable)article.getNodeId());
        Assertions.assertThat((Object)savedPerson).isNotNull();
        Assertions.assertThat((Object)savedArticle).isNotNull();
    }
}

