/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships.direct.abb;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ABBTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    private A a;
    private B b1;
    private B b2;

    @BeforeClass
    public static void oneTimeSetup() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.relationships.direct.abb"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        this.setUpEntityModel();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
    }

    private void setUpEntityModel() {
        this.a = new A();
        this.b1 = new B();
        this.b2 = new B();
        this.a.b = new B[]{this.b1, this.b2};
        this.b1.a = this.a;
        this.b2.a = this.a;
    }

    @Test
    public void shouldFindAFromB() {
        this.session.save((Object)this.a);
        this.b1 = (B)this.session.load(B.class, (Serializable)this.b1.id);
        this.b2 = (B)this.session.load(B.class, (Serializable)this.b2.id);
        Assertions.assertThat((Object)this.b1.a).isEqualTo((Object)this.a);
        Assertions.assertThat((Object)this.b2.a).isEqualTo((Object)this.a);
    }

    @Test
    public void shouldFindBFromA() {
        this.session.save((Object)this.b1);
        this.session.save((Object)this.b2);
        this.a = (A)this.session.load(A.class, (Serializable)this.a.id);
        Assertions.assertThat((Object[])this.a.b).containsExactlyInAnyOrder((Object[])new B[]{this.b1, this.b2});
    }

    @Test
    public void shouldReflectRemovalA() {
        this.session.save((Object)this.a);
        this.b1.a = null;
        this.a.b = new B[]{this.b2};
        this.session.save((Object)this.b1);
        this.session.save((Object)this.b2);
        this.a = (A)this.session.load(A.class, (Serializable)this.a.id);
        Assertions.assertThat((Object[])this.a.b).containsExactlyInAnyOrder((Object[])new B[]{this.b2});
    }

    @Test
    public void shouldBeAbleToAddAnotherB() {
        this.session.save((Object)this.a);
        B b3 = new B();
        b3.a = this.a;
        this.a.b = new B[]{this.b1, this.b2, b3};
        this.session.save((Object)b3);
        this.a = (A)this.session.load(A.class, (Serializable)this.a.id);
        Assertions.assertThat((Object[])this.a.b).containsExactlyInAnyOrder((Object[])new B[]{this.b1, this.b2, b3});
    }

    public static abstract class E {
        public Long id;
        public String key = UUID.randomUUID().toString();

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.id + ":" + this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.key.equals(((E)o).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    @NodeEntity(label="B")
    public static class B
    extends E {
        @Relationship(type="EDGE", direction="INCOMING")
        A a;
    }

    @NodeEntity(label="A")
    public static class A
    extends E {
        @Relationship(type="EDGE", direction="OUTGOING")
        B[] b;
    }
}

