/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships.transitive.aabb;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class AABBTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    private A a1;
    private A a2;
    private A a3;
    private B b1;
    private B b2;
    private B b3;
    private R r1;
    private R r2;
    private R r3;
    private R r4;
    private R r5;
    private R r6;

    @BeforeClass
    public static void oneTimeSetup() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.relationships.transitive.aabb"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.setUpEntityModel();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
    }

    private void setUpEntityModel() {
        this.a1 = new A();
        this.a2 = new A();
        this.a3 = new A();
        this.b1 = new B();
        this.b2 = new B();
        this.b3 = new B();
        this.r1 = new R(this.a1, this.b1);
        this.r2 = new R(this.a1, this.b2);
        this.r3 = new R(this.a2, this.b1);
        this.r4 = new R(this.a2, this.b3);
        this.r5 = new R(this.a3, this.b2);
        this.r6 = new R(this.a3, this.b3);
        this.a1.r = new R[]{this.r1, this.r2};
        this.a2.r = new R[]{this.r3, this.r4};
        this.a3.r = new R[]{this.r5, this.r6};
        this.b1.r = new R[]{this.r1, this.r3};
        this.b2.r = new R[]{this.r2, this.r5};
        this.b3.r = new R[]{this.r4, this.r6};
    }

    @Test
    public void shouldFindBFromA() {
        this.session.save((Object)this.b1);
        this.a1 = (A)this.session.load(A.class, (Serializable)this.a1.id);
        this.a2 = (A)this.session.load(A.class, (Serializable)this.a2.id);
        this.a3 = (A)this.session.load(A.class, (Serializable)this.a3.id);
        Assertions.assertThat((Object[])this.a1.r).extracting(x -> x.b).containsExactlyInAnyOrder((Object[])new B[]{this.b1, this.b2});
        Assertions.assertThat((Object[])this.a2.r).extracting(x -> x.b).containsExactlyInAnyOrder((Object[])new B[]{this.b1, this.b3});
        Assertions.assertThat((Object[])this.a3.r).extracting(x -> x.b).containsExactlyInAnyOrder((Object[])new B[]{this.b2, this.b3});
    }

    @Test
    public void shouldFindAFromB() {
        this.session.save((Object)this.a1);
        this.b1 = (B)this.session.load(B.class, (Serializable)this.b1.id);
        this.b2 = (B)this.session.load(B.class, (Serializable)this.b2.id);
        this.b3 = (B)this.session.load(B.class, (Serializable)this.b3.id);
        Assertions.assertThat((int)this.b1.r.length).isEqualTo(2);
        Assertions.assertThat((int)this.b2.r.length).isEqualTo(2);
        Assertions.assertThat((int)this.b3.r.length).isEqualTo(2);
        Assertions.assertThat((Object[])this.b1.r).extracting(b -> b.a).containsExactlyInAnyOrder((Object[])new A[]{this.a1, this.a2});
        Assertions.assertThat((Object[])this.b2.r).extracting(b -> b.a).containsExactlyInAnyOrder((Object[])new A[]{this.a1, this.a3});
        Assertions.assertThat((Object[])this.b3.r).extracting(b -> b.a).containsExactlyInAnyOrder((Object[])new A[]{this.a2, this.a3});
    }

    @Test
    public void shouldReflectRemovalA() {
        this.session.save((Object)this.a1);
        this.b2.r = null;
        this.a1.r = new R[]{this.r1};
        this.a3.r = new R[]{this.r6};
        this.session.save((Object)this.b2);
        this.a1 = (A)this.session.load(A.class, (Serializable)this.a1.id);
        Assertions.assertThat((int)this.a1.r.length).isEqualTo(1);
        Assertions.assertThat((Object)this.a1.r[0].b).isEqualTo((Object)this.b1);
        this.a3 = (A)this.session.load(A.class, (Serializable)this.a3.id);
        Assertions.assertThat((Object)this.a3.r[0].b).isEqualTo((Object)this.b3);
        this.a2 = (A)this.session.load(A.class, (Serializable)this.a2.id);
        Assertions.assertThat((Object[])this.a2.r).extracting(x -> x.b).containsExactlyInAnyOrder((Object[])new B[]{this.b1, this.b3});
    }

    @Test
    @Ignore
    public void shouldHandleAddNewRelationshipBetweenASingleABPair() {
        this.session.save((Object)this.a1);
        R r7 = new R(this.a1, this.b1);
        this.a1.r = new R[]{this.r2, r7};
        this.b1.r = new R[]{this.r3, r7};
        this.session.save((Object)this.a1);
        this.b1 = (B)this.session.load(B.class, (Serializable)this.b1.id);
        Assertions.assertThat((Object[])this.b1.r).containsExactlyInAnyOrder((Object[])new R[]{this.r1, this.r3, r7});
        Assertions.assertThat((Object[])this.a1.r).containsExactlyInAnyOrder((Object[])new R[]{this.r1, this.r2, r7});
    }

    @Test
    public void shouldSaveRelationsForA1InTheCorrectDirection() {
        this.session.save((Object)this.a1);
        this.session.clear();
        this.a1 = (A)this.session.load(A.class, (Serializable)this.a1.id);
        Assertions.assertThat((Object[])this.a1.r).containsExactlyInAnyOrder((Object[])new R[]{this.r1, this.r2});
    }

    @Test
    public void shouldSaveRelationsForA2TheCorrectDirection() {
        this.session.save((Object)this.a2);
        this.session.clear();
        this.a2 = (A)this.session.load(A.class, (Serializable)this.a2.id);
        Assertions.assertThat((Object[])this.a2.r).containsExactlyInAnyOrder((Object[])new R[]{this.r3, this.r4});
    }

    @Test
    public void shouldSaveRelationsForA3TheCorrectDirection() {
        this.session.save((Object)this.a3);
        this.session.clear();
        this.a3 = (A)this.session.load(A.class, (Serializable)this.a3.id);
        Assertions.assertThat((Object[])this.a3.r).containsExactlyInAnyOrder((Object[])new R[]{this.r5, this.r6});
    }

    @Test
    public void shouldSaveRelationsForB1TheCorrectDirection() {
        this.session.save((Object)this.b1);
        this.session.clear();
        this.b1 = (B)this.session.load(B.class, (Serializable)this.b1.id);
        Assertions.assertThat((Object[])this.b1.r).containsExactlyInAnyOrder((Object[])new R[]{this.r1, this.r3});
    }

    @Test
    public void shouldSaveRelationsForB2TheCorrectDirection() {
        this.session.save((Object)this.b2);
        this.session.clear();
        this.b2 = (B)this.session.load(B.class, (Serializable)this.b2.id);
        Assertions.assertThat((Object[])this.b2.r).containsExactlyInAnyOrder((Object[])new R[]{this.r2, this.r5});
    }

    @Test
    public void shouldSaveRelationsForB3TheCorrectDirection() {
        this.session.save((Object)this.b3);
        this.session.clear();
        this.b3 = (B)this.session.load(B.class, (Serializable)this.b3.id);
        Assertions.assertThat((Object[])this.b3.r).containsExactlyInAnyOrder((Object[])new R[]{this.r4, this.r6});
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingA() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = new R[]{r3};
        b3.r = new R[]{r3};
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)a1);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r[0].number).isEqualTo(2);
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingB() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = new R[]{r3};
        b3.r = new R[]{r3};
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)b3);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r[0].number).isEqualTo(2);
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingR() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = new R[]{r3};
        b3.r = new R[]{r3};
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)r3);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r[0].number).isEqualTo(2);
    }

    public static abstract class E {
        public Long id;
        public String key = UUID.randomUUID().toString();

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.id + ":" + this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.key.equals(((E)o).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    @RelationshipEntity(type="EDGE")
    public static class R
    extends E {
        @StartNode
        A a;
        @EndNode
        B b;
        int number;

        public R(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public R() {
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.a.id + "->" + this.b.id;
        }
    }

    @NodeEntity(label="B")
    public static class B
    extends E {
        @Relationship(type="EDGE", direction="INCOMING")
        R[] r;
    }

    @NodeEntity(label="A")
    public static class A
    extends E {
        @Relationship(type="EDGE", direction="OUTGOING")
        R[] r;
    }
}

