/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships.transitive.ab;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ABTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    private A a;
    private B b;
    private R r;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.relationships.transitive.ab"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.setUpEntityModel();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
    }

    private void setUpEntityModel() {
        this.a = new A();
        this.b = new B();
        this.r = new R();
        this.r.a = this.a;
        this.r.b = this.b;
        this.a.r = this.r;
        this.b.r = this.r;
    }

    @Test
    public void shouldFindBFromA() {
        this.session.save((Object)this.b);
        this.a = (A)this.session.load(A.class, (Serializable)this.a.id);
        Assertions.assertThat((Object)this.a.r.b).isEqualTo((Object)this.b);
    }

    @Test
    public void shouldFindAFromB() {
        this.session.save((Object)this.a);
        this.b = (B)this.session.load(B.class, (Serializable)this.b.id);
        Assertions.assertThat((Object)this.b.r.a).isEqualTo((Object)this.a);
    }

    @Test
    public void shouldReflectRemovalA() {
        this.session.save((Object)this.a);
        this.b.r = null;
        this.a.r = null;
        this.session.save((Object)this.b);
        this.a = (A)this.session.load(A.class, (Serializable)this.a.id);
        Assertions.assertThat((Object)this.a.r).isNull();
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingA() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = r3;
        b3.r = r3;
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)a1);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r.number).isEqualTo(2);
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingB() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = r3;
        b3.r = r3;
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)b3);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r.number).isEqualTo(2);
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingR() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = r3;
        b3.r = r3;
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)r3);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r.number).isEqualTo(2);
    }

    public static abstract class E {
        public Long id;
        public String key = UUID.randomUUID().toString();

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.id + ":" + this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.key.equals(((E)o).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    @RelationshipEntity(type="EDGE")
    public static class R {
        Long id;
        @StartNode
        A a;
        @EndNode
        B b;
        int number;

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.a.id + "->" + this.b.id;
        }
    }

    @NodeEntity(label="B")
    public static class B
    extends E {
        @Relationship(type="EDGE", direction="INCOMING")
        R r;
    }

    @NodeEntity(label="A")
    public static class A
    extends E {
        @Relationship(type="EDGE", direction="OUTGOING")
        R r;
    }
}

