/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.capability;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Recording;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class DeleteCapabilityTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldNotFailIfDeleteNodeEntityAgainstEmptyDatabase() {
        this.session.deleteAll(Album.class);
    }

    @Test
    public void shouldNotFailIfDeleteRelationshipEntityAgainstEmptyDatabase() {
        this.session.deleteAll(Recording.class);
    }

    @Test
    public void canDeleteSingleEntry() {
        Album album = new Album();
        this.session.save((Object)album);
        this.assertEntityCount(1);
        this.session.delete((Object)album);
        this.assertEntityCount(0);
    }

    @Test
    public void canDeleteEntityCollection() {
        Album album1 = new Album();
        Album album2 = new Album();
        this.session.save((Object)album1);
        this.session.save((Object)album2);
        this.assertEntityCount(2);
        ArrayList<Album> albumList = new ArrayList<Album>();
        albumList.add(album1);
        albumList.add(album2);
        this.session.delete(albumList);
        this.assertEntityCount(0);
    }

    @Test
    public void canDeleteEntityArray() {
        Album album1 = new Album();
        Album album2 = new Album();
        this.session.save((Object)album1);
        this.session.save((Object)album2);
        this.assertEntityCount(2);
        ArrayList<Album> albumList = new ArrayList<Album>();
        albumList.add(album1);
        albumList.add(album2);
        this.session.delete((Object)albumList.toArray());
        this.assertEntityCount(0);
    }

    private void assertEntityCount(int count) {
        this.session.clear();
        long entityCount = this.session.countEntitiesOfType(Album.class);
        Assertions.assertThat((long)entityCount).isEqualTo((long)count);
        this.session.clear();
    }
}

