/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.capability;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.domain.education.DomainObject;
import org.neo4j.ogm.domain.education.School;
import org.neo4j.ogm.domain.education.Student;
import org.neo4j.ogm.domain.gh368.User;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.music.Recording;
import org.neo4j.ogm.domain.music.Studio;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class LoadCapabilityTest
extends MultiDriverTestClass {
    private SessionFactory sessionFactory;
    private Session session;
    private Long pleaseId;
    private Long beatlesId;

    @Before
    public void init() throws IOException {
        this.sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music", "org.neo4j.ogm.domain.gh368"});
        this.session = this.sessionFactory.openSession();
        this.session.purgeDatabase();
        Artist theBeatles = new Artist("The Beatles");
        Album please = new Album("Please Please Me");
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        this.session.save((Object)theBeatles);
        this.pleaseId = please.getId();
        this.beatlesId = theBeatles.getId();
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void loadAllShouldRespectEntityType() {
        Collection artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId));
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        Collection albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId));
        Assertions.assertThat((Iterable)albums).isEmpty();
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), 0);
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId), 0);
        Assertions.assertThat((Iterable)albums).isEmpty();
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}));
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}));
        Assertions.assertThat((Iterable)albums).isEmpty();
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}), 0);
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}), 0);
        Assertions.assertThat((Iterable)albums).isEmpty();
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), new Pagination(0, 5));
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId), new Pagination(0, 5));
        Assertions.assertThat((Iterable)albums).isEmpty();
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), new Pagination(0, 5), 0);
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId), new Pagination(0, 5), 0);
        Assertions.assertThat((Iterable)albums).isEmpty();
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}), new Pagination(0, 5));
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}), new Pagination(0, 5));
        Assertions.assertThat((Iterable)albums).isEmpty();
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}), new Pagination(0, 5), 0);
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        Artist bonJovi = new Artist("Bon Jovi");
        this.session.save((Object)bonJovi);
        artists = this.session.loadAll(Artist.class, Arrays.asList(this.beatlesId, this.pleaseId, bonJovi.getId()), new SortOrder().add(new String[]{"name"}), new Pagination(0, 5), 0);
        Assertions.assertThat((Iterable)artists).hasSize(2);
        artists = this.session.loadAll(Artist.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}), new Pagination(0, 5), 0);
        Assertions.assertThat((Iterable)artists).hasSize(1);
        Assertions.assertThat((String)((Artist)artists.iterator().next()).getName()).isEqualTo((Object)"The Beatles");
        albums = this.session.loadAll(Album.class, Collections.singletonList(this.beatlesId), new SortOrder().add(new String[]{"name"}), new Pagination(0, 5), 0);
        Assertions.assertThat((Iterable)albums).isEmpty();
    }

    @Test
    public void loadOneShouldRespectEntityType() {
        Artist artist = (Artist)this.session.load(Artist.class, (Serializable)this.beatlesId);
        Assertions.assertThat((String)artist.getName()).isEqualTo((Object)"The Beatles");
        Album album = (Album)this.session.load(Album.class, (Serializable)this.beatlesId);
        Assertions.assertThat((Object)album).isNull();
        artist = (Artist)this.session.load(Artist.class, (Serializable)this.beatlesId, 0);
        Assertions.assertThat((String)artist.getName()).isEqualTo((Object)"The Beatles");
        album = (Album)this.session.load(Album.class, (Serializable)this.beatlesId, 0);
        Assertions.assertThat((Object)album).isNull();
        artist = (Artist)this.session.load(Artist.class, (Serializable)Long.valueOf(Long.MAX_VALUE));
        Assertions.assertThat((Object)artist).isNull();
    }

    @Test
    public void shouldBeAbleToLoadEntitiesToDifferentDepthsInDifferentSessions() {
        Artist pinkFloyd = new Artist("Pink Floyd");
        Album divisionBell = new Album("The Division Bell");
        divisionBell.setArtist(pinkFloyd);
        Studio studio = new Studio("Britannia Row Studios");
        Recording recording = new Recording(divisionBell, studio, 1994);
        divisionBell.setRecording(recording);
        pinkFloyd.addAlbum(divisionBell);
        this.session.save((Object)pinkFloyd);
        this.session.clear();
        Session session1 = this.sessionFactory.openSession();
        Artist pinkfloyd1 = (Artist)session1.load(Artist.class, (Serializable)pinkFloyd.getId(), 1);
        Assertions.assertThat((Object)pinkfloyd1).isNotNull();
        Assertions.assertThat(pinkfloyd1.getAlbums()).hasSize(1);
        Assertions.assertThat((Object)pinkfloyd1.getAlbums().iterator().next().getRecording()).isNull();
        Session session2 = this.sessionFactory.openSession();
        Artist pinkfloyd2 = (Artist)session2.load(Artist.class, (Serializable)pinkFloyd.getId(), -1);
        Assertions.assertThat((Object)pinkfloyd2).isNotNull();
        Assertions.assertThat(pinkfloyd2.getAlbums()).hasSize(1);
        Assertions.assertThat((Object)pinkfloyd2.getAlbums().iterator().next().getRecording()).isNotNull();
        Artist pinkfloyd_1_1 = (Artist)session1.load(Artist.class, (Serializable)pinkFloyd.getId(), -1);
        Assertions.assertThat((Object)pinkfloyd_1_1).isNotNull();
        Assertions.assertThat(pinkfloyd_1_1.getAlbums()).hasSize(1);
        Assertions.assertThat((Object)pinkfloyd2.getAlbums().iterator().next().getRecording()).isNotNull();
    }

    @Test
    public void shouldNotRefreshPropertiesOnEntityReload() {
        Artist pinkFloyd = new Artist("Pink Floyd");
        this.session.save((Object)pinkFloyd);
        this.session.clear();
        Session session1 = this.sessionFactory.openSession();
        Artist pinkfloyd1 = (Artist)session1.load(Artist.class, (Serializable)pinkFloyd.getId(), 1);
        Assertions.assertThat((Object)pinkfloyd1).isNotNull();
        Assertions.assertThat((String)pinkfloyd1.getName()).isEqualTo((Object)"Pink Floyd");
        Session session2 = this.sessionFactory.openSession();
        Artist pinkfloyd2 = (Artist)session2.load(Artist.class, (Serializable)pinkFloyd.getId(), -1);
        Assertions.assertThat((Object)pinkfloyd2).isNotNull();
        Assertions.assertThat((String)pinkfloyd2.getName()).isEqualTo((Object)"Pink Floyd");
        pinkfloyd2.setName("Purple Floyd");
        session2.save((Object)pinkfloyd2);
        Artist pinkfloyd_1_1 = (Artist)session1.load(Artist.class, (Serializable)pinkFloyd.getId(), -1);
        Assertions.assertThat((Object)pinkfloyd_1_1).isNotNull();
        Assertions.assertThat((String)pinkfloyd_1_1.getName()).isEqualTo((Object)"Pink Floyd");
    }

    @Test
    public void shouldNotBeDirtyOnLoadEntityThenSaveThenReload() {
        MappingContext context = ((Neo4jSession)this.session).context();
        Artist pinkFloyd = new Artist("Pink Floyd");
        Assertions.assertThat((boolean)context.isDirty((Object)pinkFloyd)).isTrue();
        this.session.save((Object)pinkFloyd);
        Assertions.assertThat((boolean)context.isDirty((Object)pinkFloyd)).isFalse();
        this.session.clear();
        pinkFloyd = (Artist)this.session.load(Artist.class, (Serializable)pinkFloyd.getId());
        Assertions.assertThat((boolean)context.isDirty((Object)pinkFloyd)).isFalse();
        pinkFloyd.setName("Purple Floyd");
        Assertions.assertThat((boolean)context.isDirty((Object)pinkFloyd)).isTrue();
        this.session.save((Object)pinkFloyd);
        Assertions.assertThat((boolean)context.isDirty((Object)pinkFloyd)).isFalse();
        Artist purpleFloyd = (Artist)this.session.load(Artist.class, (Serializable)pinkFloyd.getId());
        Assertions.assertThat((boolean)context.isDirty((Object)purpleFloyd)).isFalse();
        Assertions.assertThat((pinkFloyd == purpleFloyd ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldNotBeDirtyOnLoadRelationshipEntityThenSaveThenReload() {
        MappingContext context = ((Neo4jSession)this.session).context();
        Artist pinkFloyd = new Artist("Pink Floyd");
        Album divisionBell = new Album("The Division Bell");
        divisionBell.setArtist(pinkFloyd);
        Studio studio = new Studio("Britannia Row Studios");
        Recording recording = new Recording(divisionBell, studio, 1994);
        divisionBell.setRecording(recording);
        pinkFloyd.addAlbum(divisionBell);
        Assertions.assertThat((boolean)context.isDirty((Object)recording)).isTrue();
        this.session.save((Object)recording);
        Assertions.assertThat((boolean)context.isDirty((Object)recording)).isFalse();
        this.session.clear();
        recording = (Recording)this.session.load(Recording.class, (Serializable)recording.getId(), 2);
        Assertions.assertThat((boolean)context.isDirty((Object)recording)).isFalse();
        recording.setYear(1995);
        Assertions.assertThat((boolean)context.isDirty((Object)recording)).isTrue();
        this.session.save((Object)recording);
        Assertions.assertThat((boolean)context.isDirty((Object)recording)).isFalse();
        Recording recording1995 = (Recording)this.session.load(Recording.class, (Serializable)recording.getId(), 2);
        Assertions.assertThat((boolean)context.isDirty((Object)recording1995)).isFalse();
        Assertions.assertThat((recording == recording1995 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldRetainPreviouslyLoadedRelationshipsWhenDepthIsReduced() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 2);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNotNull();
        Assertions.assertThat((String)ledZeppelinIV.getRecording().getStudio().getName()).isEqualTo((Object)studio.getName());
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 0);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNotNull();
        Assertions.assertThat((String)ledZeppelinIV.getRecording().getStudio().getName()).isEqualTo((Object)studio.getName());
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 0);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNotNull();
        Assertions.assertThat((String)ledZeppelinIV.getRecording().getStudio().getName()).isEqualTo((Object)studio.getName());
    }

    @Test
    public void shouldAddRelationshipsWhenDepthIsIncreased() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 0);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).isEmpty();
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 1);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNull();
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 2);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNotNull();
        Assertions.assertThat((String)ledZeppelinIV.getRecording().getStudio().getName()).isEqualTo((Object)studio.getName());
    }

    @Test
    public void shouldNotModifyPreviouslyLoadedNodesWhenDepthIsIncreased() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 0);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).isEmpty();
        Session session2 = this.sessionFactory.openSession();
        Artist ledZepp = (Artist)session2.load(Artist.class, (Serializable)led.getId(), 0);
        ledZepp.setName("Led Zepp");
        session2.save((Object)ledZepp);
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 1);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNull();
    }

    @Test
    public void shouldNotModifyPreviouslyLoadedNodesWhenDepthIsReduced() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 1);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNull();
        Session session2 = this.sessionFactory.openSession();
        Artist ledZepp = (Artist)session2.load(Artist.class, (Serializable)led.getId(), 0);
        ledZepp.setName("Led Zepp");
        session2.save((Object)ledZepp);
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 0);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
    }

    @Test
    public void shouldBeAbleToLoadEntityToDifferentDepthsInDifferentSessions() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 2);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNotNull();
        Assertions.assertThat((String)ledZeppelinIV.getRecording().getStudio().getName()).isEqualTo((Object)studio.getName());
        Session session2 = this.sessionFactory.openSession();
        Artist ledZeppelin0 = (Artist)session2.load(Artist.class, (Serializable)led.getId(), 0);
        Assertions.assertThat((Object)ledZeppelin0).isNotNull();
        Assertions.assertThat((String)ledZeppelin0.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin0.getAlbums()).isEmpty();
    }

    @Test
    public void shouldNotModifyPreviouslyLoadedNodesWhenEntityIsReloaded() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 1);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNull();
        Session session2 = this.sessionFactory.openSession();
        Artist ledZepp = (Artist)session2.load(Artist.class, (Serializable)led.getId(), 0);
        ledZepp.setName("Led Zepp");
        session2.save((Object)ledZepp);
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 1);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNull();
    }

    @Test
    public void shouldMapNewNodesAndRelationshipsWhenEntityIsReloaded() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 2);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNotNull();
        Assertions.assertThat((String)ledZeppelinIV.getRecording().getStudio().getName()).isEqualTo((Object)studio.getName());
        Session session2 = this.sessionFactory.openSession();
        Artist ledZepp = (Artist)session2.load(Artist.class, (Serializable)led.getId());
        Album houses = new Album("Houses of the Holy");
        Studio studio2 = new Studio("Island Studios");
        Recording housesRec = new Recording(houses, studio2, 1972);
        ledZepp.addAlbum(houses);
        houses.setArtist(ledZepp);
        houses.setRecording(housesRec);
        session2.save((Object)ledZepp);
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 2);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(2);
        for (Album loadedAlbum : ledZeppelin.getAlbums()) {
            Assertions.assertThat((Object)loadedAlbum.getArtist()).isEqualTo((Object)ledZeppelin);
            Assertions.assertThat((Object)loadedAlbum.getRecording()).isNotNull();
            Assertions.assertThat((Object)loadedAlbum.getRecording().getStudio()).isNotNull();
        }
    }

    @Test
    public void shouldRefreshEntityStateWhenReloadedOnCleanSession() {
        Artist led = new Artist("Led Zeppelin");
        Album album = new Album("Led Zeppelin IV");
        Studio studio = new Studio("Island Studios");
        Recording recording = new Recording(album, studio, 1970);
        led.addAlbum(album);
        album.setArtist(led);
        album.setRecording(recording);
        this.session.save((Object)led);
        this.session.clear();
        Artist ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 1);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)led.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).hasSize(1);
        Album ledZeppelinIV = ledZeppelin.getAlbums().iterator().next();
        Assertions.assertThat((String)ledZeppelinIV.getName()).isEqualTo((Object)album.getName());
        Assertions.assertThat((Object)ledZeppelinIV.getArtist()).isEqualTo((Object)ledZeppelin);
        Assertions.assertThat((Object)ledZeppelinIV.getRecording()).isNull();
        Session session2 = this.sessionFactory.openSession();
        Artist ledZepp = (Artist)session2.load(Artist.class, (Serializable)led.getId(), 1);
        ledZepp.setName("Led Zepp");
        ledZepp.getAlbums().iterator().next().setArtist(null);
        ledZepp.getAlbums().clear();
        session2.save((Object)ledZepp);
        this.session.clear();
        ledZeppelin = (Artist)this.session.load(Artist.class, (Serializable)led.getId(), 1);
        Assertions.assertThat((Object)ledZeppelin).isNotNull();
        Assertions.assertThat((String)ledZeppelin.getName()).isEqualTo((Object)ledZepp.getName());
        Assertions.assertThat(ledZeppelin.getAlbums()).isEmpty();
    }

    @Test
    public void shouldMaintainSortOrderWhenLoadingByIds() {
        Artist led = new Artist("Led Zeppelin");
        this.session.save((Object)led);
        Artist bonJovi = new Artist("Bon Jovi");
        this.session.save((Object)bonJovi);
        List<Long> ids = Arrays.asList(this.beatlesId, led.getId(), bonJovi.getId());
        SortOrder sortOrder = new SortOrder();
        sortOrder.add(SortOrder.Direction.ASC, new String[]{"name"});
        Collection artists = this.session.loadAll(Artist.class, ids, sortOrder);
        Assertions.assertThat((Iterable)artists).isNotNull();
        ArrayList<String> artistNames = new ArrayList<String>();
        for (Artist artist : artists) {
            artistNames.add(artist.getName());
        }
        Assertions.assertThat((String)((String)artistNames.get(0))).isEqualTo((Object)"Bon Jovi");
        Assertions.assertThat((String)((String)artistNames.get(1))).isEqualTo((Object)"Led Zeppelin");
        Assertions.assertThat((String)((String)artistNames.get(2))).isEqualTo((Object)"The Beatles");
        sortOrder = new SortOrder();
        sortOrder.add(SortOrder.Direction.DESC, new String[]{"name"});
        artists = this.session.loadAll(Artist.class, ids, sortOrder);
        Assertions.assertThat((Iterable)artists).isNotNull();
        artistNames = new ArrayList();
        for (Artist artist : artists) {
            artistNames.add(artist.getName());
        }
        Assertions.assertThat((String)((String)artistNames.get(0))).isEqualTo((Object)"The Beatles");
        Assertions.assertThat((String)((String)artistNames.get(1))).isEqualTo((Object)"Led Zeppelin");
        Assertions.assertThat((String)((String)artistNames.get(2))).isEqualTo((Object)"Bon Jovi");
    }

    @Test
    public void loadAllByIdsShouldSortByIdsIfSortOrderIsNotProvided() throws Exception {
        Artist beatles = (Artist)this.session.load(Artist.class, (Serializable)this.beatlesId);
        Artist led = new Artist("Led Zeppelin");
        this.session.save((Object)led);
        Artist bonJovi = new Artist("Bon Jovi");
        this.session.save((Object)bonJovi);
        Long ledId = led.getId();
        Long bonJoviId = bonJovi.getId();
        Collection artists = this.session.loadAll(Artist.class, Arrays.asList(this.beatlesId, ledId, bonJoviId));
        Assertions.assertThat((Iterable)artists).containsExactly((Object[])new Artist[]{beatles, led, bonJovi});
        artists = this.session.loadAll(Artist.class, Arrays.asList(ledId, this.beatlesId, bonJoviId));
        Assertions.assertThat((Iterable)artists).containsExactly((Object[])new Artist[]{led, beatles, bonJovi});
        artists = this.session.loadAll(Artist.class, Arrays.asList(ledId, bonJoviId, this.beatlesId));
        Assertions.assertThat((Iterable)artists).containsExactly((Object[])new Artist[]{led, bonJovi, beatles});
    }

    @Test
    public void loadAllByInstancesShouldSortByIdsIfSortOrderIsNotProvided() throws Exception {
        Artist beatles = (Artist)this.session.load(Artist.class, (Serializable)this.beatlesId);
        Artist led = new Artist("Led Zeppelin");
        this.session.save((Object)led);
        Artist bonJovi = new Artist("Bon Jovi");
        this.session.save((Object)bonJovi);
        Long ledId = led.getId();
        Long bonJoviId = bonJovi.getId();
        Collection artists = this.session.loadAll(Arrays.asList(beatles, led, bonJovi));
        Assertions.assertThat((Iterable)artists).containsExactly((Object[])new Artist[]{beatles, led, bonJovi});
        artists = this.session.loadAll(Arrays.asList(led, beatles, bonJovi));
        Assertions.assertThat((Iterable)artists).containsExactly((Object[])new Artist[]{led, beatles, bonJovi});
        artists = this.session.loadAll(Arrays.asList(led, bonJovi, beatles));
        Assertions.assertThat((Iterable)artists).containsExactly((Object[])new Artist[]{led, bonJovi, beatles});
    }

    @Test
    public void loadAllByInstancesShouldLoadAllClasses() {
        SessionFactory sf = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.education"});
        Session session = sf.openSession();
        School school = new School();
        Student student = new Student();
        session.save((Object)school);
        session.save((Object)student);
        Collection loaded = session.loadAll(Arrays.asList(school, student));
        Assertions.assertThat((Iterable)loaded).contains((Object[])new DomainObject[]{school, student});
    }

    @Test
    public void shouldKeepOrder() {
        User anna = new User("noone@nowhere.com", "Anna", "Doe");
        User bob = new User("noone@nowhere.com", "Bob", "Doe");
        User charlie = new User("noone@nowhere.com", "Charlie", "Doe");
        this.session.save((Object)charlie);
        this.session.save((Object)anna);
        this.session.save((Object)bob);
        anna.setFriends(Collections.singleton(charlie));
        this.session.save((Object)anna);
        Collection allUsers = this.session.loadAll(User.class, new SortOrder().add(new String[]{"lastName"}).add(new String[]{"firstName"}), 1);
        Assertions.assertThat((Iterable)allUsers).extracting(User::getFirstName).containsExactly((Object[])new String[]{"Anna", "Bob", "Charlie"});
    }
}

