/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.capability;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.cypher.compiler.CompileContext;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.music.Recording;
import org.neo4j.ogm.domain.music.Studio;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SaveCapabilityTest
extends MultiDriverTestClass {
    private Session session;
    private Artist aerosmith;
    private Artist bonJovi;
    private Artist defLeppard;

    @Before
    public void init() throws IOException {
        SessionFactory sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music"});
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        this.aerosmith = new Artist("Aerosmith");
        this.bonJovi = new Artist("Bon Jovi");
        this.defLeppard = new Artist("Def Leppard");
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void saveCollectionShouldSaveLists() {
        Album nineLives = new Album("Nine Lives");
        this.aerosmith.addAlbum(nineLives);
        Album crossRoad = new Album("Cross Road");
        this.bonJovi.addAlbum(crossRoad);
        List<Artist> artists = Arrays.asList(this.aerosmith, this.bonJovi, this.defLeppard);
        this.session.save(artists);
        this.session.clear();
        Assertions.assertThat((long)this.session.countEntitiesOfType(Artist.class)).isEqualTo(3L);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Album.class)).isEqualTo(2L);
    }

    @Test
    public void saveCollectionShouldSaveSets() {
        HashSet<Artist> artists = new HashSet<Artist>();
        artists.add(this.aerosmith);
        artists.add(this.bonJovi);
        artists.add(this.defLeppard);
        this.session.save(artists);
        this.session.clear();
        Assertions.assertThat((long)this.session.countEntitiesOfType(Artist.class)).isEqualTo(3L);
    }

    @Test
    public void saveCollectionShouldSaveArrays() {
        Artist[] artists = new Artist[]{this.aerosmith, this.bonJovi, this.defLeppard};
        this.session.save((Object)artists);
        this.session.clear();
        Assertions.assertThat((long)this.session.countEntitiesOfType(Artist.class)).isEqualTo(3L);
    }

    @Test
    public void shouldSaveNewNodesAndNewRelationships() {
        Artist leann = new Artist("Leann Rimes");
        Album lost = new Album("Lost Highway");
        lost.setArtist(this.bonJovi);
        lost.setGuestArtist(leann);
        this.session.save((Object)lost);
        this.session.clear();
        Artist loadedLeann = (Artist)this.session.load(Artist.class, (Serializable)leann.getId());
        Assertions.assertThat((Object)loadedLeann).isNotNull();
        Assertions.assertThat((String)loadedLeann.getName()).isEqualTo((Object)"Leann Rimes");
        Assertions.assertThat((String)loadedLeann.getGuestAlbums().iterator().next().getName()).isEqualTo((Object)lost.getName());
        Artist loadedBonJovi = (Artist)this.session.load(Artist.class, (Serializable)this.bonJovi.getId());
        Assertions.assertThat((Object)loadedBonJovi).isNotNull();
        Assertions.assertThat((String)loadedBonJovi.getName()).isEqualTo((Object)"Bon Jovi");
        Assertions.assertThat((String)loadedBonJovi.getAlbums().iterator().next().getName()).isEqualTo((Object)lost.getName());
        Album loadedLost = (Album)this.session.load(Album.class, (Serializable)lost.getId());
        Assertions.assertThat((Object)loadedLost).isNotNull();
        Assertions.assertThat((String)loadedLost.getName()).isEqualTo((Object)"Lost Highway");
        Assertions.assertThat((Object)loadedLost.getGuestArtist()).isEqualTo((Object)loadedLeann);
        Assertions.assertThat((String)loadedLost.getArtist().getName()).isEqualTo((Object)loadedBonJovi.getName());
    }

    @Test
    public void shouldSaveOnlyModifiedNodes() {
        int depth = 1;
        Neo4jSession neo4jSession = (Neo4jSession)this.session;
        CompileContext context = null;
        Artist leann = new Artist("Leann Rimes");
        Album lost = new Album("Lost Highway");
        lost.setArtist(this.bonJovi);
        lost.setGuestArtist(leann);
        context = new EntityGraphMapper(neo4jSession.metaData(), neo4jSession.context()).map((Object)lost, depth);
        ((IterableAssert)Assertions.assertThat((Iterable)context.registry()).as("Should save 3 nodes and 2 relations (5 items)", new Object[0])).hasSize(5);
        this.session.save((Object)lost);
        context = new EntityGraphMapper(neo4jSession.metaData(), neo4jSession.context()).map((Object)lost, depth);
        ((IterableAssert)Assertions.assertThat((Iterable)context.registry()).as("Should have nothing to save", new Object[0])).isEmpty();
        this.session.clear();
        Artist loadedLeann = (Artist)this.session.load(Artist.class, (Serializable)leann.getId(), depth);
        context = new EntityGraphMapper(neo4jSession.metaData(), neo4jSession.context()).map((Object)loadedLeann, depth);
        ((IterableAssert)Assertions.assertThat((Iterable)context.registry()).as("Should have nothing to save", new Object[0])).isEmpty();
        loadedLeann.setName("New name");
        context = new EntityGraphMapper(neo4jSession.metaData(), neo4jSession.context()).map((Object)loadedLeann, depth);
        ((IterableAssert)Assertions.assertThat((Iterable)context.registry()).as("Should have one node to save", new Object[0])).hasSize(1);
        loadedLeann.getGuestAlbums().iterator().next().setName("New Album Name");
        context = new EntityGraphMapper(neo4jSession.metaData(), neo4jSession.context()).map((Object)loadedLeann, depth);
        ((IterableAssert)Assertions.assertThat((Iterable)context.registry()).as("Should have two node to save", new Object[0])).hasSize(2);
    }

    @Test
    public void shouldCountRelationshipEntities() {
        Album greatestHits = new Album("Greatest Hits");
        Studio chessRecordsStudios = new Studio("Chess Records");
        Studio mercuryStudios = new Studio("Mercury");
        Recording recording1 = new Recording(greatestHits, chessRecordsStudios, 1962);
        Recording recording2 = new Recording(greatestHits, mercuryStudios, 1967);
        greatestHits.setRecording(recording1);
        greatestHits.setRecording(recording2);
        this.session.save((Object)recording1);
        this.session.save((Object)recording2);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Recording.class)).isEqualTo(2L);
    }
}

